/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.masters.act;

import javax.validation.Valid;
import org.egov.mrs.masters.entity.MarriageAct;
import org.egov.mrs.masters.service.MarriageActService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class CreateActController {
    private static final String MRG_ACT_CREATE = "act-create";
    @Autowired
    private MarriageActService marriageActService;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/act/create"}, method={RequestMethod.GET})
    public String loadCreateForm(Model model) {
        model.addAttribute("marriageact", (Object)new MarriageAct());
        return MRG_ACT_CREATE;
    }

    @RequestMapping(value={"/act/create"}, method={RequestMethod.POST})
    public String createAct(@Valid @ModelAttribute MarriageAct act, BindingResult errors, RedirectAttributes redirectAttributes) {
        if (errors.hasErrors()) {
            return MRG_ACT_CREATE;
        }
        this.marriageActService.create(act);
        redirectAttributes.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.act.create.success", null, null));
        return "redirect:/masters/act/success/" + act.getId();
    }
}

