/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.application.reissue;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.enums.EmployeeStatus;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.mrs.application.MarriageUtils;
import org.egov.mrs.application.service.MarriageCertificateService;
import org.egov.mrs.application.service.workflow.RegistrationWorkflowService;
import org.egov.mrs.domain.entity.MarriageCertificate;
import org.egov.mrs.domain.entity.ReIssue;
import org.egov.mrs.domain.enums.MarriageCertificateType;
import org.egov.mrs.domain.service.MarriageApplicantService;
import org.egov.mrs.domain.service.MarriageDocumentService;
import org.egov.mrs.domain.service.MarriageRegistrationService;
import org.egov.mrs.domain.service.ReIssueService;
import org.egov.mrs.masters.service.MarriageRegistrationUnitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reissue"})
public class UpdateMrgReIssueController
extends GenericWorkFlowController {
    private static final String WORK_FLOW_ACTION = "workFlowAction";
    private static final String REISSUE_VIEW = "reissue-view";
    private static final String PENDING_ACTIONS = "pendingActions";
    private static final String IS_EMPLOYEE = "isEmployee";
    private static final String APPROVAL_POSITION = "approvalPosition";
    @Autowired
    private ReIssueService reIssueService;
    @Autowired
    private MarriageApplicantService marriageApplicantService;
    @Autowired
    private MarriageDocumentService marriageDocumentService;
    @Autowired
    protected ResourceBundleMessageSource messageSource;
    @Autowired
    private MarriageRegistrationUnitService marriageRegistrationUnitService;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private MarriageRegistrationService marriageRegistrationService;
    @Autowired
    private MarriageUtils marriageUtils;
    @Autowired
    private RegistrationWorkflowService registrationWorkflowService;
    @Autowired
    private MarriageCertificateService marriageCertificateService;
    @Autowired
    private SecurityUtils securityUtils;
    private static final Logger LOGGER = Logger.getLogger(UpdateMrgReIssueController.class);

    public void prepareNewForm(ReIssue reIssue, Model model) {
        model.addAttribute("marriageRegistrationUnit", (Object)this.marriageRegistrationUnitService.getActiveRegistrationunit());
        model.addAttribute(IS_EMPLOYEE, (Object)this.registrationWorkflowService.isEmployee(this.securityUtils.getCurrentUser()));
        model.addAttribute("documents", (Object)this.marriageDocumentService.getIndividualDocuments());
        this.marriageRegistrationService.prepareDocumentsForView(reIssue.getRegistration());
        this.marriageApplicantService.prepareDocumentsForView(reIssue.getRegistration().getHusband());
        this.marriageApplicantService.prepareDocumentsForView(reIssue.getRegistration().getWife());
        this.marriageApplicantService.prepareDocumentsForView(reIssue.getApplicant());
        model.addAttribute("applicationHistory", (Object)this.reIssueService.getHistory(reIssue));
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.GET})
    public String showReIssueForm(@PathVariable Long id, Model model) {
        ReIssue reIssue = this.reIssueService.get(id);
        this.prepareNewForm(reIssue, model);
        this.prepareWorkFlowForReIssue(reIssue, model);
        model.addAttribute("reIssue", (Object)reIssue);
        if (reIssue.getStatus().getCode().equalsIgnoreCase(ReIssue.ReIssueStatus.REJECTED.toString())) {
            return "reissue-form";
        }
        return REISSUE_VIEW;
    }

    private void prepareWorkFlowForReIssue(ReIssue reIssue, Model model) {
        WorkflowContainer workFlowContainer = new WorkflowContainer();
        if (reIssue.getStatus().getCode().equalsIgnoreCase("APPROVED")) {
            if (this.marriageUtils.isDigitalSignEnabled().booleanValue()) {
                model.addAttribute(PENDING_ACTIONS, (Object)"Digital Signature Pending");
                workFlowContainer.setPendingActions("Digital Signature Pending");
            } else {
                model.addAttribute(PENDING_ACTIONS, (Object)"Certificate Print Pending");
                workFlowContainer.setPendingActions("Certificate Print Pending");
            }
        }
        workFlowContainer.setAdditionalRule("MARRIAGE REGISTRATION");
        if ("Revenue Clerk Approved".equals(reIssue.getState().getValue()) && "Approver Approval Pending".equals(reIssue.getState().getNextAction())) {
            workFlowContainer.setPendingActions("Commisioner Approval Pending_PrintCert");
        } else if ("Revenue Clerk Approved".equals(reIssue.getState().getValue()) && ("Municipal Health Officer Approval Pending".equals(reIssue.getState().getNextAction()) || "Chief Medical Officer of Health Approval Pending".equals(reIssue.getState().getNextAction()))) {
            workFlowContainer.setPendingActions(reIssue.getState().getNextAction());
        }
        this.prepareWorkflow(model, (StateAware)reIssue, workFlowContainer);
        model.addAttribute("additionalRule", (Object)"MARRIAGE REGISTRATION");
        model.addAttribute("stateType", (Object)reIssue.getClass().getSimpleName());
        if (reIssue.getCurrentState() != null) {
            model.addAttribute("currentState", (Object)reIssue.getCurrentState().getValue());
        }
        if (reIssue.getStatus().getCode().equalsIgnoreCase("CREATED") && "Junior/Senior Assistance approval pending".equalsIgnoreCase(reIssue.getState().getNextAction()) || "Revenue Clerk Approval Pending".equalsIgnoreCase(reIssue.getState().getNextAction())) {
            model.addAttribute("nextActn", (Object)reIssue.getState().getNextAction());
            model.addAttribute("isReassignEnabled", (Object)this.marriageUtils.isReassignEnabled());
        } else {
            model.addAttribute("nextActn", (Object)reIssue.getState().getNextAction());
        }
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String updateReIssue(@RequestParam Long id, @ModelAttribute ReIssue reIssue, @ModelAttribute WorkflowContainer workflowContainer, Model model, HttpServletRequest request, BindingResult errors) throws IOException {
        String workFlowAction = "";
        if (request.getParameter(WORK_FLOW_ACTION) != null) {
            workFlowAction = request.getParameter(WORK_FLOW_ACTION);
        }
        Assignment approverAssign = null;
        if (StringUtils.isNotBlank((CharSequence)request.getParameter(APPROVAL_POSITION))) {
            approverAssign = this.assignmentService.getPrimaryAssignmentForPositon(Long.valueOf(request.getParameter(APPROVAL_POSITION)));
        }
        if (errors.hasErrors() || approverAssign != null && !EmployeeStatus.EMPLOYED.equals((Object)approverAssign.getEmployee().getEmployeeStatus())) {
            if (approverAssign != null && !EmployeeStatus.EMPLOYED.equals((Object)approverAssign.getEmployee().getEmployeeStatus())) {
                model.addAttribute("employeeAssgnNotValid", (Object)this.messageSource.getMessage("msg.emp.not.valid", (Object[])new String[]{approverAssign.getEmployee().getName().concat("~").concat(approverAssign.getDesignation().getName()), approverAssign.getEmployee().getEmployeeStatus().name()}, null));
            }
            this.prepareNewForm(reIssue, model);
            this.prepareWorkFlowForReIssue(reIssue, model);
            model.addAttribute("reIssue", (Object)reIssue);
            return REISSUE_VIEW;
        }
        String message = "";
        if (StringUtils.isNotBlank((CharSequence)workFlowAction)) {
            workflowContainer.setWorkFlowAction(workFlowAction);
            Assignment wfInitiator = this.registrationWorkflowService.getWorkFlowInitiatorForReissue(reIssue);
            String approverName = wfInitiator.getEmployee().getName();
            String nextDesignation = wfInitiator.getDesignation().getName();
            workflowContainer.setApproverComments(request.getParameter("approvalComment"));
            if (workFlowAction.equalsIgnoreCase("Reject")) {
                this.reIssueService.rejectReIssue(reIssue, workflowContainer);
                message = this.messageSource.getMessage("msg.rejected.reissue", (Object[])new String[]{reIssue.getApplicationNo(), approverName.concat("~").concat(nextDesignation)}, null);
            } else if (workFlowAction.equalsIgnoreCase("Cancel ReIssue")) {
                this.reIssueService.rejectReIssue(reIssue, workflowContainer);
                message = this.messageSource.getMessage("msg.cancelled.reissue", (Object[])new String[]{reIssue.getApplicationNo()}, null);
            } else if (workFlowAction.equalsIgnoreCase("Approve")) {
                if (this.marriageUtils.isDigitalSignEnabled().booleanValue()) {
                    model.addAttribute(PENDING_ACTIONS, (Object)"Commisioner Approval Pending_DigiSign");
                    workflowContainer.setPendingActions("Commisioner Approval Pending_DigiSign");
                    this.reIssueService.approveReIssue(reIssue, workflowContainer);
                    message = this.messageSource.getMessage("msg.approved.reissue", (Object[])new String[]{reIssue.getApplicationNo()}, null);
                } else {
                    model.addAttribute(PENDING_ACTIONS, (Object)"Commisioner Approval Pending_PrintCert");
                    workflowContainer.setPendingActions("Commisioner Approval Pending_PrintCert");
                    this.reIssueService.approveReIssue(reIssue, workflowContainer);
                    message = this.messageSource.getMessage("msg.approved.reissue", (Object[])new String[]{reIssue.getApplicationNo()}, null);
                }
            } else {
                if (workFlowAction.equalsIgnoreCase("Sign")) {
                    MarriageCertificate marriageCertificate = null;
                    List certificateReIssued = this.marriageCertificateService.getGeneratedReIssueCertificate(reIssue);
                    if (certificateReIssued != null && !certificateReIssued.isEmpty()) {
                        Iterator iterator = certificateReIssued.iterator();
                        while (iterator.hasNext()) {
                            MarriageCertificate certificateobj;
                            marriageCertificate = certificateobj = (MarriageCertificate)iterator.next();
                        }
                    } else {
                        marriageCertificate = this.reIssueService.generateReIssueCertificate(reIssue);
                    }
                    model.addAttribute("fileStoreIds", (Object)marriageCertificate.getFileStore().getFileStoreId());
                    model.addAttribute("ulbCode", (Object)ApplicationThreadLocals.getCityCode());
                    HttpSession session = request.getSession();
                    session.setAttribute("approvalComment", (Object)request.getParameter("approvalComment"));
                    session.setAttribute("applicationNumber", (Object)marriageCertificate.getReIssue().getApplicationNo());
                    HashMap<String, String> fileStoreIdsApplicationNoMap = new HashMap<String, String>();
                    fileStoreIdsApplicationNoMap.put(marriageCertificate.getFileStore().getFileStoreId(), marriageCertificate.getReIssue().getApplicationNo());
                    session.setAttribute("fileStoreIdApplicationNumber", fileStoreIdsApplicationNoMap);
                    model.addAttribute("isDigitalSignatureEnabled", (Object)this.marriageUtils.isDigitalSignEnabled());
                    return "reissue-digitalsignature";
                }
                if (workFlowAction.equalsIgnoreCase("Print Certificate")) {
                    this.reIssueService.printCertificate(reIssue, workflowContainer);
                    message = this.messageSource.getMessage("msg.printcerificate.reissue", null, null);
                } else {
                    approverName = request.getParameter("approverName");
                    nextDesignation = request.getParameter("nextDesignation");
                    workflowContainer.setApproverPositionId(Long.valueOf(request.getParameter(APPROVAL_POSITION)));
                    this.reIssueService.forwardReIssue(id, reIssue, workflowContainer);
                    message = this.messageSource.getMessage("msg.forward.reissue", (Object[])new String[]{approverName.concat("~").concat(nextDesignation), reIssue.getApplicationNo()}, null);
                }
            }
        }
        if (workFlowAction != null && !workFlowAction.isEmpty() && workFlowAction.equalsIgnoreCase("Print Certificate")) {
            return "redirect:/certificate/reissue?id=" + reIssue.getId();
        }
        model.addAttribute("message", (Object)message);
        return "reissue-ack";
    }

    @RequestMapping(value={"/digiSignWorkflow"})
    public String digiSignTransitionWorkflow(HttpServletRequest request, Model model) {
        LOGGER.debug((Object)"..........Inside Digital Signature Transition : ReIssue........");
        String fileStoreIds = request.getParameter("fileStoreId");
        LOGGER.debug((Object)("........fileStoreIds.........." + fileStoreIds));
        String[] fileStoreIdArr = fileStoreIds.split(",");
        LOGGER.debug((Object)("........fileStoreIdArr.........." + fileStoreIdArr.length));
        HttpSession session = request.getSession();
        String approvalComent = (String)session.getAttribute("approvalComment");
        Map appNoFileStoreIdsMap = (Map)session.getAttribute("fileStoreIdApplicationNumber");
        LOGGER.debug((Object)("........appNoFileStoreIdsMap....size......" + appNoFileStoreIdsMap.size()));
        ReIssue reIssueObj = null;
        for (String fileStoreId : fileStoreIdArr) {
            LOGGER.debug((Object)"........Inside for loop......");
            String applicationNumber = (String)appNoFileStoreIdsMap.get(fileStoreId);
            LOGGER.debug((Object)("........applicationNumber......" + applicationNumber));
            if (null == applicationNumber || applicationNumber.isEmpty()) continue;
            WorkflowContainer workflowContainer = new WorkflowContainer();
            workflowContainer.setApproverComments(approvalComent);
            workflowContainer.setWorkFlowAction("Sign");
            workflowContainer.setPendingActions("Digital Signature Pending");
            reIssueObj = this.reIssueService.findByApplicationNo(applicationNumber);
            this.reIssueService.digiSignCertificate(reIssueObj, workflowContainer);
        }
        LOGGER.debug((Object)"........outside for loop......");
        String message = this.messageSource.getMessage("msg.digisign.success.reissue", null, null);
        model.addAttribute("successMessage", (Object)message);
        model.addAttribute("objectType", (Object)MarriageCertificateType.REISSUE.toString());
        model.addAttribute("fileStoreId", (Object)(fileStoreIdArr.length == 1 ? fileStoreIdArr[0] : ""));
        LOGGER.debug((Object)"..........End of Digital Signature Transition : ReIssue........");
        return "mrdigitalsignature-success";
    }

    @RequestMapping(value={"/downloadSignedCertificate"})
    public void downloadReIssueDigiSignedCertificate(HttpServletRequest request, HttpServletResponse response) {
        String signedFileStoreId = request.getParameter("signedFileStoreId");
        try {
            this.marriageUtils.downloadSignedCertificate(signedFileStoreId, response);
        }
        catch (ApplicationRuntimeException ex) {
            throw new ApplicationRuntimeException("Exception while downloading file : " + (Object)((Object)ex));
        }
    }

    @RequestMapping(value={"/viewCertificate/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> viewReIssueReport(@PathVariable Long id, HttpSession session, HttpServletRequest request) throws IOException {
        return this.marriageUtils.viewReport(id, MarriageCertificateType.REISSUE.name(), session, request);
    }
}

