/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.application.reissue;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.eis.entity.Assignment;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.mrs.application.service.MarriageFeeCalculator;
import org.egov.mrs.application.service.workflow.RegistrationWorkflowService;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.ReIssue;
import org.egov.mrs.domain.service.MarriageApplicantService;
import org.egov.mrs.domain.service.MarriageDocumentService;
import org.egov.mrs.domain.service.MarriageRegistrationService;
import org.egov.mrs.domain.service.ReIssueService;
import org.egov.mrs.masters.entity.MarriageFee;
import org.egov.mrs.masters.service.MarriageRegistrationUnitService;
import org.egov.mrs.web.controller.application.registration.MarriageFormValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/reissue"})
public class NewReIssueController
extends GenericWorkFlowController {
    private static final String IS_EMPLOYEE = "isEmployee";
    private static final String APPROVAL_POSITION = "approvalPosition";
    private static final String MESSAGE = "message";
    private static final String ACKOWLEDGEMENT = "acknowledgement";
    @Autowired
    private ReIssueService reIssueService;
    @Autowired
    private MarriageRegistrationService marriageRegistrationService;
    @Autowired
    private MarriageApplicantService marriageApplicantService;
    @Autowired
    private MarriageDocumentService marriageDocumentService;
    @Autowired
    protected ResourceBundleMessageSource messageSource;
    @Autowired
    protected AppConfigValueService appConfigValuesService;
    @Autowired
    private MarriageFormValidator marriageFormValidator;
    @Autowired
    private MarriageRegistrationUnitService marriageRegistrationUnitService;
    @Autowired
    private MarriageFeeCalculator marriageFeeCalculator;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private RegistrationWorkflowService registrationWorkFlowService;

    public void prepareNewForm(Model model, ReIssue reIssue) {
        model.addAttribute("marriageRegistrationUnit", (Object)this.marriageRegistrationUnitService.getActiveRegistrationunit());
        this.marriageRegistrationService.prepareDocumentsForView(reIssue.getRegistration());
        this.marriageApplicantService.prepareDocumentsForView(reIssue.getRegistration().getHusband());
        this.marriageApplicantService.prepareDocumentsForView(reIssue.getRegistration().getWife());
        MarriageFee marriageFee = this.marriageFeeCalculator.calculateMarriageReissueFee(null, "Re-Issue Fee");
        if (marriageFee != null) {
            reIssue.setFeeCriteria(marriageFee);
            reIssue.setFeePaid(marriageFee.getFees());
        }
        this.prepareWorkFlowForReIssue(reIssue, model);
        model.addAttribute("reIssue", (Object)reIssue);
        model.addAttribute("feepaid", (Object)reIssue.getFeePaid().intValue());
        model.addAttribute("documents", (Object)this.marriageDocumentService.getIndividualDocuments());
    }

    @RequestMapping(value={"/create/{registrationId}"}, method={RequestMethod.GET})
    public String showReIssueForm(@PathVariable Long registrationId, Model model) {
        MarriageRegistration registration = this.marriageRegistrationService.get(registrationId);
        User logedinUser = this.securityUtils.getCurrentUser();
        if (registration == null) {
            model.addAttribute(MESSAGE, (Object)"msg.invalid.request");
            return "marriagecommon-error";
        }
        if (this.reIssueService.checkAnyWorkFlowInProgressForRegistration(registration)) {
            model.addAttribute(MESSAGE, (Object)"msg.workflow.alreadyPresent");
            return "marriagecommon-error";
        }
        model.addAttribute(IS_EMPLOYEE, (Object)(!"Anonymous".equalsIgnoreCase(logedinUser.getName()) && this.registrationWorkFlowService.isEmployee(logedinUser) != false ? 1 : 0));
        model.addAttribute("citizenPortalUser", (Object)this.registrationWorkFlowService.isCitizenPortalUser(this.securityUtils.getCurrentUser()));
        ReIssue reIssue = new ReIssue();
        reIssue.setRegistration(registration);
        this.prepareNewForm(model, reIssue);
        return "reissue-form";
    }

    private void prepareWorkFlowForReIssue(ReIssue reIssue, Model model) {
        WorkflowContainer workFlowContainer = new WorkflowContainer();
        workFlowContainer.setAdditionalRule("MARRIAGE REGISTRATION");
        this.prepareWorkflow(model, (StateAware)reIssue, workFlowContainer);
        model.addAttribute("additionalRule", (Object)"MARRIAGE REGISTRATION");
        model.addAttribute("stateType", (Object)reIssue.getClass().getSimpleName());
        model.addAttribute("currentState", (Object)"NEW");
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String createReIssue(@ModelAttribute WorkflowContainer workflowContainer, @ModelAttribute ReIssue reIssue, Model model, HttpServletRequest request, BindingResult errors, RedirectAttributes redirectAttributes) {
        User logedinUser = this.securityUtils.getCurrentUser();
        boolean citizenPortalUser = this.registrationWorkFlowService.isCitizenPortalUser(this.securityUtils.getCurrentUser());
        Boolean isEmployee = !"Anonymous".equalsIgnoreCase(logedinUser.getName()) && this.registrationWorkFlowService.isEmployee(logedinUser) != false;
        this.marriageFormValidator.validateReIssue((Object)reIssue, (Errors)errors);
        boolean isAssignmentPresent = this.registrationWorkFlowService.validateAssignmentForCscUser(null, reIssue, isEmployee);
        if (!isAssignmentPresent) {
            model.addAttribute(MESSAGE, (Object)this.messageSource.getMessage("notexists.position", (Object[])new String[0], null));
            return this.buildFormOnValidation(reIssue, isEmployee, model);
        }
        if (errors.hasErrors()) {
            return this.buildFormOnValidation(reIssue, isEmployee, model);
        }
        String approverName = null;
        String nextDesignation = null;
        String message = null;
        reIssue.setRegistration(this.marriageRegistrationService.get(reIssue.getRegistration().getId()));
        this.obtainWorkflowParameters(workflowContainer, request);
        if (!isEmployee.booleanValue() || citizenPortalUser) {
            Assignment assignment = this.registrationWorkFlowService.getMappedAssignmentForCscOperator(null, reIssue);
            if (assignment != null) {
                workflowContainer.setApproverPositionId(assignment.getPosition().getId());
                approverName = assignment.getEmployee().getName();
                nextDesignation = assignment.getDesignation().getName();
            }
        } else {
            approverName = request.getParameter("approverName");
            nextDesignation = request.getParameter("nextDesignation");
        }
        String appNo = this.reIssueService.createReIssueApplication(reIssue, workflowContainer);
        if (approverName != null) {
            message = this.messageSource.getMessage("msg.reissue.forward", (Object[])new String[]{approverName.concat("~").concat(nextDesignation), appNo}, null);
        }
        model.addAttribute(MESSAGE, message);
        model.addAttribute("ackNumber", (Object)appNo);
        model.addAttribute("feepaid", (Object)reIssue.getFeePaid());
        if (!isEmployee.booleanValue()) {
            redirectAttributes.addFlashAttribute(MESSAGE, (Object)message);
            return "redirect:/reissue/reissue-certificate-ackowledgement/" + appNo;
        }
        return "reissue-ack";
    }

    private String buildFormOnValidation(ReIssue reIssue, Boolean isEmployee, Model model) {
        MarriageRegistration registration = this.marriageRegistrationService.get(reIssue.getRegistration().getId());
        reIssue.setRegistration(registration);
        this.prepareNewForm(model, reIssue);
        model.addAttribute(IS_EMPLOYEE, (Object)isEmployee);
        Double fees = reIssue.getFeePaid();
        reIssue.setFeePaid(fees);
        return "reissue-form";
    }

    @RequestMapping(value={"/workflow"}, method={RequestMethod.POST})
    public String handleWorkflowAction(@ModelAttribute ReIssue reIssue, @ModelAttribute WorkflowContainer workflowContainer, Model model, HttpServletRequest request, BindingResult errors) throws IOException {
        String message = "";
        ReIssue reIssueResult = null;
        if (errors.hasErrors()) {
            return "reissue-view";
        }
        this.obtainWorkflowParameters(workflowContainer, request);
        if ("Forward".equals(workflowContainer.getWorkFlowAction())) {
            reIssueResult = this.reIssueService.forwardReIssue(reIssue.getId(), reIssue, workflowContainer);
            String approverName = request.getParameter("approverName");
            String nextDesignation = request.getParameter("nextDesignation");
            message = this.messageSource.getMessage("msg.reissue.forward", (Object[])new String[]{approverName.concat("~").concat(nextDesignation), reIssueResult.getApplicationNo()}, null);
        } else if ("Cancel ReIssue".equals(workflowContainer.getWorkFlowAction())) {
            reIssueResult = this.reIssueService.rejectReIssue(reIssue, workflowContainer);
            message = this.messageSource.getMessage("msg.cancelled.reissue", null, null);
        }
        if (workflowContainer.getWorkFlowAction() != null && !workflowContainer.getWorkFlowAction().isEmpty() && workflowContainer.getWorkFlowAction().equalsIgnoreCase("Cancel ReIssue")) {
            List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("Marriage Registration", "REISSUE_PRINTREJECTIONCERTIFICATE");
            if (reIssueResult != null && appConfigValues != null && !appConfigValues.isEmpty() && "YES".equalsIgnoreCase(((AppConfigValues)appConfigValues.get(0)).getValue())) {
                return "redirect:/certificate/reissue?id=" + reIssueResult.getId();
            }
        }
        if (reIssueResult != null) {
            model.addAttribute("ackNumber", (Object)reIssueResult.getApplicationNo());
        }
        model.addAttribute(MESSAGE, (Object)message);
        return "reissue-ack";
    }

    private void obtainWorkflowParameters(WorkflowContainer workflowContainer, HttpServletRequest request) {
        if (request.getParameter("approvalComent") != null) {
            workflowContainer.setApproverComments(request.getParameter("approvalComent"));
        }
        if (request.getParameter("workFlowAction") != null) {
            workflowContainer.setWorkFlowAction(request.getParameter("workFlowAction"));
        }
        if (request.getParameter(APPROVAL_POSITION) != null && !request.getParameter(APPROVAL_POSITION).isEmpty()) {
            workflowContainer.setApproverPositionId(Long.valueOf(request.getParameter(APPROVAL_POSITION)));
        }
    }

    @RequestMapping(value={"/reissue-certificate-ackowledgement/{applnNo}"}, method={RequestMethod.GET})
    public String showAcknowledgemnt(@PathVariable String applnNo, Model model) {
        User logedinUser = this.securityUtils.getCurrentUser();
        model.addAttribute("applicationNo", (Object)applnNo);
        model.addAttribute("applnType", (Object)"REISSUE");
        model.addAttribute("isOnlineApplication", (Object)"Anonymous".equalsIgnoreCase(logedinUser.getName()));
        return ACKOWLEDGEMENT;
    }

    @RequestMapping(value={"/printreissuecertificateack"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> printAck(@RequestParam(value="applnNo") String applnNo, Model model, HttpServletRequest request) {
        byte[] reportOutput;
        String cityMunicipalityName = (String)request.getSession().getAttribute("citymunicipalityname");
        String cityName = (String)request.getSession().getAttribute("cityname");
        ReIssue reIssue = this.reIssueService.findByApplicationNo(applnNo);
        if (reIssue != null && (reportOutput = this.marriageRegistrationService.getReportParamsForAcknowdgementForMrgReissue(reIssue, cityMunicipalityName, cityName).getReportOutputData()) != null) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            headers.add("content-disposition", "inline;filename=marriage-duplicate-certificate-ack.pdf");
            return new ResponseEntity((Object)reportOutput, (MultiValueMap)headers, HttpStatus.CREATED);
        }
        return null;
    }
}

