/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.application.registration;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.mrs.application.service.MarriageFeeCalculator;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.web.controller.application.registration.MarriageFormValidator;
import org.egov.mrs.web.controller.application.registration.MarriageRegistrationController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/registration"})
public class MarriageRegDataEntryController
extends MarriageRegistrationController {
    private static final String DATAENTRY = "DATAENTRY";
    @Autowired
    private MarriageFormValidator marriageFormValidator;
    @Autowired
    private MarriageFeeCalculator marriageFeeCalculator;

    @RequestMapping(value={"/createdataentry"}, method={RequestMethod.GET})
    public String showRegistration(Model model) {
        MarriageRegistration marriageRegistration = new MarriageRegistration();
        marriageRegistration.setFeePaid(this.marriageFeeCalculator.calculateMarriageRegistrationFee(marriageRegistration, new Date()));
        model.addAttribute("marriageRegistration", (Object)marriageRegistration);
        model.addAttribute("currentState", (Object)DATAENTRY);
        return "mrgreg-dataentryform";
    }

    @RequestMapping(value={"/createdataentry"}, method={RequestMethod.POST})
    public String register(@ModelAttribute MarriageRegistration marriageRegistration, Model model, HttpServletRequest request, BindingResult errors) {
        this.marriageFormValidator.validate((Object)marriageRegistration, (Errors)errors, DATAENTRY);
        if (errors.hasErrors()) {
            model.addAttribute("currentState", (Object)DATAENTRY);
            return "mrgreg-dataentryform";
        }
        String appNo = this.marriageRegistrationService.createDataEntryMrgRegistration(marriageRegistration);
        model.addAttribute("ackNumber", (Object)appNo);
        model.addAttribute("registrationNo", (Object)marriageRegistration.getRegistrationNo());
        return "registration-ack";
    }

    @RequestMapping(value={"/checkUniqueAppl-RegNo"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public boolean uniqueApplRegNo(@RequestParam String applicationNo, @RequestParam String registrationNo) {
        MarriageRegistration registration;
        MarriageRegistration marriageRegistration = registration = StringUtils.isNotBlank((CharSequence)applicationNo) ? this.marriageRegistrationService.findByApplicationNo(applicationNo) : this.marriageRegistrationService.findByRegistrationNo(registrationNo);
        return registration == null;
    }
}

