/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.application.registration;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.mrs.domain.entity.MarriageReassignInfo;
import org.egov.mrs.domain.service.MarriageReassignService;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/reassignmrs/{appId}/{applicationtype}"})
public class MarriageReassignController
extends GenericWorkFlowController {
    private static final String REASSIGN_SUCCESS = "reassign-success";
    private static final String MARRIAGE_REASSIGN = "marriage-reassign";
    private static final String SUCCESSMESSAGE = "successMessage";
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private MarriageReassignService marriageReassignService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    protected ResourceBundleMessageSource messageSource;

    @ModelAttribute
    public MarriageReassignInfo reassign() {
        return new MarriageReassignInfo();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String getReassign(@ModelAttribute(value="reassign") MarriageReassignInfo reassignInfo, Model model, @PathVariable String applicationtype, @PathVariable Long appId, HttpServletRequest request) {
        Map employeeWithPosition = this.marriageReassignService.employeePositionMap();
        if (employeeWithPosition.isEmpty()) {
            model.addAttribute("message", (Object)this.messageSource.getMessage("notexists.position", (Object[])new String[0], null));
        } else {
            model.addAttribute("assignments", (Object)employeeWithPosition);
        }
        reassignInfo.setApplicationId(appId);
        reassignInfo.setStateType(applicationtype);
        return MARRIAGE_REASSIGN;
    }

    @RequestMapping(method={RequestMethod.POST})
    public String update(@ModelAttribute(value="reassign") MarriageReassignInfo marriageReassignInfo, Model model, @Valid BindingResult errors, HttpServletRequest request) {
        Long positionId = Long.valueOf(request.getParameter("approvalPosition"));
        Position position = this.positionMasterService.getPositionById(positionId);
        Assignment assignment = (Assignment)this.assignmentService.getAssignmentsForPosition(positionId).get(0);
        String appNo = this.marriageReassignService.getStateObject(marriageReassignInfo, position);
        if (StringUtils.isNotEmpty((CharSequence)appNo)) {
            String successMessage = "Marriage application with reference number : " + appNo + " successfully re-assigned to " + assignment.getEmployee().getName() + "~" + assignment.getDesignation().getName() + ":" + assignment.getDepartment().getCode();
            model.addAttribute(SUCCESSMESSAGE, (Object)successMessage);
        } else {
            model.addAttribute(SUCCESSMESSAGE, (Object)"Reassign Failed!");
        }
        return REASSIGN_SUCCESS;
    }
}

