/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.mrs.domain.entity.MarriageCertificate;
import org.egov.mrs.domain.entity.MarriageRegistration;

public class MarriageRegistrationJsonAdaptor
implements JsonSerializer<MarriageRegistration> {
    public JsonElement serialize(MarriageRegistration registration, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (registration != null) {
            jsonObject.addProperty("registrationNo", (String)StringUtils.defaultIfBlank((CharSequence)registration.getRegistrationNo(), (CharSequence)"N/A"));
            jsonObject.addProperty("applicationNo", (String)StringUtils.defaultIfBlank((CharSequence)registration.getApplicationNo(), (CharSequence)"N/A"));
            jsonObject.addProperty("registrationDate", (String)StringUtils.defaultIfBlank((CharSequence)DateUtils.toDefaultDateFormat((Date)registration.getApplicationDate()), (CharSequence)"N/A"));
            jsonObject.addProperty("dateOfMarriage", (String)StringUtils.defaultIfBlank((CharSequence)DateUtils.toDefaultDateFormat((Date)registration.getDateOfMarriage()), (CharSequence)"N/A"));
            jsonObject.addProperty("remarks", (String)StringUtils.defaultIfBlank((CharSequence)registration.getRejectionReason(), (CharSequence)"N/A"));
            jsonObject.addProperty("applicationType", (String)StringUtils.defaultIfBlank((CharSequence)registration.getStateType(), (CharSequence)"N/A"));
            jsonObject.addProperty("husbandName", (String)StringUtils.defaultIfBlank((CharSequence)registration.getHusband().getFullName(), (CharSequence)"N/A"));
            jsonObject.addProperty("husbandreligion", (String)StringUtils.defaultIfBlank((CharSequence)registration.getHusband().getReligion().getName(), (CharSequence)"N/A"));
            jsonObject.addProperty("husbandMaritalStatus", (String)StringUtils.defaultIfBlank((CharSequence)registration.getHusband().getMaritalStatus().toString(), (CharSequence)"N/A"));
            jsonObject.addProperty("wifeName", (String)StringUtils.defaultIfBlank((CharSequence)registration.getWife().getFullName(), (CharSequence)"N/A"));
            jsonObject.addProperty("wifereligion", (String)StringUtils.defaultIfBlank((CharSequence)registration.getWife().getReligion().getName(), (CharSequence)"N/A"));
            jsonObject.addProperty("wifeMaritalStatus", (String)StringUtils.defaultIfBlank((CharSequence)registration.getWife().getMaritalStatus().toString(), (CharSequence)"N/A"));
            jsonObject.addProperty("zone", (String)StringUtils.defaultIfBlank((CharSequence)registration.getZone().getName(), (CharSequence)"N/A"));
            jsonObject.addProperty("marriageRegistrationUnit", (String)StringUtils.defaultIfBlank((CharSequence)registration.getMarriageRegistrationUnit().getName(), (CharSequence)"N/A"));
            if (registration.getMarriageCertificate().isEmpty()) {
                jsonObject.addProperty("certificateIssued", "No");
            } else if (((MarriageCertificate)registration.getMarriageCertificate().get(0)).isCertificateIssued()) {
                jsonObject.addProperty("certificateIssued", "Yes");
            }
            if (registration.getStatus() != null) {
                jsonObject.addProperty("status", registration.getStatus().getDescription());
            } else {
                jsonObject.addProperty("status", "N/A");
            }
            if (registration.getFeePaid() != null) {
                jsonObject.addProperty("feePaid", (Number)registration.getFeePaid());
            } else {
                jsonObject.addProperty("feePaid", "N/A");
            }
            if (!registration.isFeeCollected()) {
                jsonObject.addProperty("feeCollected", "No");
                jsonObject.addProperty("feeCollectionPending", Boolean.valueOf(true));
            } else {
                jsonObject.addProperty("feeCollected", "Yes");
            }
            jsonObject.addProperty("id", (Number)registration.getId());
        }
        return jsonObject;
    }
}

