/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.mrs.domain.entity.MarriageCertificate;
import org.egov.mrs.domain.entity.ReIssue;

public class MarriageReIssueJsonAdaptor
implements JsonSerializer<ReIssue> {
    public JsonElement serialize(ReIssue reIssue, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (reIssue != null) {
            jsonObject.addProperty("registrationNo", (String)StringUtils.defaultIfBlank((CharSequence)reIssue.getRegistration().getRegistrationNo(), (CharSequence)"N/A"));
            jsonObject.addProperty("applicationNo", (String)StringUtils.defaultIfBlank((CharSequence)reIssue.getApplicationNo(), (CharSequence)"N/A"));
            jsonObject.addProperty("registrationDate", (String)StringUtils.defaultIfBlank((CharSequence)DateUtils.toDefaultDateFormat((Date)reIssue.getApplicationDate()), (CharSequence)"N/A"));
            jsonObject.addProperty("dateOfMarriage", (String)StringUtils.defaultIfBlank((CharSequence)DateUtils.toDefaultDateFormat((Date)reIssue.getRegistration().getDateOfMarriage()), (CharSequence)"N/A"));
            jsonObject.addProperty("husbandName", (String)StringUtils.defaultIfBlank((CharSequence)reIssue.getRegistration().getHusband().getFullName(), (CharSequence)"N/A"));
            jsonObject.addProperty("wifeName", (String)StringUtils.defaultIfBlank((CharSequence)reIssue.getRegistration().getWife().getFullName(), (CharSequence)"N/A"));
            jsonObject.addProperty("remarks", (String)StringUtils.defaultIfBlank((CharSequence)reIssue.getRejectionReason(), (CharSequence)"N/A"));
            jsonObject.addProperty("zone", (String)StringUtils.defaultIfBlank((CharSequence)reIssue.getRegistration().getZone().getName(), (CharSequence)"N/A"));
            jsonObject.addProperty("marriageRegistrationUnit", (String)StringUtils.defaultIfBlank((CharSequence)reIssue.getRegistration().getMarriageRegistrationUnit().getName(), (CharSequence)"N/A"));
            if (reIssue.getMarriageCertificate().isEmpty()) {
                jsonObject.addProperty("certificateIssued", "No");
            } else if (((MarriageCertificate)reIssue.getMarriageCertificate().get(0)).isCertificateIssued()) {
                jsonObject.addProperty("certificateIssued", "Yes");
            }
            if (reIssue.getStatus() != null) {
                jsonObject.addProperty("status", reIssue.getStatus().getDescription());
            } else {
                jsonObject.addProperty("status", "");
            }
            if (reIssue.getFeePaid() != null) {
                jsonObject.addProperty("feePaid", (Number)reIssue.getFeePaid());
            } else {
                jsonObject.addProperty("feePaid", "");
            }
            if (!reIssue.isFeeCollected()) {
                jsonObject.addProperty("feeCollected", "No");
            } else {
                jsonObject.addProperty("feeCollected", "Yes");
            }
            jsonObject.addProperty("id", (Number)reIssue.getId());
        }
        return jsonObject;
    }
}

