/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.reports;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.utils.JsonUtils;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.entity.es.MarriageRegIndexSearchResult;
import org.egov.mrs.entity.es.MarriageRegistrationIndex;
import org.egov.mrs.service.es.MarriageRegistrationIndexService;
import org.egov.mrs.web.adaptor.HandicappedReportJsonAdaptor;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report"})
public class HandicappedMarriageRegReportController {
    private static final String HANDICAPPED_MARRIAGE_REPORT = "handicapped-marriage-report";
    @Autowired
    private CityService cityService;
    @Autowired
    private MarriageRegistrationIndexService marriageRegistrationIndexService;

    @RequestMapping(value={"/handicapped-report"}, method={RequestMethod.GET})
    public String searchHandicappedApplications(Model model) throws ParseException {
        return HANDICAPPED_MARRIAGE_REPORT;
    }

    private List<MarriageRegistrationIndex> getSearchResult(String applicantType) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        String ulbName = "";
        if (cityWebsite != null) {
            ulbName = cityWebsite.getName();
        }
        BoolQueryBuilder boolQuery = this.marriageRegistrationIndexService.getQueryFilterForHandicap(applicantType, ulbName);
        return this.marriageRegistrationIndexService.getHandicapSearchResultByBoolQuery(boolQuery);
    }

    @RequestMapping(value={"/handicapped-report-search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String showHandicappedApplicationDetails(@RequestParam(value="applicantType") String applicantType, Model model, @ModelAttribute MarriageRegistration registration) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-YYYY");
        ArrayList<MarriageRegIndexSearchResult> searchResultFomatted = new ArrayList<MarriageRegIndexSearchResult>();
        for (MarriageRegistrationIndex mrsIndexObj : this.getSearchResult(applicantType)) {
            MarriageRegIndexSearchResult mrisr = new MarriageRegIndexSearchResult();
            mrisr.setApplicationNumber(mrsIndexObj.getApplicationNo());
            mrisr.setRegistrationNumber(mrsIndexObj.getRegistrationNo());
            mrisr.setRegistrationDate(formatter.format(mrsIndexObj.getApplicationCreatedDate()));
            mrisr.setZone(mrsIndexObj.getZone());
            mrisr.setStatus(mrsIndexObj.getApplicationStatus());
            mrisr.setMarriageDate(formatter.format(mrsIndexObj.getRegistrationDate()));
            mrisr.setHusbandName(mrsIndexObj.getHusbandName());
            mrisr.setWifeName(mrsIndexObj.getWifeName());
            searchResultFomatted.add(mrisr);
        }
        return "{\"data\":" + JsonUtils.toJSON(searchResultFomatted, MarriageRegIndexSearchResult.class, HandicappedReportJsonAdaptor.class) + "}";
    }
}

