/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.masters;

import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.RandomStringUtils;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.utils.JsonUtils;
import org.egov.mrs.masters.entity.MarriageRegistrationUnit;
import org.egov.mrs.masters.service.MarriageRegistrationUnitService;
import org.egov.mrs.web.adaptor.MarriageRegistrationUnitJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class RegistrationUnitController {
    private static final String MARRIAGE_REGISTRATION_UNIT = "marriageRegistrationUnit";
    private static final String REGISTRATIONUNIT_CREATE = "registrationunit-create";
    private static final String REGISTRATIONUNIT_RESULT = "registrationunit-result";
    private static final String REGISTRATIONUNIT_EDIT = "registrationunit-edit";
    private static final String REGISTRATIONUNIT_VIEW = "registrationunit-view";
    private static final String REGISTRATIONUNIT_SEARCH = "registrationunit-search";
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    protected AppConfigValueService appConfigValuesService;
    @Autowired
    private MarriageRegistrationUnitService marriageRegistrationUnitService;

    private void prepareNewForm(Model model) {
        AppConfigValues heirarchyType = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Marriage Registration", "MARRIAGE_REGISTRATIONUNIT_HEIRARCHYTYPE").get(0);
        AppConfigValues boundaryType = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Marriage Registration", "MARRIAGE_REGISTRATIONUNIT_BOUNDARYYTYPE").get(0);
        if (heirarchyType != null && heirarchyType.getValue() != null && !"".equals(heirarchyType.getValue()) && boundaryType != null && boundaryType.getValue() != null && !"".equals(boundaryType.getValue())) {
            model.addAttribute("zones", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName(boundaryType.getValue(), heirarchyType.getValue()));
        } else {
            model.addAttribute("zones", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("City", "ADMINISTRATION"));
        }
    }

    @RequestMapping(value={"/mrregistrationunit/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        MarriageRegistrationUnit marriageRegistrationUnit = new MarriageRegistrationUnit();
        marriageRegistrationUnit.setCode(RandomStringUtils.random((int)4, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE).toUpperCase());
        model.addAttribute(MARRIAGE_REGISTRATION_UNIT, (Object)marriageRegistrationUnit);
        return REGISTRATIONUNIT_CREATE;
    }

    @RequestMapping(value={"/mrregistrationunit/create"}, method={RequestMethod.POST})
    public String createRegistrationunit(@Valid @ModelAttribute MarriageRegistrationUnit marriageRegistrationUnit, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return REGISTRATIONUNIT_CREATE;
        }
        this.marriageRegistrationUnitService.createMrRegistrationUnit(marriageRegistrationUnit);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.registrationunit.success", null, null));
        return "redirect:/masters/mrregistrationunit/result/" + marriageRegistrationUnit.getId();
    }

    @RequestMapping(value={"/mrregistrationunit/result/{id}"}, method={RequestMethod.GET})
    public String resultRegistrationunit(@PathVariable(value="id") Long id, Model model) {
        model.addAttribute(MARRIAGE_REGISTRATION_UNIT, (Object)this.marriageRegistrationUnitService.findById(id));
        return REGISTRATIONUNIT_RESULT;
    }

    @RequestMapping(value={"/mrregistrationunit/search/{mode}"}, method={RequestMethod.GET})
    public String searchRegistrationunit(@PathVariable(value="mode") String mode, Model model) {
        MarriageRegistrationUnit marriageRegistrationUnit = new MarriageRegistrationUnit();
        this.prepareNewForm(model);
        model.addAttribute(MARRIAGE_REGISTRATION_UNIT, (Object)marriageRegistrationUnit);
        return REGISTRATIONUNIT_SEARCH;
    }

    @RequestMapping(value={"/mrregistrationunit/view/{id}"}, method={RequestMethod.GET})
    public String viewRegistrationunit(@PathVariable(value="id") Long id, Model model) {
        MarriageRegistrationUnit marriageRegistrationUnit = this.marriageRegistrationUnitService.findById(id);
        this.prepareNewForm(model);
        model.addAttribute(MARRIAGE_REGISTRATION_UNIT, (Object)marriageRegistrationUnit);
        return REGISTRATIONUNIT_VIEW;
    }

    @RequestMapping(value={"/mrregistrationunit/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearchRegistrationunit(@PathVariable(value="mode") String mode, Model model, @ModelAttribute MarriageRegistrationUnit marriageRegistrationUnit) {
        List searchResultList = this.marriageRegistrationUnitService.searchMarriageRegistrationUnit(marriageRegistrationUnit);
        return "{ \"data\":" + JsonUtils.toJSON((Collection)searchResultList, MarriageRegistrationUnit.class, MarriageRegistrationUnitJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/mrregistrationunit/edit/{id}"}, method={RequestMethod.GET})
    public String editRegistrationunit(@PathVariable(value="id") Long id, Model model) {
        this.prepareNewForm(model);
        model.addAttribute(MARRIAGE_REGISTRATION_UNIT, (Object)this.marriageRegistrationUnitService.findById(id));
        return REGISTRATIONUNIT_EDIT;
    }

    @RequestMapping(value={"/mrregistrationunit/update"}, method={RequestMethod.POST})
    public String updateRegistrationunit(@Valid @ModelAttribute MarriageRegistrationUnit marriageRegistrationUnit, BindingResult errors, RedirectAttributes redirectAttributes) {
        if (errors.hasErrors()) {
            return REGISTRATIONUNIT_EDIT;
        }
        this.marriageRegistrationUnitService.updateMrRegistrationUnit(marriageRegistrationUnit);
        redirectAttributes.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.registrationunit.update.success", null, null));
        return "redirect:/masters/mrregistrationunit/result/" + marriageRegistrationUnit.getId();
    }
}

