/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.masters;

import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.egov.infra.utils.JsonUtils;
import org.egov.mrs.masters.entity.MarriageReligion;
import org.egov.mrs.masters.service.ReligionService;
import org.egov.mrs.web.adaptor.ReligionJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class ReligionController {
    private static final String MARRIAGE_RELIGION = "marriageReligion";
    private static final String MRG_RELIGION_CREATE = "religion-create";
    private static final String MRG_RELIGION_UPDATE = "religion-update";
    private static final String MRG_RELIGION_VIEW = "religion-view";
    private static final String MRG_RELIGION_SEARCH = "religion-search";
    private static final String MRG_RELIGION_SUCCESS = "religion-success";
    @Autowired
    private ReligionService religionService;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/religion/create"}, method={RequestMethod.GET})
    public String loadCreateForm(Model model) {
        model.addAttribute(MARRIAGE_RELIGION, (Object)new MarriageReligion());
        return MRG_RELIGION_CREATE;
    }

    @RequestMapping(value={"/religion/create"}, method={RequestMethod.POST})
    public String createReligion(@Valid @ModelAttribute MarriageReligion marriageReligion, BindingResult errors, Model model, RedirectAttributes redirectAttributes) {
        if (errors.hasErrors()) {
            return MRG_RELIGION_CREATE;
        }
        this.religionService.createReligion(marriageReligion);
        redirectAttributes.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.religion.create.success", null, null));
        return "redirect:/masters/religion/success/" + marriageReligion.getId();
    }

    @RequestMapping(value={"/religion/success/{id}"}, method={RequestMethod.GET})
    public String viewReligion(@PathVariable Long id, Model model) {
        model.addAttribute(MARRIAGE_RELIGION, (Object)this.religionService.findById(id));
        return MRG_RELIGION_SUCCESS;
    }

    @RequestMapping(value={"/religion/search/{mode}"}, method={RequestMethod.GET})
    public String getSearchPage(@PathVariable(value="mode") String mode, Model model) {
        model.addAttribute(MARRIAGE_RELIGION, (Object)new MarriageReligion());
        return MRG_RELIGION_SEARCH;
    }

    @RequestMapping(value={"/religion/view/{id}"}, method={RequestMethod.GET})
    public String viewRegistrationunit(@PathVariable(value="id") Long id, Model model) {
        MarriageReligion marriageReligion = this.religionService.findById(id);
        model.addAttribute(MARRIAGE_RELIGION, (Object)marriageReligion);
        return MRG_RELIGION_VIEW;
    }

    @RequestMapping(value={"/religion/searchResult"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchReligionResult(Model model, @ModelAttribute MarriageReligion religion) {
        List searchResultList = this.religionService.searchReligions(religion);
        return "{ \"data\":" + JsonUtils.toJSON((Collection)searchResultList, MarriageReligion.class, ReligionJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/religion/edit/{id}"}, method={RequestMethod.GET})
    public String editReligion(@PathVariable(value="id") Long id, Model model) {
        model.addAttribute(MARRIAGE_RELIGION, (Object)this.religionService.findById(id));
        return MRG_RELIGION_UPDATE;
    }

    @RequestMapping(value={"/religion/update"}, method={RequestMethod.POST})
    public String updateReligion(@Valid @ModelAttribute MarriageReligion marriageReligion, BindingResult errors, RedirectAttributes redirectAttributes) {
        if (errors.hasErrors()) {
            return MRG_RELIGION_UPDATE;
        }
        this.religionService.updateReligion(marriageReligion);
        redirectAttributes.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.religion.update.success", null, null));
        return "redirect:/masters/religion/success/" + marriageReligion.getId();
    }
}

