/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.masters;

import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.egov.infra.utils.JsonUtils;
import org.egov.mrs.domain.enums.MarriageFeeCriteriaType;
import org.egov.mrs.masters.entity.MarriageFee;
import org.egov.mrs.masters.service.MarriageFeeService;
import org.egov.mrs.web.adaptor.FeeJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class MarriageFeeController {
    private static final String MARRIAGE_FEE = "marriageFee";
    private static final String MRG_FEE_CREATE = "fee-create";
    private static final String MRG_FEE_SUCCESS = "fee-success";
    private static final String MRG_FEE_SEARCH = "fee-search";
    private static final String MRG_FEE_UPDATE = "fee-update";
    private static final String MRG_FEE_VIEW = "fee-view";
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private MarriageFeeService marriageFeeService;

    @RequestMapping(value={"/fee/create"}, method={RequestMethod.GET})
    public String loadCreateForm(Model model) {
        model.addAttribute(MARRIAGE_FEE, (Object)new MarriageFee());
        return MRG_FEE_CREATE;
    }

    @RequestMapping(value={"/fee/create"}, method={RequestMethod.POST})
    public String createFee(@Valid @ModelAttribute MarriageFee marriageFee, BindingResult errors, RedirectAttributes redirectAttributes) {
        if (errors.hasErrors()) {
            return MRG_FEE_CREATE;
        }
        marriageFee.setFeeType(MarriageFeeCriteriaType.GENERAL);
        this.marriageFeeService.create(marriageFee);
        redirectAttributes.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.fee.create.success", null, null));
        return "redirect:/masters/fee/success/" + marriageFee.getId();
    }

    @RequestMapping(value={"/fee/success/{id}"}, method={RequestMethod.GET})
    public String viewFee(@PathVariable Long id, Model model) {
        model.addAttribute(MARRIAGE_FEE, (Object)this.marriageFeeService.getFee(id));
        return MRG_FEE_SUCCESS;
    }

    @RequestMapping(value={"/fee/view/{id}"}, method={RequestMethod.GET})
    public String viewRegistrationunit(@PathVariable(value="id") Long id, Model model) {
        MarriageFee marriageFee = this.marriageFeeService.getFee(id);
        model.addAttribute(MARRIAGE_FEE, (Object)marriageFee);
        return MRG_FEE_VIEW;
    }

    @RequestMapping(value={"/fee/search/{mode}"}, method={RequestMethod.GET})
    public String getSearchPage(@PathVariable(value="mode") String mode, Model model) {
        model.addAttribute("fee", (Object)new MarriageFee());
        return MRG_FEE_SEARCH;
    }

    @RequestMapping(value={"/fee/searchResult/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchFeeResult(@PathVariable(value="mode") String mode, Model model, @ModelAttribute MarriageFee fee) {
        List searchResultList = "edit".equalsIgnoreCase(mode) ? this.marriageFeeService.searchRegistrationFeesWithGeneralType(fee) : this.marriageFeeService.searchFee(fee);
        return "{ \"data\":" + JsonUtils.toJSON((Collection)searchResultList, MarriageFee.class, FeeJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/fee/edit/{id}"}, method={RequestMethod.GET})
    public String editFee(@PathVariable(value="id") Long id, Model model) {
        model.addAttribute(MARRIAGE_FEE, (Object)this.marriageFeeService.getFee(id));
        return MRG_FEE_UPDATE;
    }

    @RequestMapping(value={"/fee/update"}, method={RequestMethod.POST})
    public String updateFee(@Valid @ModelAttribute MarriageFee marriageFee, BindingResult errors, RedirectAttributes redirectAttributes) {
        if (errors.hasErrors()) {
            return MRG_FEE_UPDATE;
        }
        this.marriageFeeService.update(marriageFee);
        redirectAttributes.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.fee.update.success", null, null));
        return "redirect:/masters/fee/success/" + marriageFee.getId();
    }
}

