/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.application.reissue;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.mrs.application.MarriageUtils;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.ReIssue;
import org.egov.mrs.domain.service.MarriageApplicantService;
import org.egov.mrs.domain.service.MarriageDocumentService;
import org.egov.mrs.domain.service.MarriageRegistrationService;
import org.egov.mrs.domain.service.ReIssueService;
import org.egov.mrs.masters.service.MarriageRegistrationUnitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/reissue"})
public class ViewReIssueController
extends GenericWorkFlowController {
    private static final String APPROVAL_POSITION = "approvalPosition";
    private final ReIssueService reIssueService;
    private final MarriageRegistrationService marriageRegistrationService;
    @Autowired
    private MarriageApplicantService marriageApplicantService;
    @Autowired
    private MarriageDocumentService marriageDocumentService;
    @Autowired
    private MarriageUtils utils;
    @Autowired
    private MarriageRegistrationUnitService marriageRegistrationUnitService;

    @Autowired
    public ViewReIssueController(ReIssueService reIssueService, MarriageRegistrationService marriageRegistrationService) {
        this.reIssueService = reIssueService;
        this.marriageRegistrationService = marriageRegistrationService;
    }

    public void prepareNewForm(Model model) {
        model.addAttribute("marriageRegistrationUnit", (Object)this.marriageRegistrationUnitService.getActiveRegistrationunit());
    }

    @RequestMapping(value={"/{reIssueId}"}, method={RequestMethod.GET})
    public String viewRegistration(@PathVariable Long reIssueId, @RequestParam(required=false) String mode, Model model) throws IOException {
        String screen;
        String mode1 = null;
        ReIssue reIssue = this.reIssueService.get(reIssueId);
        this.prepareReIssueForView(model, mode1, reIssue);
        if (!reIssue.getStatus().getCode().equalsIgnoreCase(ReIssue.ReIssueStatus.APPROVED.toString())) {
            if (mode == null) {
                mode1 = this.utils.isLoggedInUserApprover() ? "view" : mode;
            }
            screen = mode1 != null && "view".equalsIgnoreCase(mode1) ? "reissue-view" : "reissue-form";
        } else {
            screen = "reissue-view";
        }
        return screen;
    }

    private void prepareReIssueForView(Model model, String mode1, ReIssue reIssue) {
        MarriageRegistration registration = reIssue.getRegistration();
        model.addAttribute("documents", (Object)this.marriageDocumentService.getReIssueApplicantDocs());
        model.addAttribute("reIssue", (Object)reIssue);
        model.addAttribute("mode", (Object)mode1);
        this.marriageRegistrationService.prepareDocumentsForView(registration);
        this.marriageApplicantService.prepareDocumentsForView(registration.getHusband());
        this.marriageApplicantService.prepareDocumentsForView(registration.getWife());
        this.marriageApplicantService.prepareDocumentsForView(reIssue.getApplicant());
        this.prepareNewForm(model);
        this.prepareWorkflow(model, (StateAware)reIssue, new WorkflowContainer());
    }

    private void obtainWorkflowParameters(WorkflowContainer workflowContainer, HttpServletRequest request) {
        if (request.getParameter("approvalComent") != null) {
            workflowContainer.setApproverComments(request.getParameter("approvalComent"));
        }
        if (request.getParameter("workFlowAction") != null) {
            workflowContainer.setWorkFlowAction(request.getParameter("workFlowAction"));
        }
        if (request.getParameter(APPROVAL_POSITION) != null && !request.getParameter(APPROVAL_POSITION).isEmpty()) {
            workflowContainer.setApproverPositionId(Long.valueOf(request.getParameter(APPROVAL_POSITION)));
        }
    }

    @RequestMapping(value={"/view/{reIssueId}"}, method={RequestMethod.GET})
    public String showReIssueApplication(@PathVariable Long reIssueId, Model model) throws IOException {
        ReIssue reIssue = this.reIssueService.get(reIssueId);
        MarriageRegistration registration = reIssue.getRegistration();
        model.addAttribute("reIssue", (Object)reIssue);
        model.addAttribute("documents", (Object)this.marriageDocumentService.getIndividualDocuments());
        this.marriageRegistrationService.prepareDocumentsForView(registration);
        this.marriageApplicantService.prepareDocumentsForView(registration.getHusband());
        this.marriageApplicantService.prepareDocumentsForView(registration.getWife());
        this.marriageApplicantService.prepareDocumentsForView(reIssue.getApplicant());
        this.prepareNewForm(model);
        this.prepareWorkflow(model, (StateAware)reIssue, new WorkflowContainer());
        return "reissue-success";
    }

    @RequestMapping(value={"/viewapplication/{applnNo}"}, method={RequestMethod.GET})
    public String viewReIssueByApplnNo(@PathVariable String applnNo, @RequestParam(required=false) String mode, Model model) throws IOException {
        if (null == applnNo) {
            model.addAttribute("message", (Object)"msg.appln.no.not.found");
            return "marriagecommon-error";
        }
        String mode1 = null;
        ReIssue reIssue = this.reIssueService.findByApplicationNo(applnNo);
        if (null == reIssue) {
            model.addAttribute("message", (Object)"msg.appln.no.data.not.found");
            return "marriagecommon-error";
        }
        this.prepareReIssueForView(model, mode1, reIssue);
        return "reissue-success";
    }
}

