/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.application.reissue;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.mrs.application.MarriageUtils;
import org.egov.mrs.application.service.MarriageCertificateService;
import org.egov.mrs.application.service.workflow.RegistrationWorkflowService;
import org.egov.mrs.domain.entity.MarriageCertificate;
import org.egov.mrs.domain.entity.ReIssue;
import org.egov.mrs.domain.enums.MarriageCertificateType;
import org.egov.mrs.domain.service.MarriageApplicantService;
import org.egov.mrs.domain.service.MarriageDocumentService;
import org.egov.mrs.domain.service.MarriageRegistrationService;
import org.egov.mrs.domain.service.ReIssueService;
import org.egov.mrs.masters.service.MarriageRegistrationUnitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reissue"})
public class UpdateMrgReIssueController
extends GenericWorkFlowController {
    @Autowired
    private ReIssueService reIssueService;
    @Autowired
    private MarriageApplicantService marriageApplicantService;
    @Autowired
    private MarriageDocumentService marriageDocumentService;
    @Autowired
    protected ResourceBundleMessageSource messageSource;
    @Autowired
    private MarriageRegistrationUnitService marriageRegistrationUnitService;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private MarriageRegistrationService marriageRegistrationService;
    @Autowired
    private MarriageUtils marriageUtils;
    @Autowired
    private RegistrationWorkflowService registrationWorkflowService;
    @Autowired
    private MarriageCertificateService marriageCertificateService;
    private static final Logger LOGGER = Logger.getLogger(UpdateMrgReIssueController.class);

    public void prepareNewForm(Model model) {
        model.addAttribute("marriageRegistrationUnit", (Object)this.marriageRegistrationUnitService.getActiveRegistrationunit());
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.GET})
    public String showReIssueForm(@PathVariable Long id, Model model) {
        ReIssue reIssue = this.reIssueService.get(id);
        model.addAttribute("documents", (Object)this.marriageDocumentService.getIndividualDocuments());
        this.marriageRegistrationService.prepareDocumentsForView(reIssue.getRegistration());
        this.marriageApplicantService.prepareDocumentsForView(reIssue.getRegistration().getHusband());
        this.marriageApplicantService.prepareDocumentsForView(reIssue.getRegistration().getWife());
        this.marriageApplicantService.prepareDocumentsForView(reIssue.getApplicant());
        model.addAttribute("applicationHistory", (Object)this.reIssueService.getHistory(reIssue));
        this.prepareNewForm(model);
        this.prepareWorkFlowForReIssue(reIssue, model);
        model.addAttribute("reIssue", (Object)reIssue);
        if (reIssue.getStatus().getCode().equalsIgnoreCase(ReIssue.ReIssueStatus.REJECTED.toString())) {
            return "reissue-form";
        }
        return "reissue-view";
    }

    private void prepareWorkFlowForReIssue(ReIssue reIssue, Model model) {
        WorkflowContainer workFlowContainer = new WorkflowContainer();
        if (reIssue.getStatus().getCode().equalsIgnoreCase("APPROVED")) {
            if (this.marriageUtils.isDigitalSignEnabled().booleanValue()) {
                model.addAttribute("pendingActions", (Object)"Digital Signature Pending");
                workFlowContainer.setPendingActions("Digital Signature Pending");
            } else {
                model.addAttribute("pendingActions", (Object)"Certificate Print Pending");
                workFlowContainer.setPendingActions("Certificate Print Pending");
            }
        }
        workFlowContainer.setAdditionalRule("MARRIAGE REGISTRATION");
        this.prepareWorkflow(model, (StateAware)reIssue, workFlowContainer);
        model.addAttribute("additionalRule", (Object)"MARRIAGE REGISTRATION");
        model.addAttribute("stateType", (Object)reIssue.getClass().getSimpleName());
        if (reIssue.getStatus().getCode().equalsIgnoreCase("CREATED") && "Junior/Senior Assistance approval pending".equalsIgnoreCase(reIssue.getState().getNextAction())) {
            model.addAttribute("nextActn", (Object)"Junior/Senior Assistance approval pending");
        }
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String updateReIssue(@RequestParam Long id, @ModelAttribute ReIssue reIssue, @ModelAttribute WorkflowContainer workflowContainer, Model model, HttpServletRequest request, BindingResult errors) throws IOException {
        String workFlowAction = "";
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (errors.hasErrors()) {
            return "reissue-view";
        }
        String message = "";
        if (workFlowAction != null && !workFlowAction.isEmpty()) {
            workflowContainer.setWorkFlowAction(workFlowAction);
            Assignment wfInitiator = this.registrationWorkflowService.getWorkFlowInitiatorForReissue(reIssue);
            String approverName = wfInitiator.getEmployee().getName();
            String nextDesignation = wfInitiator.getDesignation().getName();
            workflowContainer.setApproverComments(request.getParameter("approvalComent"));
            if (workFlowAction.equalsIgnoreCase("Reject")) {
                this.reIssueService.rejectReIssue(reIssue, workflowContainer, request);
                message = this.messageSource.getMessage("msg.rejected.reissue", (Object[])new String[]{reIssue.getApplicationNo(), approverName.concat("~").concat(nextDesignation)}, null);
            } else if (workFlowAction.equalsIgnoreCase("Cancel Registration")) {
                this.reIssueService.rejectReIssue(reIssue, workflowContainer, request);
                message = this.messageSource.getMessage("msg.cancelled.reissue", (Object[])new String[]{reIssue.getApplicationNo(), null}, null);
            } else if (workFlowAction.equalsIgnoreCase("Approve")) {
                if (this.marriageUtils.isDigitalSignEnabled().booleanValue()) {
                    model.addAttribute("pendingActions", (Object)"Commisioner Approval Pending_DigiSign");
                    workflowContainer.setPendingActions("Commisioner Approval Pending_DigiSign");
                    this.reIssueService.approveReIssue(reIssue, workflowContainer);
                    message = this.messageSource.getMessage("msg.approved.reissue", (Object[])new String[]{reIssue.getApplicationNo()}, null);
                } else {
                    model.addAttribute("pendingActions", (Object)"Commisioner Approval Pending_PrintCert");
                    workflowContainer.setPendingActions("Commisioner Approval Pending_PrintCert");
                    this.reIssueService.approveReIssue(reIssue, workflowContainer);
                    message = this.messageSource.getMessage("msg.approved.forwarded.reissue", (Object[])new String[]{reIssue.getApplicationNo(), approverName.concat("~").concat(nextDesignation)}, null);
                }
            } else {
                if (workFlowAction.equalsIgnoreCase("Sign")) {
                    MarriageCertificate marriageCertificate = null;
                    List certificateReIssued = this.marriageCertificateService.getGeneratedReIssueCertificate(reIssue);
                    if (certificateReIssued != null && !certificateReIssued.isEmpty()) {
                        Iterator iterator = certificateReIssued.iterator();
                        while (iterator.hasNext()) {
                            MarriageCertificate certificateobj;
                            marriageCertificate = certificateobj = (MarriageCertificate)iterator.next();
                        }
                    } else {
                        marriageCertificate = this.reIssueService.generateReIssueCertificate(reIssue, workflowContainer, request);
                    }
                    model.addAttribute("fileStoreIds", (Object)marriageCertificate.getFileStore().getFileStoreId());
                    model.addAttribute("ulbCode", (Object)ApplicationThreadLocals.getCityCode());
                    HttpSession session = request.getSession();
                    session.setAttribute("approvalComment", (Object)request.getParameter("approvalComent"));
                    session.setAttribute("applicationNumber", (Object)marriageCertificate.getReIssue().getApplicationNo());
                    HashMap<String, String> fileStoreIdsApplicationNoMap = new HashMap<String, String>();
                    fileStoreIdsApplicationNoMap.put(marriageCertificate.getFileStore().getFileStoreId(), marriageCertificate.getReIssue().getApplicationNo());
                    session.setAttribute("fileStoreIdApplicationNumber", fileStoreIdsApplicationNoMap);
                    model.addAttribute("isDigitalSignatureEnabled", (Object)this.marriageUtils.isDigitalSignEnabled());
                    return "reissue-digitalsignature";
                }
                if (workFlowAction.equalsIgnoreCase("Print Certificate")) {
                    this.reIssueService.printCertificate(reIssue, workflowContainer, request);
                    message = this.messageSource.getMessage("msg.printcerificate.reissue", null, null);
                } else {
                    approverName = request.getParameter("approverName");
                    nextDesignation = request.getParameter("nextDesignation");
                    workflowContainer.setApproverPositionId(Long.valueOf(request.getParameter("approvalPosition")));
                    this.reIssueService.forwardReIssue(id, reIssue, workflowContainer);
                    message = this.messageSource.getMessage("msg.forward.reissue", (Object[])new String[]{approverName.concat("~").concat(nextDesignation), reIssue.getApplicationNo()}, null);
                }
            }
        }
        if (workFlowAction != null && !workFlowAction.isEmpty() && workFlowAction.equalsIgnoreCase("Print Certificate")) {
            return "redirect:/certificate/reissue?id=" + reIssue.getId();
        }
        model.addAttribute("message", (Object)message);
        return "reissue-ack";
    }

    @RequestMapping(value={"/digiSignWorkflow"})
    public String digiSignTransitionWorkflow(HttpServletRequest request, Model model) throws IOException {
        LOGGER.debug((Object)"..........Inside Digital Signature Transition : ReIssue........");
        String fileStoreIds = request.getParameter("fileStoreId");
        LOGGER.debug((Object)("........fileStoreIds.........." + fileStoreIds));
        String[] fileStoreIdArr = fileStoreIds.split(",");
        LOGGER.debug((Object)("........fileStoreIdArr.........." + fileStoreIdArr.length));
        HttpSession session = request.getSession();
        String approvalComent = (String)session.getAttribute("approvalComment");
        Map appNoFileStoreIdsMap = (Map)session.getAttribute("fileStoreIdApplicationNumber");
        LOGGER.debug((Object)("........appNoFileStoreIdsMap....size......" + appNoFileStoreIdsMap.size()));
        ReIssue reIssueObj = null;
        for (String fileStoreId : fileStoreIdArr) {
            LOGGER.debug((Object)"........Inside for loop......");
            String applicationNumber = (String)appNoFileStoreIdsMap.get(fileStoreId);
            LOGGER.debug((Object)("........applicationNumber......" + applicationNumber));
            if (null == applicationNumber || applicationNumber.isEmpty()) continue;
            WorkflowContainer workflowContainer = new WorkflowContainer();
            workflowContainer.setApproverComments(approvalComent);
            workflowContainer.setWorkFlowAction("Sign");
            workflowContainer.setPendingActions("Digital Signature Pending");
            reIssueObj = this.reIssueService.findByApplicationNo(applicationNumber);
            this.reIssueService.digiSignCertificate(reIssueObj, workflowContainer, request);
        }
        LOGGER.debug((Object)"........outside for loop......");
        Assignment wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(reIssueObj.getCreatedBy().getId());
        String message = this.messageSource.getMessage("msg.digisign.success.reissue", (Object[])new String[]{wfInitiator.getEmployee().getName().concat("~").concat(wfInitiator.getDesignation().getName())}, null);
        model.addAttribute("successMessage", (Object)message);
        model.addAttribute("objectType", (Object)MarriageCertificateType.REISSUE.toString());
        model.addAttribute("fileStoreId", (Object)(fileStoreIdArr.length == 1 ? fileStoreIdArr[0] : ""));
        LOGGER.debug((Object)"..........End of Digital Signature Transition : ReIssue........");
        return "mrdigitalsignature-success";
    }

    @RequestMapping(value={"/downloadSignedCertificate"})
    public void downloadReIssueDigiSignedCertificate(HttpServletRequest request, HttpServletResponse response) {
        String signedFileStoreId = request.getParameter("signedFileStoreId");
        try {
            this.marriageUtils.downloadSignedCertificate(signedFileStoreId, response);
        }
        catch (ApplicationRuntimeException ex) {
            throw new ApplicationRuntimeException("Exception while downloading file : " + (Object)((Object)ex));
        }
    }

    @RequestMapping(value={"/viewCertificate/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> viewReIssueReport(@PathVariable Long id, HttpSession session, HttpServletRequest request) throws IOException {
        return this.marriageUtils.viewReport(id, MarriageCertificateType.REISSUE.toString(), session, request);
    }
}

