/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.application.registration;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.egov.commons.service.EducationalQualificationService;
import org.egov.commons.service.NationalityService;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.mrs.application.MarriageConstants;
import org.egov.mrs.application.MarriageUtils;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.enums.MaritalStatus;
import org.egov.mrs.domain.enums.ReligionPractice;
import org.egov.mrs.domain.service.MarriageApplicantService;
import org.egov.mrs.domain.service.MarriageDocumentService;
import org.egov.mrs.domain.service.MarriageRegistrationService;
import org.egov.mrs.masters.service.MarriageActService;
import org.egov.mrs.masters.service.MarriageFeeService;
import org.egov.mrs.masters.service.MarriageRegistrationUnitService;
import org.egov.mrs.masters.service.ReligionService;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;

public class MarriageRegistrationController
extends GenericWorkFlowController {
    @Autowired
    protected ReligionService religionService;
    @Autowired
    protected BoundaryService boundaryService;
    @Autowired
    protected MarriageActService marriageActService;
    @Autowired
    protected MarriageRegistrationService marriageRegistrationService;
    @Autowired
    protected MarriageFeeService marriageFeeService;
    @Autowired
    protected MarriageUtils utils;
    @Autowired
    protected MarriageDocumentService marriageDocumentService;
    @Autowired
    protected ResourceBundleMessageSource messageSource;
    @Autowired
    protected MarriageApplicantService marriageApplicantService;
    @Autowired
    protected MarriageRegistrationUnitService marriageRegistrationUnitService;
    @Autowired
    protected NationalityService nationalityService;
    @Autowired
    private EducationalQualificationService educationalQualificationService;
    @Autowired
    protected AppConfigValueService appConfigValuesService;

    @ModelAttribute
    public void prepareForm(Model model) {
        this.getBoundaryTypeForRegistration(model);
        model.addAttribute("localitylist", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("locality", "LOCATION"));
        model.addAttribute("religions", (Object)this.religionService.getReligions());
        model.addAttribute("acts", (Object)this.marriageActService.getActs());
        model.addAttribute("religionPractice", Arrays.asList(ReligionPractice.values()));
        model.addAttribute("maritalStatusList", Arrays.asList(MaritalStatus.values()));
        model.addAttribute("venuelist", (Object)MarriageConstants.venuelist);
        model.addAttribute("witnessRelation", (Object)MarriageConstants.witnessRelation);
        model.addAttribute("Educationqualificationlist", (Object)this.educationalQualificationService.getActiveQualifications());
        model.addAttribute("nationalitylist", (Object)this.nationalityService.findAll());
        model.addAttribute("feesList", (Object)this.marriageFeeService.getActiveGeneralTypeFeeses());
        model.addAttribute("generalDocuments", (Object)this.marriageDocumentService.getGeneralDocuments());
        model.addAttribute("individualDocuments", (Object)this.marriageDocumentService.getIndividualDocuments());
        model.addAttribute("marriageRegistrationUnit", (Object)this.marriageRegistrationUnitService.getActiveRegistrationunit());
        AppConfigValues allowValidation = this.marriageFeeService.getDaysValidationAppConfValue("Marriage Registration", "MARRIAGEREGISTRATION_DAYS_VALIDATION");
        model.addAttribute("allowDaysValidation", (Object)(allowValidation != null && !allowValidation.getValue().isEmpty() ? allowValidation.getValue() : "NO"));
    }

    private void getBoundaryTypeForRegistration(Model model) {
        AppConfigValues heirarchyType = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Marriage Registration", "MARRIAGE_REGISTRATIONUNIT_HEIRARCHYTYPE").get(0);
        AppConfigValues boundaryType = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Marriage Registration", "MARRIAGE_REGISTRATIONUNIT_BOUNDARYYTYPE").get(0);
        if (heirarchyType != null && heirarchyType.getValue() != null && !"".equals(heirarchyType.getValue()) && boundaryType != null && boundaryType.getValue() != null && !"".equals(boundaryType.getValue())) {
            model.addAttribute("zones", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName(boundaryType.getValue(), heirarchyType.getValue()));
        } else {
            model.addAttribute("zones", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("City", "ADMINISTRATION"));
        }
    }

    public void validateApplicationDate(MarriageRegistration registration, BindingResult errors, HttpServletRequest request) {
        AppConfigValues allowValidation = this.marriageFeeService.getDaysValidationAppConfValue("Marriage Registration", "MARRIAGEREGISTRATION_DAYS_VALIDATION");
        if (allowValidation != null && !allowValidation.getValue().isEmpty() && "YES".equalsIgnoreCase(allowValidation.getValue()) && registration.getDateOfMarriage() != null && !registration.isLegacy()) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            if (!new DateTime((Object)new Date()).isBefore((ReadableInstant)new DateTime((Object)registration.getDateOfMarriage()).plusDays(Integer.parseInt("90") - 1))) {
                errors.reject("err.validate.marriageRegistration.applicationDate", (Object[])new String[]{sdf.format(registration.getDateOfMarriage())}, null);
            }
        }
    }
}

