/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.masters.act;

import java.util.Collection;
import java.util.List;
import org.egov.infra.utils.JsonUtils;
import org.egov.mrs.masters.entity.MarriageAct;
import org.egov.mrs.masters.service.MarriageActService;
import org.egov.mrs.web.adaptor.ActJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/masters"})
public class ViewActController {
    private static final String MRG_ACT_SUCCESS = "act-success";
    private static final String MRG_ACT_SEARCH = "act-search";
    private static final String MRG_ACT_VIEW = "act-view";
    @Autowired
    private MarriageActService marriageActService;

    @RequestMapping(value={"/act/success/{id}"}, method={RequestMethod.GET})
    public String viewAct(@PathVariable Long id, Model model) {
        model.addAttribute("marriageAct", (Object)this.marriageActService.getAct(id));
        return MRG_ACT_SUCCESS;
    }

    @RequestMapping(value={"/act/view/{id}"}, method={RequestMethod.GET})
    public String viewRegistrationunit(@PathVariable(value="id") Long id, Model model) {
        MarriageAct marriageAct = this.marriageActService.getAct(id);
        model.addAttribute("marriageAct", (Object)marriageAct);
        return MRG_ACT_VIEW;
    }

    @RequestMapping(value={"/act/search/{mode}"}, method={RequestMethod.GET})
    public String getSearchPage(@PathVariable(value="mode") String mode, Model model) {
        model.addAttribute("act", (Object)new MarriageAct());
        return MRG_ACT_SEARCH;
    }

    @RequestMapping(value={"/act/searchResult"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchActResult(Model model, @ModelAttribute MarriageAct act) {
        List searchResultList = this.marriageActService.searchActs(act);
        return "{ \"data\":" + JsonUtils.toJSON((Collection)searchResultList, MarriageAct.class, ActJsonAdaptor.class) + "}";
    }
}

