/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.masters.act;

import javax.validation.Valid;
import org.egov.mrs.masters.entity.MarriageAct;
import org.egov.mrs.masters.service.MarriageActService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class UpdateActController {
    private static final String MRG_ACT_UPDATE = "act-update";
    @Autowired
    private MarriageActService marriageActService;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/act/edit/{id}"}, method={RequestMethod.GET})
    public String editAct(@PathVariable(value="id") Long id, Model model) {
        model.addAttribute("marriageAct", (Object)this.marriageActService.getAct(id));
        return MRG_ACT_UPDATE;
    }

    @RequestMapping(value={"/act/update"}, method={RequestMethod.POST})
    public String updateAct(@Valid @ModelAttribute MarriageAct marriageAct, BindingResult errors, RedirectAttributes redirectAttributes) {
        if (errors.hasErrors()) {
            return MRG_ACT_UPDATE;
        }
        this.marriageActService.update(marriageAct);
        redirectAttributes.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.act.update.success", null, null));
        return "redirect:/masters/act/success/" + marriageAct.getId();
    }
}

