/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.masters;

import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.egov.infra.utils.JsonUtils;
import org.egov.mrs.domain.entity.DocumentProofType;
import org.egov.mrs.domain.entity.MarriageDocument;
import org.egov.mrs.domain.enums.MarriageDocumentType;
import org.egov.mrs.domain.service.MarriageDocumentService;
import org.egov.mrs.web.adaptor.MarriageDocumentJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class DocumentController {
    private static final String MARRIAGETYPE = "marriagetype";
    private static final String MARRIAGE_DOCUMENT = "marriageDocument";
    private static final String DOCUMENT_CREATE = "document-create";
    private static final String DOCUMENT_UPDATE = "document-update";
    private static final String DOCUMENT_VIEW = "document-view";
    private static final String DOCUMENT_SEARCH = "document-search";
    private static final String DOCUMENT_SUCCESS = "document-success";
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private MarriageDocumentService marriageDocumentService;

    @RequestMapping(value={"/document/create"}, method={RequestMethod.GET})
    public String loadCreateForm(Model model) {
        model.addAttribute(MARRIAGE_DOCUMENT, (Object)new MarriageDocument());
        model.addAttribute("currentstate", (Object)"NEW");
        model.addAttribute("documentprooftype", (Object)DocumentProofType.values());
        model.addAttribute(MARRIAGETYPE, (Object)MarriageDocumentType.values());
        return DOCUMENT_CREATE;
    }

    @RequestMapping(value={"/document/create"}, method={RequestMethod.POST})
    public String createDcoument(@Valid @ModelAttribute(value="marriageDocument") MarriageDocument marriageDocument, Errors errors, Model model, RedirectAttributes redirectAttributes) {
        this.validate(errors, marriageDocument);
        if (errors.hasErrors()) {
            model.addAttribute("currentstate", (Object)"NEW");
            return DOCUMENT_CREATE;
        }
        this.marriageDocumentService.create(marriageDocument);
        redirectAttributes.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.document.create.success", null, null));
        return "redirect:/masters/document/success/" + marriageDocument.getId();
    }

    private void validate(Errors errors, MarriageDocument marriageDocument) {
        if (marriageDocument.getName() == null) {
            errors.rejectValue("name", "Notempty.mrg.Document.name");
        }
        if (marriageDocument.getCode() == null) {
            errors.rejectValue("code", "Notempty.mrg.code");
        }
        if (marriageDocument.getType() == null) {
            errors.rejectValue("type", "Notempty.mrg.Registration.type");
        }
        if (marriageDocument.getDocumentProofType() == null) {
            errors.rejectValue("documentProofType", "Notempty.mrg.Document.proof");
        }
    }

    @RequestMapping(value={"/document/success/{id}"}, method={RequestMethod.GET})
    public String documentSuccess(@PathVariable Long id, Model model) {
        model.addAttribute(MARRIAGE_DOCUMENT, (Object)this.marriageDocumentService.get(id));
        return DOCUMENT_SUCCESS;
    }

    @RequestMapping(value={"/document/search/{mode}"}, method={RequestMethod.GET})
    public String search(Model model, @PathVariable(value="mode") String mode) {
        model.addAttribute(MARRIAGE_DOCUMENT, (Object)new MarriageDocument());
        model.addAttribute(MARRIAGETYPE, (Object)MarriageDocumentType.values());
        return DOCUMENT_SEARCH;
    }

    @RequestMapping(value={"/document/view/{id}"}, method={RequestMethod.GET})
    public String viewDocument(Model model, @PathVariable(value="id") Long id) {
        model.addAttribute(MARRIAGE_DOCUMENT, (Object)this.marriageDocumentService.get(id));
        return DOCUMENT_VIEW;
    }

    @RequestMapping(value={"/document/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearchDocument(@PathVariable(value="mode") String mode, Model model, @ModelAttribute MarriageDocument marriageDocument) {
        List searchResultList = this.marriageDocumentService.searchMarriageDocument(marriageDocument);
        return "{ \"data\":" + JsonUtils.toJSON((Collection)searchResultList, MarriageDocument.class, MarriageDocumentJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/document/update/{id}"}, method={RequestMethod.GET})
    public String updateForm(Model model, @PathVariable(value="id") Long id) {
        model.addAttribute(MARRIAGE_DOCUMENT, (Object)this.marriageDocumentService.get(id));
        model.addAttribute("documentprooftype", (Object)DocumentProofType.values());
        model.addAttribute(MARRIAGETYPE, (Object)MarriageDocumentType.values());
        return DOCUMENT_UPDATE;
    }

    @RequestMapping(value={"/document/update"}, method={RequestMethod.POST})
    public String updateDocument(Model model, @Valid @ModelAttribute MarriageDocument marriageDocument, BindingResult errors, RedirectAttributes redirectAttributes) {
        this.validate((Errors)errors, marriageDocument);
        if (errors.hasErrors()) {
            return DOCUMENT_UPDATE;
        }
        this.marriageDocumentService.updateDocument(marriageDocument);
        redirectAttributes.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.document.update.success", null, null));
        return "redirect:/masters/document/success/" + marriageDocument.getId();
    }
}

