/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.application.registration;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.FileStoreUtils;
import org.egov.infra.utils.JsonUtils;
import org.egov.mrs.application.service.MarriageCertificateService;
import org.egov.mrs.domain.entity.MarriageCertificate;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.MarriageRegistrationSearchFilter;
import org.egov.mrs.domain.entity.ReIssue;
import org.egov.mrs.domain.enums.MarriageCertificateType;
import org.egov.mrs.domain.service.MarriageRegistrationService;
import org.egov.mrs.masters.service.MarriageRegistrationUnitService;
import org.egov.mrs.web.adaptor.MarriageCerftificateJsonAdaptor;
import org.egov.mrs.web.adaptor.MarriageReIssueJsonAdaptor;
import org.egov.mrs.web.adaptor.MarriageRegistrationJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/registration"})
public class SearchRegistrationController {
    private static final String DATA = "{ \"data\":";
    private static final String REGISTRATION = "registration";
    private final MarriageRegistrationService marriageRegistrationService;
    private final SecurityUtils securityUtils;
    @Autowired
    private MarriageCertificateService marriageCertificateService;
    @Autowired
    private FileStoreUtils fileStoreUtils;
    @Autowired
    protected MarriageRegistrationUnitService marriageRegistrationUnitService;
    @Autowired
    private AppConfigValueService appConfigValuesService;

    @Autowired
    public SearchRegistrationController(MarriageRegistrationService marriageRegistrationService, SecurityUtils securityUtils) {
        this.marriageRegistrationService = marriageRegistrationService;
        this.securityUtils = securityUtils;
    }

    public void prepareSearchForm(Model model) {
        model.addAttribute("marriageRegistrationUnit", (Object)this.marriageRegistrationUnitService.getActiveRegistrationunit());
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String showSearch(Model model) {
        List operatorRoles = this.securityUtils.getCurrentUser().getRoles().stream().filter(role -> "Collection Operator".equalsIgnoreCase(role.getName())).collect(Collectors.toList());
        model.addAttribute(REGISTRATION, (Object)new MarriageRegistration());
        boolean isCollectionOperator = operatorRoles != null && !operatorRoles.isEmpty();
        model.addAttribute("isCollectionOperator", (Object)isCollectionOperator);
        this.prepareSearchForm(model);
        return "registration-search";
    }

    @RequestMapping(value={"/searchApproved"}, method={RequestMethod.GET})
    public String showSearchApproved(Model model) {
        List operatorRoles = this.securityUtils.getCurrentUser().getRoles().stream().filter(role -> "Collection Operator".equalsIgnoreCase(role.getName())).collect(Collectors.toList());
        model.addAttribute(REGISTRATION, (Object)new MarriageRegistration());
        boolean isCollectionOperator = operatorRoles != null && !operatorRoles.isEmpty();
        model.addAttribute("isCollectionOperator", (Object)isCollectionOperator);
        this.prepareSearchForm(model);
        return "registration-search-approved";
    }

    @ModelAttribute(value="marriageRegistrationTypes")
    public List<MarriageCertificateType> mrTypeList() {
        ArrayList<MarriageCertificateType> enumValues = new ArrayList<MarriageCertificateType>();
        for (MarriageCertificateType mct : Arrays.asList(MarriageCertificateType.values())) {
            if ("REJECTION".equalsIgnoreCase(mct.name())) continue;
            enumValues.add(mct);
        }
        return enumValues;
    }

    @RequestMapping(value={"/collectmrfee"}, method={RequestMethod.GET})
    public String showSearchApprovedforFee(Model model) {
        model.addAttribute(REGISTRATION, (Object)new MarriageRegistration());
        model.addAttribute("mode", (Object)"collectmrfee");
        this.prepareSearchForm(model);
        return "registration-search-forfee";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String search(Model model, @ModelAttribute MarriageRegistration registration) throws ParseException {
        List searchResultList = this.marriageRegistrationService.searchMarriageRegistrations(registration);
        return DATA + JsonUtils.toJSON((Collection)searchResultList, MarriageRegistration.class, MarriageRegistrationJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/searchApproved"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchRegisterStatusMarriageRecords(Model model, @ModelAttribute MarriageRegistration registration) throws ParseException {
        List searchResultList = this.marriageRegistrationService.searchRegistrationByStatus(registration, MarriageRegistration.RegistrationStatus.REGISTERED.toString());
        return DATA + JsonUtils.toJSON((Collection)searchResultList, MarriageRegistration.class, MarriageRegistrationJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/collectmrfeeajaxsearch"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchMarriageRegistrationsForFeeCollection(Model model, @ModelAttribute MarriageRegistration registration) throws ParseException {
        List searchResultList = this.marriageRegistrationService.searchMarriageRegistrationsForFeeCollection(registration);
        ArrayList<MarriageRegistration> newSearchResultList = new ArrayList<MarriageRegistration>();
        for (MarriageRegistration mr : searchResultList) {
            if (mr == null || mr.isFeeCollected()) continue;
            newSearchResultList.add(mr);
        }
        return DATA + JsonUtils.toJSON(newSearchResultList, MarriageRegistration.class, MarriageRegistrationJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/collectmrreissuefeeajaxsearch"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchApprovedMarriageReIssueRecordsForFee(Model model, @ModelAttribute MarriageRegistrationSearchFilter mrSearchFilter) throws ParseException {
        List searchResultList = this.marriageRegistrationService.searchApprovedReIssueRecordsForFeeCollection(mrSearchFilter);
        ArrayList<ReIssue> newSearchResultList = new ArrayList<ReIssue>();
        for (ReIssue mrr : searchResultList) {
            if (mrr == null || mrr.isFeeCollected()) continue;
            newSearchResultList.add(mrr);
        }
        return DATA + JsonUtils.toJSON(newSearchResultList, ReIssue.class, MarriageReIssueJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/searchregisteredrecord"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchRegisteredStatusMarriageRecords(Model model, @ModelAttribute MarriageRegistration registration) throws ParseException {
        List searchResultList = this.marriageRegistrationService.searchRegistrationByStatus(registration, MarriageRegistration.RegistrationStatus.REGISTERED.toString());
        return DATA + JsonUtils.toJSON((Collection)searchResultList, MarriageRegistration.class, MarriageRegistrationJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/reissuecertificate"}, method={RequestMethod.GET})
    public String reissueCertificateSearch(Model model, HttpServletRequest request) {
        model.addAttribute(REGISTRATION, (Object)new MarriageRegistration());
        this.prepareSearchForm(model);
        return "registration-search-certificateissue";
    }

    @RequestMapping(value={"/searchcertificates"}, method={RequestMethod.GET})
    public String showReportForm(Model model) {
        model.addAttribute("certificate", (Object)new MarriageCertificate());
        model.addAttribute("certificateType", (Object)MarriageCertificateType.values());
        return "registration-search-certificate";
    }

    @RequestMapping(value={"/searchcertificates"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchApprovedMarriageRecords(Model model, @ModelAttribute MarriageCertificate certificate) {
        List searchResultList = this.marriageCertificateService.searchMarriageCertificates(certificate);
        int noOfToDaysToPrint = 0;
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("Marriage Registration", "NOOFDAYSTOPRINT");
        if (appConfigValues != null && ((AppConfigValues)appConfigValues.get(0)).getValue() != null) {
            noOfToDaysToPrint = Integer.parseInt(((AppConfigValues)appConfigValues.get(0)).getValue().toString());
        }
        for (MarriageCertificate certficateobj : searchResultList) {
            certficateobj.setPrintCertificateResrictionDays(noOfToDaysToPrint);
        }
        return DATA + JsonUtils.toJSON((Collection)searchResultList, MarriageCertificate.class, MarriageCerftificateJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/printcertficate/{id}"})
    public void download(@PathVariable long id, HttpServletResponse response) throws IOException {
        MarriageCertificate certificate = this.marriageCertificateService.findById(id);
        this.fileStoreUtils.fetchFileAndWriteToStream(certificate.getFileStore().getFileStoreId(), "MRS", false, response);
    }
}

