/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.application.registration;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.egov.mrs.domain.entity.MarriageDocument;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.ReIssue;
import org.egov.mrs.domain.service.MarriageDocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component
public class MarriageFormValidator
implements Validator {
    private static final String VALIDATE_MOBILE_NO = "validate.mobile.no";
    private static final String VALIDATE_EMAIL = "validate.email";
    private static final String NOTEMPTY_MRG_WITNESS_AGE = "Notempty.mrg.witness.age";
    private static final String NOTEMPTY_MRG_WITNESS_PARENT = "Notempty.mrg.witness.parent";
    private static final String NOTEMPTY_MRG_RESIDENCE_ADDRESS = "Notempty.mrg.residence.address";
    private static final String NOTEMPTY_MRG_OFFICE_ADDRESS = "Notempty.mrg.office.address";
    private static final String NOTEMPTY_MRG_FIRST_NAME = "Notempty.mrg.first.name";
    private static final String NOTEMPTY_MRG_CITY = "Notempty.mrg.city";
    private static final String NOTEMPTY_MRG_LOCALITY = "Notempty.mrg.locality";
    private static final String NOTEMPTY_MRG_STREET = "Notempty.mrg.street";
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private static final String MOBILE_PATTERN = "[0-9]{10}";
    private Pattern pattern;
    private Matcher matcher;
    @Autowired
    private MarriageDocumentService marriageDocumentService;

    public boolean supports(Class<?> clazz) {
        return MarriageRegistration.class.equals(clazz);
    }

    public void validateReIssue(Object target, Errors errors) {
        ReIssue reIssue = (ReIssue)target;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"marriageRegistrationUnit", (String)"Notempty.regUnit.name");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"applicant.name.firstName", (String)NOTEMPTY_MRG_FIRST_NAME);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"applicant.contactInfo.residenceAddress", (String)NOTEMPTY_MRG_RESIDENCE_ADDRESS);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"applicant.contactInfo.officeAddress", (String)NOTEMPTY_MRG_OFFICE_ADDRESS);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"applicant.contactInfo.mobileNo", (String)"Notempty.mrg.mobile.no");
        if (reIssue.getFeePaid() == null) {
            errors.reject("Notempty.reissue.fee", null);
        }
        if (reIssue.getApplicant() != null && reIssue.getApplicant().getContactInfo() != null && reIssue.getApplicant().getContactInfo().getMobileNo() != null) {
            this.pattern = Pattern.compile(MOBILE_PATTERN);
            this.matcher = this.pattern.matcher(reIssue.getApplicant().getContactInfo().getMobileNo());
            if (!this.matcher.matches()) {
                errors.rejectValue("applicant.contactInfo.mobileNo", VALIDATE_MOBILE_NO);
            }
        }
        if (reIssue.getApplicant() != null && reIssue.getApplicant().getContactInfo() != null && reIssue.getApplicant().getContactInfo().getEmail() != null) {
            this.pattern = Pattern.compile(EMAIL_PATTERN);
            this.matcher = this.pattern.matcher(reIssue.getApplicant().getContactInfo().getEmail());
            if (!this.matcher.matches()) {
                errors.rejectValue("applicant.contactInfo.email", VALIDATE_EMAIL);
            }
        }
    }

    public void validate(Object target, Errors errors, String type) {
        MarriageRegistration registration = (MarriageRegistration)target;
        if (type != null && "DATAENTRY".equals(type)) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"applicationNo", (String)"Notempty.mrg.appln.no");
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"registrationNo", (String)"Notempty.mrg.reg.no");
            this.validateSerialAndPageNo(errors);
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"marriageRegistrationUnit", (String)"Notempty.regUnit.name");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"street", (String)NOTEMPTY_MRG_STREET);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"locality", (String)NOTEMPTY_MRG_LOCALITY);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"city", (String)NOTEMPTY_MRG_CITY);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"dateOfMarriage", (String)"Notempty.mrg.date.of.mrg");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"venue", (String)"Notempty.mrg.venue");
        if (!"Residence".equals(registration.getVenue())) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"placeOfMarriage", (String)"Notempty.mrg.place.of.mrg");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"husband.name.firstName", (String)NOTEMPTY_MRG_FIRST_NAME);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"husband.religion", (String)"Notempty.mrg.religion.name");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"husband.ageInYearsAsOnMarriage", (String)"Notempty.mrg.age.year");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"husband.ageInMonthsAsOnMarriage", (String)"Notempty.mrg.age.month");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"husband.maritalStatus", (String)"Notempty.mrg.marital.status");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"husband.occupation", (String)"Notempty.mrg.occupation");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"husband.parentsName", (String)"Notempty.mrg.parents.name");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"husband.qualification", (String)"Notempty.mrg.education.qualification");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"husband.nationality", (String)"Notempty.mrg.nationality");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"husband.street", (String)NOTEMPTY_MRG_STREET);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"husband.locality", (String)NOTEMPTY_MRG_LOCALITY);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"husband.city", (String)NOTEMPTY_MRG_CITY);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"husband.contactInfo.residenceAddress", (String)NOTEMPTY_MRG_RESIDENCE_ADDRESS);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"husband.contactInfo.officeAddress", (String)NOTEMPTY_MRG_RESIDENCE_ADDRESS);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"wife.name.firstName", (String)NOTEMPTY_MRG_FIRST_NAME);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"wife.religion", (String)"Notempty.mrg.religion.name");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"wife.ageInYearsAsOnMarriage", (String)"Notempty.mrg.age.year");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"wife.ageInMonthsAsOnMarriage", (String)"Notempty.mrg.age.month");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"wife.maritalStatus", (String)"Notempty.mrg.marital.status");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"wife.occupation", (String)"Notempty.mrg.occupation");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"wife.parentsName", (String)"Notempty.mrg.parents.name");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"wife.qualification", (String)"Notempty.mrg.education.qualification");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"wife.nationality", (String)"Notempty.mrg.nationality");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"wife.street", (String)NOTEMPTY_MRG_STREET);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"wife.locality", (String)NOTEMPTY_MRG_LOCALITY);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"wife.city", (String)NOTEMPTY_MRG_CITY);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"wife.contactInfo.residenceAddress", (String)NOTEMPTY_MRG_RESIDENCE_ADDRESS);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"wife.contactInfo.officeAddress", (String)NOTEMPTY_MRG_RESIDENCE_ADDRESS);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[0].name.firstName", (String)NOTEMPTY_MRG_FIRST_NAME);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[0].witnessRelation", (String)NOTEMPTY_MRG_FIRST_NAME);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[0].relativeName", (String)NOTEMPTY_MRG_WITNESS_PARENT);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[0].age", (String)NOTEMPTY_MRG_WITNESS_AGE);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[0].contactInfo.residenceAddress", (String)NOTEMPTY_MRG_RESIDENCE_ADDRESS);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[1].name.firstName", (String)NOTEMPTY_MRG_FIRST_NAME);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[1].witnessRelation", (String)NOTEMPTY_MRG_FIRST_NAME);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[1].relativeName", (String)NOTEMPTY_MRG_WITNESS_PARENT);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[1].age", (String)NOTEMPTY_MRG_WITNESS_AGE);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[1].contactInfo.residenceAddress", (String)NOTEMPTY_MRG_RESIDENCE_ADDRESS);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[2].name.firstName", (String)NOTEMPTY_MRG_FIRST_NAME);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[2].witnessRelation", (String)NOTEMPTY_MRG_FIRST_NAME);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[2].relativeName", (String)NOTEMPTY_MRG_WITNESS_PARENT);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[2].age", (String)NOTEMPTY_MRG_WITNESS_AGE);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[2].contactInfo.residenceAddress", (String)NOTEMPTY_MRG_RESIDENCE_ADDRESS);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[3].name.firstName", (String)NOTEMPTY_MRG_FIRST_NAME);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[3].witnessRelation", (String)NOTEMPTY_MRG_FIRST_NAME);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[3].relativeName", (String)NOTEMPTY_MRG_WITNESS_PARENT);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[3].age", (String)NOTEMPTY_MRG_WITNESS_AGE);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"witnesses[3].contactInfo.residenceAddress", (String)NOTEMPTY_MRG_RESIDENCE_ADDRESS);
        if (registration != null) {
            this.validateBrideInformation(errors, registration);
            this.validateBrideGroomInformation(errors, registration);
            this.validateDocumentAttachments(errors, registration);
            if (registration.getStatus() != null && "CREATED".equals(registration.getStatus().getCode()) && !registration.isFeeCollected() && !"Junior/Senior Assistance approval pending".equalsIgnoreCase(registration.getState().getNextAction())) {
                errors.reject("validate.collect.marriageFee", null);
            }
            if (registration.getStatus() != null && ("APPROVED".equals(registration.getStatus().getCode()) && registration.getState().getNextAction() != null && registration.getState().getNextAction().equalsIgnoreCase("Certificate Print Pending") || MarriageRegistration.RegistrationStatus.DIGITALSIGNED.name().equalsIgnoreCase(registration.getStatus().getCode()))) {
                this.validateSerialAndPageNo(errors);
            }
        }
    }

    private void validateDocumentAttachments(Errors errors, MarriageRegistration registration) {
        if (registration.getId() == null) {
            for (MarriageDocument marriageDocument : registration.getDocuments()) {
                MarriageDocument document = this.marriageDocumentService.get(marriageDocument.getId());
                if (document.getCode().equals("MoM") && marriageDocument.getFile().getSize() == 0L) {
                    errors.rejectValue("memorandumOfMarriage", "validate.memorendum");
                }
                if (!document.getCode().equals("CF_STAMP") || marriageDocument.getFile().getSize() != 0L) continue;
                errors.rejectValue("courtFeeStamp", "validate.courtfeettamp");
            }
        }
    }

    private void validateSerialAndPageNo(Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"serialNo", (String)"Notempty.mrg.serial.no");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"pageNo", (String)"Notempty.mrg.page.no");
    }

    private void validateBrideGroomInformation(Errors errors, MarriageRegistration registration) {
        if (registration.getHusband() != null && registration.getWife().getAgeInYearsAsOnMarriage() != null && registration.getWife().getAgeInYearsAsOnMarriage() < 18) {
            errors.rejectValue("wife.ageInYearsAsOnMarriage", "Validdata.mrg.ageinyears");
        }
        if (registration.getHusband() != null && registration.getWife().getAgeInMonthsAsOnMarriage() != null && registration.getWife().getAgeInMonthsAsOnMarriage() > 12) {
            errors.rejectValue("wife.ageInMonthsAsOnMarriage", "Validdata.mrg.ageinmonths");
        }
        this.validateBrideGroomMobileNo(errors, registration);
        this.validateBrideGroomEmail(errors, registration);
    }

    private void validateBrideGroomEmail(Errors errors, MarriageRegistration registration) {
        if (registration.getWife() != null && registration.getWife().getContactInfo() != null && registration.getWife().getContactInfo().getEmail() != null) {
            this.pattern = Pattern.compile(EMAIL_PATTERN);
            this.matcher = this.pattern.matcher(registration.getWife().getContactInfo().getEmail());
            if (!this.matcher.matches()) {
                errors.rejectValue("wife.contactInfo.email", VALIDATE_EMAIL);
            }
        }
    }

    private void validateBrideGroomMobileNo(Errors errors, MarriageRegistration registration) {
        if (registration.getWife() != null && registration.getWife().getContactInfo() != null && registration.getWife().getContactInfo().getMobileNo() != null) {
            this.pattern = Pattern.compile(MOBILE_PATTERN);
            this.matcher = this.pattern.matcher(registration.getWife().getContactInfo().getMobileNo());
            if (!this.matcher.matches()) {
                errors.rejectValue("wife.contactInfo.mobileNo", VALIDATE_MOBILE_NO);
            }
        }
    }

    private void validateBrideInformation(Errors errors, MarriageRegistration registration) {
        if (registration.getHusband() != null && registration.getHusband().getAgeInYearsAsOnMarriage() != null && registration.getHusband().getAgeInYearsAsOnMarriage() < 18) {
            errors.rejectValue("husband.ageInYearsAsOnMarriage", "Validdata.mrg.ageinyears");
        }
        if (registration.getHusband() != null && registration.getHusband().getAgeInMonthsAsOnMarriage() != null && registration.getHusband().getAgeInMonthsAsOnMarriage() > 12) {
            errors.rejectValue("husband.ageInMonthsAsOnMarriage", "Validdata.mrg.ageinmonths");
        }
        this.validateBrideMobileNo(errors, registration);
        this.validateBrideEmail(errors, registration);
    }

    private void validateBrideEmail(Errors errors, MarriageRegistration registration) {
        if (registration.getHusband() != null && registration.getHusband().getContactInfo() != null && registration.getHusband().getContactInfo().getEmail() != null) {
            this.pattern = Pattern.compile(EMAIL_PATTERN);
            this.matcher = this.pattern.matcher(registration.getHusband().getContactInfo().getEmail());
            if (!this.matcher.matches()) {
                errors.rejectValue("husband.contactInfo.email", VALIDATE_EMAIL);
            }
        }
    }

    private void validateBrideMobileNo(Errors errors, MarriageRegistration registration) {
        if (registration.getHusband() != null && registration.getHusband().getContactInfo() != null && registration.getHusband().getContactInfo().getMobileNo() != null) {
            this.pattern = Pattern.compile(MOBILE_PATTERN);
            this.matcher = this.pattern.matcher(registration.getHusband().getContactInfo().getMobileNo());
            if (!this.matcher.matches()) {
                errors.rejectValue("husband.contactInfo.mobileNo", VALIDATE_MOBILE_NO);
            }
        }
    }

    public void validate(Object target, Errors errors) {
    }
}

