/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.application.registration;

import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FileUtils;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.mrs.domain.entity.MarriageCertificate;
import org.egov.mrs.domain.service.MarriageRegistrationService;
import org.egov.mrs.domain.service.ReIssueService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/certificate"})
public class MarriageCertificateController {
    @Autowired
    private MarriageRegistrationService marriageRegistrationService;
    @Autowired
    private ReIssueService reIssueService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;

    @RequestMapping(value={"/registration"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> showRegistrationCertificate(HttpServletRequest request, @RequestParam Long id, Model model, HttpSession session) throws IOException {
        return this.getResponseEntity(((MarriageCertificate)this.marriageRegistrationService.get(id).getMarriageCertificate().get(0)).getFileStore());
    }

    @RequestMapping(value={"/reissue"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> showReIssuedCertificate(HttpServletRequest request, @RequestParam Long id, Model model, HttpSession session) throws IOException {
        return this.getResponseEntity(((MarriageCertificate)this.reIssueService.get(id).getMarriageCertificate().get(0)).getFileStore());
    }

    private ResponseEntity<byte[]> getResponseEntity(FileStoreMapper fsm) throws IOException {
        ReportOutput reportOutput = new ReportOutput();
        File file = this.fileStoreService.fetch(fsm, "MRS");
        byte[] bFile = FileUtils.readFileToByteArray((File)file);
        reportOutput.setReportOutputData(bFile);
        reportOutput.setReportFormat(ReportFormat.PDF);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=" + file.getName());
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

