/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.mrs.domain.entity.MarriageCertificate;
import org.egov.mrs.domain.entity.ReIssue;

public class MarriageReIssueJsonAdaptor
implements JsonSerializer<ReIssue> {
    public JsonElement serialize(ReIssue reIssue, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (reIssue != null) {
            if (reIssue.getApplicationNo() != null) {
                jsonObject.addProperty("applicationNo", reIssue.getApplicationNo());
            } else {
                jsonObject.addProperty("applicationNo", "");
            }
            if (reIssue.getRegistration().getRegistrationNo() != null) {
                jsonObject.addProperty("registrationNo", reIssue.getRegistration().getRegistrationNo());
            } else {
                jsonObject.addProperty("registrationNo", "");
            }
            if (reIssue.getApplicationDate() != null) {
                jsonObject.addProperty("registrationDate", reIssue.getApplicationDate().toString());
            } else {
                jsonObject.addProperty("registrationDate", "");
            }
            if (reIssue.getRegistration().getDateOfMarriage() != null) {
                jsonObject.addProperty("dateOfMarriage", reIssue.getRegistration().getDateOfMarriage().toString());
            } else {
                jsonObject.addProperty("dateOfMarriage", "");
            }
            if (reIssue.getRegistration().getHusband().getFullName() != null) {
                jsonObject.addProperty("husbandName", reIssue.getRegistration().getHusband().getFullName());
            } else {
                jsonObject.addProperty("husbandName", "");
            }
            if (reIssue.getRegistration().getWife().getFullName() != null) {
                jsonObject.addProperty("wifeName", reIssue.getRegistration().getWife().getFullName());
            } else {
                jsonObject.addProperty("wifeName", "");
            }
            if (reIssue.getMarriageCertificate().isEmpty()) {
                jsonObject.addProperty("certificateIssued", "No");
            } else if (((MarriageCertificate)reIssue.getMarriageCertificate().get(0)).isCertificateIssued()) {
                jsonObject.addProperty("certificateIssued", "Yes");
            }
            if (reIssue.getStatus() != null) {
                jsonObject.addProperty("status", reIssue.getStatus().getDescription());
            } else {
                jsonObject.addProperty("status", "");
            }
            if (reIssue.getFeePaid() != null) {
                jsonObject.addProperty("feePaid", (Number)reIssue.getFeePaid());
            } else {
                jsonObject.addProperty("feePaid", "");
            }
            if (!reIssue.isFeeCollected()) {
                jsonObject.addProperty("feeCollected", "No");
            } else {
                jsonObject.addProperty("feeCollected", "Yes");
            }
            if (reIssue.getZone() != null) {
                jsonObject.addProperty("zone", reIssue.getZone().getName());
            } else {
                jsonObject.addProperty("zone", "");
            }
            if (reIssue.getStateType() != null) {
                jsonObject.addProperty("remarks", reIssue.getRejectionReason());
            } else {
                jsonObject.addProperty("remarks", "");
            }
            if (reIssue.getMarriageRegistrationUnit() != null) {
                jsonObject.addProperty("marriageRegistrationUnit", reIssue.getMarriageRegistrationUnit().getName());
            } else {
                jsonObject.addProperty("marriageRegistrationUnit", "");
            }
            jsonObject.addProperty("id", (Number)reIssue.getId());
        }
        return jsonObject;
    }
}

