/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.application.registration;

import java.io.File;
import java.io.IOException;
import java.util.Base64;
import org.apache.log4j.Logger;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.web.controller.application.registration.MarriageRegistrationController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/registration"})
public class ViewMarriageRegistrationController
extends MarriageRegistrationController {
    private static final Logger LOG = Logger.getLogger(ViewMarriageRegistrationController.class);
    @Autowired
    private FileStoreService fileStoreService;

    @RequestMapping(value={"/view/{registrationId}"}, method={RequestMethod.GET})
    public String viewRegistration(@PathVariable Long registrationId, @RequestParam(required=false) String mode, Model model) throws IOException {
        MarriageRegistration registration = this.marriageRegistrationService.get(registrationId);
        this.prepareMrgRegForView(mode, model, registration);
        return "registration-view";
    }

    private void prepareMrgRegForView(String mode, Model model, MarriageRegistration registration) {
        model.addAttribute("registration", (Object)registration);
        model.addAttribute("mode", (Object)mode);
        this.marriageRegistrationService.prepareDocumentsForView(registration);
        this.marriageApplicantService.prepareDocumentsForView(registration.getHusband());
        this.marriageApplicantService.prepareDocumentsForView(registration.getWife());
        registration.getWitnesses().forEach(witness -> {
            try {
                if (witness.getPhotoFileStore() != null) {
                    File file = this.fileStoreService.fetch(witness.getPhotoFileStore().getFileStoreId(), "MRS");
                    witness.setEncodedPhoto(Base64.getEncoder().encodeToString(FileCopyUtils.copyToByteArray((File)file)));
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Error while preparing the document for view", (Throwable)e);
            }
        });
    }

    @RequestMapping(value={"/viewapplication/{applnNo}"}, method={RequestMethod.GET})
    public String viewRegistrationByApplnNumber(@PathVariable String applnNo, @RequestParam(required=false) String mode, Model model) throws IOException {
        if (null == applnNo) {
            model.addAttribute("message", (Object)"msg.appln.no.not.found");
            return "marriagecommon-error";
        }
        MarriageRegistration registration = this.marriageRegistrationService.findByApplicationNo(applnNo);
        if (null == registration) {
            model.addAttribute("message", (Object)"msg.appln.no.data.not.found");
            return "marriagecommon-error";
        }
        this.prepareMrgRegForView(mode, model, registration);
        return "registration-view";
    }
}

