/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.application.registration;

import java.io.File;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.repository.FileStoreMapperRepository;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.mrs.application.MarriageUtils;
import org.egov.mrs.application.service.MarriageCertificateService;
import org.egov.mrs.application.service.workflow.RegistrationWorkflowService;
import org.egov.mrs.domain.entity.MarriageCertificate;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.enums.MarriageCertificateType;
import org.egov.mrs.service.es.MarriageRegistrationUpdateIndexesService;
import org.egov.mrs.web.controller.application.registration.MarriageFormValidator;
import org.egov.mrs.web.controller.application.registration.MarriageRegistrationController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.FileCopyUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/registration"})
public class UpdateMarriageRegistrationController
extends MarriageRegistrationController {
    private static final String PENDING_ACTIONS = "pendingActions";
    private static final String MARRIAGE_REGISTRATION = "marriageRegistration";
    private static final Logger LOG = Logger.getLogger(UpdateMarriageRegistrationController.class);
    private static final String MRG_REGISTRATION_EDIT = "registration-correction";
    private static final String MRG_REGISTRATION_EDIT_APPROVED = "registration-update-approved";
    private static final String MRG_REGISTRATION_SUCCESS = "registration-ack";
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private MarriageFormValidator marriageFormValidator;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    protected MarriageUtils marriageUtils;
    @Autowired
    protected FileStoreMapperRepository fileStoreMapperRepository;
    @Autowired
    private MarriageRegistrationUpdateIndexesService marriageRegistrationUpdateIndexesService;
    @Autowired
    private RegistrationWorkflowService registrationWorkflowService;
    @Autowired
    private MarriageCertificateService marriageCertificateService;
    private static final Logger LOGGER = Logger.getLogger(UpdateMarriageRegistrationController.class);

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.GET})
    public String showRegistration(@PathVariable Long id, Model model) {
        this.buildMrgRegistrationUpdateResult(id, model);
        return MRG_REGISTRATION_EDIT;
    }

    @RequestMapping(value={"/modify-approved/{id}"}, method={RequestMethod.GET})
    public String editApprovedRegistration(@PathVariable Long id, Model model) {
        this.buildMrgRegistrationUpdateResult(id, model);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)".........finished build marriage registration for update........ ");
        }
        return MRG_REGISTRATION_EDIT_APPROVED;
    }

    private void buildMrgRegistrationUpdateResult(Long id, Model model) {
        MarriageRegistration marriageRegistration;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("..........InsidebuildMrgRegistrationUpdateResult........ " + id));
        }
        if (!(marriageRegistration = this.marriageRegistrationService.get(id)).isLegacy()) {
            AppConfigValues allowValidation;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"..........No legacy  entry........ ");
            }
            model.addAttribute("allowDaysValidation", (Object)((allowValidation = this.marriageFeeService.getDaysValidationAppConfValue("Marriage Registration", "MARRIAGEREGISTRATION_DAYS_VALIDATION")) != null && !allowValidation.getValue().isEmpty() ? allowValidation.getValue() : "NO"));
        } else {
            model.addAttribute("allowDaysValidation", (Object)"NO");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)".........prepareDocumentsForView........ ");
        }
        this.marriageRegistrationService.prepareDocumentsForView(marriageRegistration);
        this.marriageApplicantService.prepareDocumentsForView(marriageRegistration.getHusband());
        this.marriageApplicantService.prepareDocumentsForView(marriageRegistration.getWife());
        model.addAttribute("applicationHistory", (Object)this.marriageRegistrationService.getHistory(marriageRegistration));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)".........before prepareWorkFlowForNewMarriageRegistration........ ");
        }
        this.prepareWorkFlowForNewMarriageRegistration(marriageRegistration, model);
        marriageRegistration.getWitnesses().forEach(witness -> {
            try {
                File file;
                if (witness.getPhotoFileStore() != null && (file = this.fileStoreService.fetch(witness.getPhotoFileStore().getFileStoreId(), "MRS")) != null) {
                    witness.setEncodedPhoto(Base64.getEncoder().encodeToString(FileCopyUtils.copyToByteArray((File)file)));
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Error while preparing the document for view", (Throwable)e);
            }
        });
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)".........after prepare Witnesses........ ");
        }
        model.addAttribute(MARRIAGE_REGISTRATION, (Object)marriageRegistration);
    }

    private void prepareWorkFlowForNewMarriageRegistration(MarriageRegistration registration, Model model) {
        WorkflowContainer workFlowContainer = new WorkflowContainer();
        if (registration.getStatus().getCode().equalsIgnoreCase("APPROVED")) {
            if (this.marriageUtils.isDigitalSignEnabled().booleanValue()) {
                model.addAttribute(PENDING_ACTIONS, (Object)"Digital Signature Pending");
                workFlowContainer.setPendingActions("Digital Signature Pending");
            } else {
                model.addAttribute(PENDING_ACTIONS, (Object)"Certificate Print Pending");
                workFlowContainer.setPendingActions("Certificate Print Pending");
            }
        }
        workFlowContainer.setAdditionalRule("MARRIAGE REGISTRATION");
        this.prepareWorkflow(model, (StateAware)registration, workFlowContainer);
        model.addAttribute("additionalRule", (Object)"MARRIAGE REGISTRATION");
        model.addAttribute("stateType", (Object)registration.getClass().getSimpleName());
        if (registration.getCurrentState() != null) {
            model.addAttribute("currentState", (Object)registration.getCurrentState().getValue());
        }
        model.addAttribute("isDigitalSignEnabled", (Object)this.marriageUtils.isDigitalSignEnabled());
        if (registration.getStatus().getCode().equalsIgnoreCase("CREATED") && "Junior/Senior Assistance approval pending".equalsIgnoreCase(registration.getState().getNextAction())) {
            model.addAttribute("nextActn", (Object)"Junior/Senior Assistance approval pending");
        }
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String updateRegistration(WorkflowContainer workflowContainer, @ModelAttribute MarriageRegistration marriageRegistration, Model model, HttpServletRequest request, BindingResult errors) throws IOException {
        String workFlowAction = "";
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        this.validateApplicationDate(marriageRegistration, errors, request);
        this.marriageFormValidator.validate((Object)marriageRegistration, (Errors)errors, "registration");
        if (errors.hasErrors()) {
            model.addAttribute(MARRIAGE_REGISTRATION, (Object)marriageRegistration);
            return MRG_REGISTRATION_EDIT;
        }
        String message = "";
        if (workFlowAction != null && !workFlowAction.isEmpty()) {
            workflowContainer.setWorkFlowAction(workFlowAction);
            Assignment wfInitiator = this.registrationWorkflowService.getWorkFlowInitiator(marriageRegistration);
            String approverName = wfInitiator.getEmployee().getName();
            String nextDesignation = wfInitiator.getDesignation().getName();
            workflowContainer.setApproverComments(request.getParameter("approvalComent"));
            if (workFlowAction.equalsIgnoreCase("Reject")) {
                this.marriageRegistrationService.rejectRegistration(marriageRegistration, workflowContainer);
                message = this.messageSource.getMessage("msg.rejected.registration", (Object[])new String[]{marriageRegistration.getApplicationNo(), approverName.concat("~").concat(nextDesignation)}, null);
            } else if (workFlowAction.equalsIgnoreCase("Cancel Registration")) {
                this.marriageRegistrationService.rejectRegistration(marriageRegistration, workflowContainer);
                message = this.messageSource.getMessage("msg.cancelled.registration", (Object[])new String[]{marriageRegistration.getApplicationNo(), null}, null);
            } else if (workFlowAction.equalsIgnoreCase("Approve")) {
                if (this.marriageUtils.isDigitalSignEnabled().booleanValue()) {
                    model.addAttribute(PENDING_ACTIONS, (Object)"Commisioner Approval Pending_DigiSign");
                    workflowContainer.setPendingActions("Commisioner Approval Pending_DigiSign");
                    this.marriageRegistrationService.approveRegistration(marriageRegistration, workflowContainer);
                    message = this.messageSource.getMessage("msg.approved.registration", (Object[])new String[]{marriageRegistration.getRegistrationNo()}, null);
                } else {
                    model.addAttribute(PENDING_ACTIONS, (Object)"Commisioner Approval Pending_PrintCert");
                    workflowContainer.setPendingActions("Commisioner Approval Pending_PrintCert");
                    this.marriageRegistrationService.approveRegistration(marriageRegistration, workflowContainer);
                    message = this.messageSource.getMessage("msg.approved.forwarded.registration", (Object[])new String[]{marriageRegistration.getRegistrationNo(), approverName.concat("~").concat(nextDesignation)}, null);
                }
            } else {
                if (workFlowAction.equalsIgnoreCase("Sign")) {
                    MarriageCertificate marriageCertificate = null;
                    List certificateIssued = this.marriageCertificateService.getGeneratedRegCertificate(marriageRegistration);
                    if (certificateIssued != null && !certificateIssued.isEmpty()) {
                        Iterator iterator = certificateIssued.iterator();
                        while (iterator.hasNext()) {
                            MarriageCertificate certificateobj;
                            marriageCertificate = certificateobj = (MarriageCertificate)iterator.next();
                        }
                    } else {
                        marriageCertificate = this.marriageRegistrationService.generateMarriageCertificate(marriageRegistration, workflowContainer, request);
                    }
                    model.addAttribute("fileStoreIds", (Object)marriageCertificate.getFileStore().getFileStoreId());
                    model.addAttribute("ulbCode", (Object)ApplicationThreadLocals.getCityCode());
                    HttpSession session = request.getSession();
                    session.setAttribute("approvalComment", (Object)request.getParameter("approvalComent"));
                    session.setAttribute("applicationNumber", (Object)marriageCertificate.getRegistration().getApplicationNo());
                    HashMap<String, String> fileStoreIdsApplicationNoMap = new HashMap<String, String>();
                    fileStoreIdsApplicationNoMap.put(marriageCertificate.getFileStore().getFileStoreId(), marriageCertificate.getRegistration().getApplicationNo());
                    session.setAttribute("fileStoreIdApplicationNumber", fileStoreIdsApplicationNoMap);
                    model.addAttribute("isDigitalSignatureEnabled", (Object)this.marriageUtils.isDigitalSignEnabled());
                    return "marriagereg-digitalsignature";
                }
                if (workFlowAction.equalsIgnoreCase("Print Certificate")) {
                    this.marriageRegistrationService.printCertificate(marriageRegistration, workflowContainer, request);
                    message = this.messageSource.getMessage("msg.printcertificate.registration", null, null);
                } else {
                    approverName = request.getParameter("approverName");
                    nextDesignation = request.getParameter("nextDesignation");
                    workflowContainer.setApproverPositionId(Long.valueOf(request.getParameter("approvalPosition")));
                    this.marriageRegistrationService.forwardRegistration(marriageRegistration, workflowContainer);
                    message = this.messageSource.getMessage("msg.forward.registration", (Object[])new String[]{approverName.concat("~").concat(nextDesignation), marriageRegistration.getApplicationNo()}, null);
                }
            }
        }
        if (workFlowAction != null && !workFlowAction.isEmpty() && workFlowAction.equalsIgnoreCase("Print Certificate")) {
            return "redirect:/certificate/registration?id=" + marriageRegistration.getId();
        }
        model.addAttribute("message", (Object)message);
        return MRG_REGISTRATION_SUCCESS;
    }

    @RequestMapping(value={"/digiSignWorkflow"})
    public String digiSignTransitionWorkflow(HttpServletRequest request, Model model) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"..........Inside Digital Signature Transition : Registration........");
        }
        String fileStoreIds = request.getParameter("fileStoreId");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("........fileStoreIds.........." + fileStoreIds));
        }
        String[] fileStoreIdArr = fileStoreIds.split(",");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("........fileStoreIdArr.........." + fileStoreIdArr.length));
        }
        HttpSession session = request.getSession();
        String approvalComent = (String)session.getAttribute("approvalComment");
        Map appNoFileStoreIdsMap = (Map)session.getAttribute("fileStoreIdApplicationNumber");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("........appNoFileStoreIdsMap....size......" + appNoFileStoreIdsMap.size()));
        }
        MarriageRegistration marriageRegistrationObj = null;
        for (String fileStoreId : fileStoreIdArr) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"........Inside for loop......");
            }
            String applicationNumber = (String)appNoFileStoreIdsMap.get(fileStoreId);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("........applicationNumber......" + applicationNumber));
            }
            if (null == applicationNumber || applicationNumber.isEmpty()) continue;
            WorkflowContainer workflowContainer = new WorkflowContainer();
            workflowContainer.setApproverComments(approvalComent);
            workflowContainer.setWorkFlowAction("Sign");
            workflowContainer.setPendingActions("Digital Signature Pending");
            marriageRegistrationObj = this.marriageRegistrationService.findByApplicationNo(applicationNumber);
            this.marriageRegistrationService.digiSignCertificate(marriageRegistrationObj, workflowContainer, request);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"........outside for loop......");
        }
        if (marriageRegistrationObj != null) {
            Assignment wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(marriageRegistrationObj.getCreatedBy().getId());
            String message = this.messageSource.getMessage("msg.digisign.success.registration", (Object[])new String[]{wfInitiator.getEmployee().getName().concat("~").concat(wfInitiator.getDesignation().getName())}, null);
            model.addAttribute("successMessage", (Object)message);
        }
        model.addAttribute("objectType", (Object)MarriageCertificateType.REGISTRATION.toString());
        model.addAttribute("fileStoreId", (Object)(fileStoreIdArr.length == 1 ? fileStoreIdArr[0] : ""));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"..........END of Digital Signature Transition : Registration........");
        }
        return "mrdigitalsignature-success";
    }

    @RequestMapping(value={"/downloadSignedCertificate"})
    public void downloadRegDigiSignedCertificate(HttpServletRequest request, HttpServletResponse response) {
        String signedFileStoreId = request.getParameter("signedFileStoreId");
        try {
            this.marriageUtils.downloadSignedCertificate(signedFileStoreId, response);
        }
        catch (ApplicationRuntimeException ex) {
            throw new ApplicationRuntimeException("Exception while downloading file : " + (Object)((Object)ex));
        }
    }

    @RequestMapping(value={"/modify-approved"}, method={RequestMethod.POST})
    public String modifyRegisteredApplication(@RequestParam Long id, @ModelAttribute MarriageRegistration registration, Model model, HttpServletRequest request, BindingResult errors) {
        this.validateApplicationDate(registration, errors, request);
        if (errors.hasErrors()) {
            model.addAttribute(MARRIAGE_REGISTRATION, (Object)registration);
            return MRG_REGISTRATION_EDIT_APPROVED;
        }
        MarriageRegistration marriageRegistration = this.marriageRegistrationService.updateRegistration(registration);
        this.marriageRegistrationUpdateIndexesService.updateIndexes(marriageRegistration);
        model.addAttribute("message", (Object)this.messageSource.getMessage("msg.update.registration", (Object[])new String[]{registration.getApplicationNo(), registration.getRegistrationNo()}, null));
        return MRG_REGISTRATION_SUCCESS;
    }

    @RequestMapping(value={"/checkunique-serialno"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public boolean uniqueSerialNo(@RequestParam String serialNo) {
        return serialNo != null && !"".equals(serialNo) && this.marriageRegistrationService.findBySerialNo(serialNo) != null;
    }

    @RequestMapping(value={"/viewCertificate/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> viewMarriageRegistrationReport(@PathVariable Long id, HttpSession session, HttpServletRequest request) throws IOException {
        return this.marriageUtils.viewReport(id, MarriageCertificateType.REGISTRATION.toString(), session, request);
    }
}

