/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.application.registration;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.mrs.application.service.MarriageFeeCalculator;
import org.egov.mrs.application.service.workflow.RegistrationWorkflowService;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.masters.entity.MarriageRegistrationUnit;
import org.egov.mrs.web.controller.application.registration.MarriageFormValidator;
import org.egov.mrs.web.controller.application.registration.MarriageRegistrationController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/registration"})
public class NewRegistrationController
extends MarriageRegistrationController {
    private static final String ACKOWLEDGEMENT = "acknowledgement";
    private static final String MESSAGE = "message";
    private static final String APPROVAL_POSITION = "approvalPosition";
    private static final String MARRIAGE_REGISTRATION = "marriageRegistration";
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private MarriageFormValidator marriageFormValidator;
    @Autowired
    private MarriageFeeCalculator marriageFeeCalculator;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private RegistrationWorkflowService registrationWorkFlowService;

    @RequestMapping(value={"/register"}, method={RequestMethod.GET})
    public String showRegistration(Model model, HttpServletRequest request) {
        MarriageRegistration marriageRegistration = new MarriageRegistration();
        User logedinUser = this.securityUtils.getCurrentUser();
        model.addAttribute("isEmployee", (Object)(!"Anonymous".equalsIgnoreCase(logedinUser.getName()) && this.registrationWorkFlowService.isEmployee(logedinUser) != false ? 1 : 0));
        marriageRegistration.setFeePaid(this.calculateMarriageFee(new Date()));
        model.addAttribute(MARRIAGE_REGISTRATION, (Object)marriageRegistration);
        this.prepareWorkFlowForNewMarriageRegistration(marriageRegistration, model);
        return "registration-form";
    }

    private void prepareWorkFlowForNewMarriageRegistration(MarriageRegistration registration, Model model) {
        WorkflowContainer workFlowContainer = new WorkflowContainer();
        workFlowContainer.setAdditionalRule("MARRIAGE REGISTRATION");
        this.prepareWorkflow(model, (StateAware)registration, workFlowContainer);
        model.addAttribute("additionalRule", (Object)"MARRIAGE REGISTRATION");
        model.addAttribute("stateType", (Object)registration.getClass().getSimpleName());
        model.addAttribute("currentState", (Object)"NEW");
    }

    @RequestMapping(value={"/register"}, method={RequestMethod.POST})
    public String register(WorkflowContainer workflowContainer, @ModelAttribute(value="marriageRegistration") MarriageRegistration marriageRegistration, Model model, HttpServletRequest request, BindingResult errors, RedirectAttributes redirectAttributes) {
        User logedinUser = this.securityUtils.getCurrentUser();
        this.validateApplicationDate(marriageRegistration, errors, request);
        this.marriageFormValidator.validate((Object)marriageRegistration, (Errors)errors, "registration");
        Boolean isEmployee = !"Anonymous".equalsIgnoreCase(logedinUser.getName()) && this.registrationWorkFlowService.isEmployee(logedinUser) != false;
        this.registrationWorkFlowService.validateAssignmentForCscUser(marriageRegistration, null, isEmployee, errors);
        if (errors.hasErrors()) {
            model.addAttribute("isEmployee", (Object)(!"Anonymous".equalsIgnoreCase(logedinUser.getName()) && this.registrationWorkFlowService.isEmployee(this.securityUtils.getCurrentUser()) != false ? 1 : 0));
            model.addAttribute(MARRIAGE_REGISTRATION, (Object)marriageRegistration);
            this.prepareWorkFlowForNewMarriageRegistration(marriageRegistration, model);
            return "registration-form";
        }
        String approverName = null;
        String nextDesignation = null;
        if (!isEmployee.booleanValue()) {
            Assignment assignment = this.registrationWorkFlowService.getMappedAssignmentForCscOperator(marriageRegistration, null);
            if (assignment != null) {
                workflowContainer.setApproverPositionId(assignment.getPosition().getId());
                approverName = assignment.getEmployee().getName();
                nextDesignation = assignment.getDesignation().getName();
            }
        } else {
            approverName = request.getParameter("approverName");
            nextDesignation = request.getParameter("nextDesignation");
            this.obtainWorkflowParameters(workflowContainer, request);
        }
        String appNo = this.marriageRegistrationService.createRegistration(marriageRegistration, workflowContainer);
        String message = this.messageSource.getMessage("msg.success.forward", (Object[])new String[]{approverName.concat("~").concat(nextDesignation), appNo}, null);
        model.addAttribute(MESSAGE, (Object)message);
        model.addAttribute("applnNo", (Object)appNo);
        model.addAttribute("isEmployee", (Object)isEmployee);
        if (!isEmployee.booleanValue()) {
            redirectAttributes.addFlashAttribute(MESSAGE, (Object)message);
            return "redirect:/registration/new-mrgregistration-ackowledgement/" + appNo;
        }
        return "registration-ack";
    }

    @RequestMapping(value={"/workflow"}, method={RequestMethod.POST})
    public String handleWorkflowAction(@RequestParam Long id, @ModelAttribute MarriageRegistration marriageRegistration, @ModelAttribute WorkflowContainer workflowContainer, Model model, HttpServletRequest request, BindingResult errors) {
        if (errors.hasErrors()) {
            return "registration-view";
        }
        this.obtainWorkflowParameters(workflowContainer, request);
        MarriageRegistration result = null;
        switch (workflowContainer.getWorkFlowAction()) {
            case "Forward": {
                result = this.marriageRegistrationService.forwardRegistration(marriageRegistration, workflowContainer);
                break;
            }
            case "Approve": {
                result = this.marriageRegistrationService.approveRegistration(marriageRegistration, workflowContainer);
                break;
            }
            case "Reject": {
                result = this.marriageRegistrationService.rejectRegistration(marriageRegistration, workflowContainer);
                break;
            }
            case "Cancel Registration": {
                result = this.marriageRegistrationService.rejectRegistration(marriageRegistration, workflowContainer);
            }
        }
        model.addAttribute(MARRIAGE_REGISTRATION, result);
        return "registration-ack";
    }

    private void obtainWorkflowParameters(WorkflowContainer workflowContainer, HttpServletRequest request) {
        if (request.getParameter("approvalComent") != null) {
            workflowContainer.setApproverComments(request.getParameter("approvalComent"));
        }
        if (request.getParameter("workFlowAction") != null) {
            workflowContainer.setWorkFlowAction(request.getParameter("workFlowAction"));
        }
        if (request.getParameter(APPROVAL_POSITION) != null && !request.getParameter(APPROVAL_POSITION).isEmpty()) {
            workflowContainer.setApproverPositionId(Long.valueOf(request.getParameter(APPROVAL_POSITION)));
        }
    }

    @RequestMapping(value={"/getmrregistrationunitzone"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Boundary getregistrationunitzone(@RequestParam Long registrationUnitId) {
        MarriageRegistrationUnit marriageRegistrationUnit = this.marriageRegistrationUnitService.findById(registrationUnitId);
        if (marriageRegistrationUnit != null) {
            return marriageRegistrationUnit.getZone();
        }
        return null;
    }

    @RequestMapping(value={"/calculatemarriagefee"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Double calculateMarriageFee(@RequestParam Date dateOfMarriage) {
        return this.marriageFeeCalculator.calculateMarriageRegistrationFee(null, dateOfMarriage);
    }

    @RequestMapping(value={"/new-mrgregistration-ackowledgement/{applnNo}"}, method={RequestMethod.GET})
    public String showAcknowledgemnt(@PathVariable String applnNo, Model model) {
        User logedinUser = this.securityUtils.getCurrentUser();
        model.addAttribute("applicationNo", (Object)applnNo);
        model.addAttribute("applnType", (Object)"NEW");
        model.addAttribute("isOnlineApplication", (Object)"Anonymous".equalsIgnoreCase(logedinUser.getName()));
        return ACKOWLEDGEMENT;
    }

    @RequestMapping(value={"/printmarriageregistrationack"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> printAck(@RequestParam(value="applnNo") String applnNo, Model model, HttpServletRequest request) {
        byte[] reportOutput;
        String cityMunicipalityName = (String)request.getSession().getAttribute("citymunicipalityname");
        String cityName = (String)request.getSession().getAttribute("cityname");
        MarriageRegistration marriageRegistration = this.marriageRegistrationService.findByApplicationNo(applnNo);
        if (marriageRegistration != null && (reportOutput = this.marriageRegistrationService.getReportParamsForAcknowdgementForMrgReg(marriageRegistration, cityMunicipalityName, cityName).getReportOutputData()) != null) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            headers.add("content-disposition", "inline;filename=new-marriage-registration-ack.pdf");
            return new ResponseEntity((Object)reportOutput, (MultiValueMap)headers, HttpStatus.CREATED);
        }
        return null;
    }
}

