/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.application.collection;

import org.egov.mrs.application.service.MarriageRegistrationDemandService;
import org.egov.mrs.application.service.ReIssueDemandService;
import org.egov.mrs.application.service.collection.MarriageBillService;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.ReIssue;
import org.egov.mrs.domain.service.MarriageRegistrationService;
import org.egov.mrs.domain.service.ReIssueService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/collection"})
public class MarriageFeeCollectionController {
    @Autowired
    private MarriageBillService marriageBillService;
    @Autowired
    private MarriageRegistrationService marriageRegistrationService;
    @Autowired
    private MarriageRegistrationDemandService marriageRegistrationDemandService;
    @Autowired
    private ReIssueService reIssueService;
    @Autowired
    private ReIssueDemandService reIssueDemandService;

    @RequestMapping(value={"/bill/{id}"}, method={RequestMethod.GET})
    public String generateRegistrationBill(@PathVariable Long id, Model model) {
        MarriageRegistration marriageRegistration = this.marriageRegistrationService.get(id);
        if (marriageRegistration != null && marriageRegistration.getDemand() != null && !this.marriageRegistrationDemandService.checkAnyTaxIsPendingToCollect(marriageRegistration).booleanValue()) {
            model.addAttribute("message", (Object)"msg.collection.noPendingTax");
            return "collectmarriagefee-error";
        }
        String billXml = this.marriageBillService.generateBill(marriageRegistration);
        model.addAttribute("billXml", (Object)billXml);
        return "registrationCollection-view";
    }

    @RequestMapping(value={"/reissuebill/{id}"}, method={RequestMethod.GET})
    public String generateReIssueBill(@PathVariable Long id, Model model) {
        ReIssue reIssue = this.reIssueService.get(id);
        if (reIssue != null && reIssue.getDemand() != null && !this.reIssueDemandService.checkAnyTaxIsPendingToCollect(reIssue).booleanValue()) {
            model.addAttribute("message", (Object)"msg.collection.noPendingTax");
            return "collectmarriagefee-error";
        }
        String billXml = this.marriageBillService.generateBill(reIssue);
        model.addAttribute("billXml", (Object)billXml);
        return "registrationCollection-view";
    }
}

