/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Date;
import org.egov.infra.utils.DateUtils;
import org.egov.mrs.domain.entity.MarriageCertificate;
import org.egov.mrs.domain.entity.MarriageRegistration;

public class MarriageRegistrationJsonAdaptor
implements JsonSerializer<MarriageRegistration> {
    public JsonElement serialize(MarriageRegistration registration, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (registration != null) {
            if (registration.getRegistrationNo() != null) {
                jsonObject.addProperty("registrationNo", registration.getRegistrationNo());
            } else {
                jsonObject.addProperty("registrationNo", "");
            }
            if (registration.getApplicationNo() != null) {
                jsonObject.addProperty("applicationNo", registration.getApplicationNo());
            } else {
                jsonObject.addProperty("applicationNo", "");
            }
            if (registration.getApplicationDate() != null) {
                jsonObject.addProperty("registrationDate", DateUtils.getDefaultFormattedDate((Date)registration.getApplicationDate()));
            } else {
                jsonObject.addProperty("registrationDate", "");
            }
            if (registration.getDateOfMarriage() != null) {
                jsonObject.addProperty("dateOfMarriage", DateUtils.getDefaultFormattedDate((Date)registration.getDateOfMarriage()));
            } else {
                jsonObject.addProperty("dateOfMarriage", "");
            }
            if (registration.getHusband().getFullName() != null) {
                jsonObject.addProperty("husbandName", registration.getHusband().getFullName());
            } else {
                jsonObject.addProperty("husbandName", "");
            }
            if (registration.getHusband().getReligion() != null) {
                jsonObject.addProperty("husbandreligion", registration.getHusband().getReligion().getName());
            } else {
                jsonObject.addProperty("husbandreligion", "");
            }
            if (registration.getHusband().getMaritalStatus() != null) {
                jsonObject.addProperty("husbandMaritalStatus", registration.getHusband().getMaritalStatus().toString());
            } else {
                jsonObject.addProperty("husbandMaritalStatus", "");
            }
            if (registration.getWife().getFullName() != null) {
                jsonObject.addProperty("wifeName", registration.getWife().getFullName());
            } else {
                jsonObject.addProperty("wifeName", "");
            }
            if (registration.getWife().getReligion() != null) {
                jsonObject.addProperty("wifereligion", registration.getWife().getReligion().getName());
            } else {
                jsonObject.addProperty("wifereligion", "");
            }
            if (registration.getWife().getMaritalStatus() != null) {
                jsonObject.addProperty("wifeMaritalStatus", registration.getWife().getMaritalStatus().toString());
            } else {
                jsonObject.addProperty("wifeMaritalStatus", "");
            }
            if (registration.getMarriageCertificate().isEmpty()) {
                jsonObject.addProperty("certificateIssued", "No");
            } else if (((MarriageCertificate)registration.getMarriageCertificate().get(0)).isCertificateIssued()) {
                jsonObject.addProperty("certificateIssued", "Yes");
            }
            if (registration.getStatus() != null) {
                jsonObject.addProperty("status", registration.getStatus().getDescription());
            } else {
                jsonObject.addProperty("status", "");
            }
            if (registration.getFeePaid() != null) {
                jsonObject.addProperty("feePaid", (Number)registration.getFeePaid());
            } else {
                jsonObject.addProperty("feePaid", "");
            }
            if (!registration.isFeeCollected()) {
                jsonObject.addProperty("feeCollected", "No");
                jsonObject.addProperty("feeCollectionPending", Boolean.valueOf(true));
            } else {
                jsonObject.addProperty("feeCollected", "Yes");
            }
            if (registration.getRemarks() != null) {
                jsonObject.addProperty("remarks", registration.getRejectionReason());
            } else {
                jsonObject.addProperty("remarks", "");
            }
            if (registration.getZone() != null) {
                jsonObject.addProperty("zone", registration.getZone().getName());
            } else {
                jsonObject.addProperty("zone", "");
            }
            if (registration.getStateType() != null) {
                jsonObject.addProperty("applicationType", registration.getStateType());
            } else {
                jsonObject.addProperty("applicationType", "");
            }
            if (registration.getMarriageRegistrationUnit() != null) {
                jsonObject.addProperty("marriageRegistrationUnit", registration.getMarriageRegistrationUnit().getName());
            } else {
                jsonObject.addProperty("marriageRegistrationUnit", "");
            }
            jsonObject.addProperty("id", (Number)registration.getId());
        }
        return jsonObject;
    }
}

