/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.masters.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.mrs.masters.entity.MarriageRegistrationUnit;
import org.egov.mrs.masters.repository.MrRegistrationUnitRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class MarriageRegistrationUnitService {
    @Autowired
    private MrRegistrationUnitRepository mrregistrationUnitRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public void createMrRegistrationUnit(MarriageRegistrationUnit marriageRegistrationUnit) {
        this.mrregistrationUnitRepository.save((Object)marriageRegistrationUnit);
    }

    @Transactional
    public MarriageRegistrationUnit updateMrRegistrationUnit(MarriageRegistrationUnit marriageRegistrationUnit) {
        return (MarriageRegistrationUnit)((Object)this.mrregistrationUnitRepository.saveAndFlush((Object)marriageRegistrationUnit));
    }

    public List<MarriageRegistrationUnit> getActiveRegistrationunit() {
        return this.mrregistrationUnitRepository.findByisActiveTrueOrderByNameAsc();
    }

    public MarriageRegistrationUnit findById(Long id) {
        return this.mrregistrationUnitRepository.findById(id);
    }

    public MarriageRegistrationUnit getMarriageRegistrationUnit(String name) {
        return this.mrregistrationUnitRepository.findByName(name);
    }

    public List<MarriageRegistrationUnit> getMarriageRegistrationUnits() {
        return this.mrregistrationUnitRepository.findAll();
    }

    public MarriageRegistrationUnit getbyId(Long id) {
        return (MarriageRegistrationUnit)((Object)this.mrregistrationUnitRepository.getOne(id));
    }

    public List<MarriageRegistrationUnit> findAll() {
        return this.mrregistrationUnitRepository.findAll();
    }

    public List<MarriageRegistrationUnit> searchMarriageRegistrationUnit(MarriageRegistrationUnit marriageRegistrationUnit) {
        Criteria criteria = this.getCurrentSession().createCriteria(MarriageRegistrationUnit.class);
        if (null != marriageRegistrationUnit.getName()) {
            criteria.add(Restrictions.ilike((String)"name", (String)marriageRegistrationUnit.getName(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (null != marriageRegistrationUnit.getAddress()) {
            criteria.add(Restrictions.ilike((String)"address", (String)marriageRegistrationUnit.getAddress(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (null != marriageRegistrationUnit.getIsActive() && marriageRegistrationUnit.getIsActive().booleanValue()) {
            criteria.add((Criterion)Restrictions.eq((String)"isActive", (Object)marriageRegistrationUnit.getIsActive()));
        }
        if (null != marriageRegistrationUnit.getIsMainRegistrationUnit() && marriageRegistrationUnit.getIsMainRegistrationUnit().booleanValue()) {
            criteria.add((Criterion)Restrictions.eq((String)"isMainRegistrationUnit", (Object)marriageRegistrationUnit.getIsMainRegistrationUnit()));
        }
        if (marriageRegistrationUnit.getZone().getId() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"zone.id", (Object)marriageRegistrationUnit.getZone().getId()));
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }
}

