/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.domain.service;

import java.util.List;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.notification.service.NotificationService;
import org.egov.mrs.application.service.MarriageCertificateService;
import org.egov.mrs.domain.entity.MarriageCertificate;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.ReIssue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

@Service
public class MarriageSmsAndEmailService {
    private static final String MSG_KEY_SMS_REGISTRATION_NEW = "msg.newregistration.sms";
    private static final String MSG_KEY_SMS_REGISTRATION_REJECTION = "msg.rejectregistration.sms";
    private static final String MSG_KEY_SMS_REGISTRATION_APPROVED = "msg.registration.approved.sms";
    private static final String MSG_KEY_SMS_REGISTRATION_REGISTERED = "msg.registration.registered.sms";
    private static final String MSG_KEY_SMS_REISSUE_REGISTERED = "msg.reissue.registered.sms";
    private static final String MSG_KEY_EMAIL_REGISTRATION_NEW_EMAIL = "msg.newregistration.mail";
    private static final String MSG_KEY_EMAIL_REGISTRATION_NEW_SUBJECT = "msg.newregistration.mail.subject";
    private static final String MSG_KEY_EMAIL_REGISTRATION_REJECTION_EMAIL = "msg.rejectionregistration.mail";
    private static final String MSG_KEY_EMAIL_REGISTRATION_REJECTION_SUBJECT = "msg.rejectionregistration.mail.subject";
    private static final String MSG_KEY_EMAIL_REGISTRATION_REGISTERED = "msg.registration.registered.mail";
    private static final String MSG_KEY_EMAIL_REGISTRATION_REGISTERED_SUBJECT = "msg.registration.registered.mail.subject";
    private static final String MSG_KEY_SMS_REISSUE_NEW = "msg.reissue.sms";
    private static final String MSG_KEY_SMS_REISSUE_REJECTION = "msg.reissuerejected.sms";
    private static final String MSG_KEY_SMS_REISSUE_APPROVED = "msg.reissue.approved.sms";
    private static final String MSG_KEY_EMAIL_REISSUE_NEW_EMAIL = "msg.reissue.mail";
    private static final String MSG_KEY_EMAIL_REISSUE_NEW_SUBJECT = "msg.reissue.mail.subject";
    private static final String MSG_KEY_EMAIL_REISSUE_REJECTION_EMAIL = "msg.reissuerejected.mail";
    private static final String MSG_KEY_EMAIL_REISSUE_REJECTION_SUBJECT = "msg.reissuerejected.mail.subject";
    private static final String MSG_KEY_EMAIL_REISSUE_APPROVED_EMAIL = "msg.reissueApprove.mail";
    private static final String MSG_KEY_EMAIL_REISSUE_APPROVED_SUBJECT = "msg.reissueApprove.mail.subject";
    @Autowired
    private NotificationService notificationService;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource mrsMessageSource;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private MarriageCertificateService marriageCertificateService;

    public void sendSMS(MarriageRegistration registration, String status) {
        String msgKey = MSG_KEY_SMS_REGISTRATION_NEW;
        if (this.isSmsEnabled().booleanValue() && registration.getApplicationNo() != null) {
            String referenceNumber = registration.getApplicationNo();
            if (registration.getStatus() != null && registration.getStatus().getCode().equalsIgnoreCase(MarriageRegistration.RegistrationStatus.CANCELLED.toString())) {
                msgKey = MSG_KEY_SMS_REGISTRATION_REJECTION;
            } else if (registration.getStatus() != null && (registration.getStatus().getCode().equalsIgnoreCase(MarriageRegistration.RegistrationStatus.REGISTERED.toString()) || registration.getStatus().getCode().equalsIgnoreCase(MarriageRegistration.RegistrationStatus.DIGITALSIGNED.toString()))) {
                msgKey = MSG_KEY_SMS_REGISTRATION_REGISTERED;
                referenceNumber = registration.getRegistrationNo();
            } else if (registration.getStatus() != null && registration.getStatus().getCode().equalsIgnoreCase(MarriageRegistration.RegistrationStatus.APPROVED.toString())) {
                msgKey = MSG_KEY_SMS_REGISTRATION_APPROVED;
                referenceNumber = registration.getRegistrationNo();
            }
            String message = this.buildEmailMessage(registration, msgKey, referenceNumber);
            if (registration.getHusband() != null && registration.getHusband().getContactInfo() != null && registration.getHusband().getContactInfo().getMobileNo() != null) {
                this.notificationService.sendSMS(registration.getHusband().getContactInfo().getMobileNo(), message);
            }
            if (registration.getWife() != null && registration.getWife().getContactInfo() != null && registration.getWife().getContactInfo().getMobileNo() != null) {
                this.notificationService.sendSMS(registration.getWife().getContactInfo().getMobileNo(), message);
            }
        }
    }

    public void sendEmail(MarriageRegistration registration, String status) {
        String msgKeyMail = MSG_KEY_EMAIL_REGISTRATION_NEW_EMAIL;
        String msgKeyMailSubject = MSG_KEY_EMAIL_REGISTRATION_NEW_SUBJECT;
        if (this.isEmailEnabled().booleanValue() && registration.getApplicationNo() != null) {
            String referenceNumber = registration.getApplicationNo();
            if (registration.getStatus() != null && registration.getStatus().getCode().equalsIgnoreCase(MarriageRegistration.RegistrationStatus.CANCELLED.toString())) {
                msgKeyMail = MSG_KEY_EMAIL_REGISTRATION_REJECTION_EMAIL;
                msgKeyMailSubject = MSG_KEY_EMAIL_REGISTRATION_REJECTION_SUBJECT;
            } else if (registration.getStatus() != null && registration.getStatus().getCode().equalsIgnoreCase(MarriageRegistration.RegistrationStatus.APPROVED.toString())) {
                msgKeyMail = MSG_KEY_EMAIL_REGISTRATION_REGISTERED;
                msgKeyMailSubject = MSG_KEY_EMAIL_REGISTRATION_REGISTERED_SUBJECT;
                referenceNumber = registration.getRegistrationNo();
            }
            String message = this.buildEmailMessage(registration, msgKeyMail, referenceNumber);
            String subject = this.mrsMessageSource.getMessage(msgKeyMailSubject, null, null);
            if (registration.getHusband() != null && registration.getHusband().getContactInfo() != null && registration.getHusband().getContactInfo().getEmail() != null) {
                this.notificationService.sendEmail(registration.getHusband().getContactInfo().getEmail(), subject, message);
            }
            if (registration.getWife() != null && registration.getWife().getContactInfo() != null && registration.getWife().getContactInfo().getEmail() != null) {
                this.notificationService.sendEmail(registration.getWife().getContactInfo().getEmail(), subject, message);
            }
        }
    }

    public void sendSMSForReIssueApplication(ReIssue reIssue) {
        String msgKey = MSG_KEY_SMS_REISSUE_NEW;
        if (this.isSmsEnabled().booleanValue() && null != reIssue.getApplicationNo() && null != reIssue.getApplicant().getContactInfo().getMobileNo()) {
            if (reIssue.getStatus().getCode().equalsIgnoreCase(ReIssue.ReIssueStatus.CANCELLED.toString())) {
                msgKey = MSG_KEY_SMS_REISSUE_REJECTION;
            } else if (reIssue.getStatus() != null && reIssue.getStatus().getCode().equalsIgnoreCase(ReIssue.ReIssueStatus.APPROVED.toString())) {
                msgKey = MSG_KEY_SMS_REISSUE_APPROVED;
            } else if (null != reIssue.getStatus() && (reIssue.getStatus().getCode().equalsIgnoreCase(ReIssue.ReIssueStatus.CERTIFICATEREISSUED.toString()) || reIssue.getStatus().getCode().equalsIgnoreCase(ReIssue.ReIssueStatus.DIGITALSIGNED.toString()))) {
                msgKey = MSG_KEY_SMS_REISSUE_REGISTERED;
            }
            String message = this.buildMessageForIssueCertificate(reIssue, msgKey);
            this.notificationService.sendSMS(reIssue.getApplicant().getContactInfo().getMobileNo(), message);
        }
    }

    public void sendEmailForReIssueApplication(ReIssue reIssue) {
        String msgKeyMail = MSG_KEY_EMAIL_REISSUE_NEW_EMAIL;
        String msgKeyMailSubject = MSG_KEY_EMAIL_REISSUE_NEW_SUBJECT;
        if (this.isEmailEnabled().booleanValue() && null != reIssue.getApplicationNo() && null != reIssue.getApplicant().getContactInfo().getEmail()) {
            if (reIssue.getStatus().getCode().equalsIgnoreCase(ReIssue.ReIssueStatus.CANCELLED.toString())) {
                msgKeyMail = MSG_KEY_EMAIL_REISSUE_REJECTION_EMAIL;
                msgKeyMailSubject = MSG_KEY_EMAIL_REISSUE_REJECTION_SUBJECT;
            } else if (reIssue.getStatus() != null && reIssue.getStatus().getCode().equalsIgnoreCase(ReIssue.ReIssueStatus.APPROVED.toString())) {
                msgKeyMail = MSG_KEY_EMAIL_REISSUE_APPROVED_EMAIL;
                msgKeyMailSubject = MSG_KEY_EMAIL_REISSUE_APPROVED_SUBJECT;
            }
            String message = this.buildMessageForIssueCertificate(reIssue, msgKeyMail);
            String subject = this.mrsMessageSource.getMessage(msgKeyMailSubject, null, null);
            this.notificationService.sendEmail(reIssue.getApplicant().getContactInfo().getEmail(), subject, message);
        }
    }

    private String buildEmailMessage(MarriageRegistration registration, String msgKeyMail, String number) {
        MarriageCertificate marriageCertificate = this.marriageCertificateService.getGeneratedCertificate(registration);
        String pdfLink = null;
        if (null != marriageCertificate && marriageCertificate.getId() != null) {
            pdfLink = ApplicationThreadLocals.getDomainURL() + "/mrs/registration/printcertficate/" + marriageCertificate.getId();
        }
        return this.mrsMessageSource.getMessage(msgKeyMail, (Object[])new String[]{registration.getHusband().getFullName(), registration.getWife().getFullName(), registration.getApplicationNo(), pdfLink, ApplicationThreadLocals.getMunicipalityName()}, null);
    }

    private String buildMessageForIssueCertificate(ReIssue reIssue, String msgKeyMail) {
        MarriageCertificate marriageCertificate = this.marriageCertificateService.getGeneratedReIssueCertificateForPrint(reIssue);
        String pdfLink = null;
        if (null != marriageCertificate && marriageCertificate.getId() != null) {
            pdfLink = ApplicationThreadLocals.getDomainURL() + "/mrs/registration/printcertficate/" + marriageCertificate.getId();
        }
        return this.mrsMessageSource.getMessage(msgKeyMail, (Object[])new String[]{reIssue.getApplicant().getFullName(), reIssue.getApplicationNo(), pdfLink, ApplicationThreadLocals.getMunicipalityName()}, null);
    }

    public Boolean isSmsEnabled() {
        return this.getAppConfigValueByPassingModuleAndType("Marriage Registration", "SENDSMSFROOMMARRIAGEMODULE");
    }

    public Boolean getAppConfigValueByPassingModuleAndType(String moduleName, String sendsmsoremail) {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, sendsmsoremail);
        return "YES".equalsIgnoreCase(appConfigValue != null && !appConfigValue.isEmpty() ? ((AppConfigValues)appConfigValue.get(0)).getValue() : "NO");
    }

    public Boolean isEmailEnabled() {
        return this.getAppConfigValueByPassingModuleAndType("Marriage Registration", "SENDEMAILFROOMMARRIAGEMODULE");
    }
}

