/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.domain.service;

import java.util.HashMap;
import java.util.Map;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.service.MarriageRegistrationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MarriageRegistrationThirdPartyService {
    private final MarriageRegistrationService marriageRegistrationService;

    @Autowired
    public MarriageRegistrationThirdPartyService(MarriageRegistrationService marriageRegistrationService) {
        this.marriageRegistrationService = marriageRegistrationService;
    }

    public Map<String, String> validateMarriageRegistration(String applicationNo) {
        MarriageRegistration marriageRegsitration = this.marriageRegistrationService.findByApplicationNo(applicationNo);
        HashMap<String, String> statusCommentsMap = new HashMap<String, String>();
        if (marriageRegsitration.getStatus().getCode().equals("CREATED") || marriageRegsitration.getStatus().getCode().equals("APPROVED") || marriageRegsitration.getStatus().getCode().equals("DIGITALSIGNED")) {
            statusCommentsMap.put("status", "OPEN");
            statusCommentsMap.put("comments", marriageRegsitration.getState().getComments());
            statusCommentsMap.put("updatedBy", marriageRegsitration.getState().getLastModifiedBy().getName());
        } else if (marriageRegsitration.getStatus().getCode().equals("REGISTERED")) {
            statusCommentsMap.put("status", "APPROVED");
            statusCommentsMap.put("comments", marriageRegsitration.getState().getComments());
            statusCommentsMap.put("updatedBy", marriageRegsitration.getState().getLastModifiedBy().getName());
        } else if (marriageRegsitration.getStatus().getCode().equals("CANCELLED")) {
            statusCommentsMap.put("status", "REJECTED");
            statusCommentsMap.put("comments", marriageRegsitration.getState().getComments());
            statusCommentsMap.put("updatedBy", marriageRegsitration.getState().getLastModifiedBy().getName());
        }
        return statusCommentsMap;
    }
}

