/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.domain.service;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.mrs.application.service.workflow.RegistrationWorkflowService;
import org.egov.mrs.domain.entity.MarriageReassignInfo;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.ReIssue;
import org.egov.mrs.domain.service.MarriageRegistrationService;
import org.egov.mrs.domain.service.ReIssueService;
import org.egov.mrs.service.es.MarriageRegistrationUpdateIndexesService;
import org.egov.mrs.service.es.ReIssueCertificateUpdateIndexesService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MarriageReassignService {
    @Autowired
    private MarriageRegistrationService marriageRegistrationService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private MarriageRegistrationUpdateIndexesService marriageRegistrationUpdateIndexesService;
    @Autowired
    private ReIssueCertificateUpdateIndexesService reiSsueUpdateIndexesService;
    @Autowired
    private ReIssueService reIssueService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private RegistrationWorkflowService registrationWorkFlowService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private DesignationService designationService;

    public User getLoggedInUser() {
        return this.securityUtils.getCurrentUser();
    }

    public String getStateObject(MarriageReassignInfo marriageReassignInfo, Position position) {
        String applicationType = marriageReassignInfo.getStateType();
        if ("MarriageRegistration".equalsIgnoreCase(applicationType)) {
            MarriageRegistration registration = this.marriageRegistrationService.findById(marriageReassignInfo.getApplicationId());
            registration.transition().progressWithStateCopy().withOwner((OwnerGroup)position).withInitiator((OwnerGroup)position);
            this.marriageRegistrationService.update(registration);
            this.marriageRegistrationUpdateIndexesService.updateIndexes(registration);
            return registration.getApplicationNo();
        }
        if ("ReIssue".equalsIgnoreCase(applicationType)) {
            ReIssue reissue = this.reIssueService.get(marriageReassignInfo.getApplicationId());
            reissue.transition().progressWithStateCopy().withOwner((OwnerGroup)position).withInitiator((OwnerGroup)position);
            this.reIssueService.update(reissue);
            this.reiSsueUpdateIndexesService.updateReIssueAppIndex(reissue);
            return reissue.getApplicationNo();
        }
        return "";
    }

    public Map<String, String> employeePositionMap() {
        String designationStr = this.registrationWorkFlowService.getDesignationForCscOperatorWorkFlow();
        String departmentStr = this.registrationWorkFlowService.getDepartmentForCscOperatorWorkFlow();
        Department dept = this.departmentService.getDepartmentByName(departmentStr.split(",")[0]);
        List desigList = this.designationService.getDesignationsByNames(Arrays.asList(designationStr.toUpperCase().split(","))).stream().map(Designation::getId).collect(Collectors.toList());
        List assignments = this.assignmentService.findByDepartmentDesignationsAndGivenDate(dept.getId(), desigList, new Date());
        assignments.removeAll(this.assignmentService.getAllAssignmentsByEmpId(ApplicationThreadLocals.getUserId()));
        return assignments.stream().collect(Collectors.toMap(assignment -> assignment.getPosition().getId().toString(), assignment -> new StringBuffer().append(assignment.getEmployee().getName()).append("-").append(assignment.getPosition().getName()).toString(), (posId1, posId2) -> posId1));
    }
}

