/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.domain.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.commons.EgwStatus;
import org.egov.demand.model.EgDemand;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.mrs.domain.entity.MarriageCertificate;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.MrApplicant;
import org.egov.mrs.masters.entity.MarriageFee;
import org.egov.mrs.masters.entity.MarriageRegistrationUnit;
import org.egov.pims.commons.Position;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="egmrs_reissue")
@SequenceGenerator(name="SEQ_EGMRS_REISSUE", sequenceName="SEQ_EGMRS_REISSUE", allocationSize=1)
public class ReIssue
extends StateAware<Position> {
    public static final String SEQ_REISSUE = "SEQ_EGMRS_REISSUE";
    private static final long serialVersionUID = 7398043339748917008L;
    @Id
    @GeneratedValue(generator="SEQ_EGMRS_REISSUE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    private String applicationNo;
    @NotNull
    private Date applicationDate;
    private Date reIssueDate;
    @NotNull
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="zone")
    private Boundary zone;
    @NotNull
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="registrationUnit")
    private MarriageRegistrationUnit marriageRegistrationUnit;
    @NotNull
    @Valid
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="applicant")
    private MrApplicant applicant;
    @NotNull
    @Valid
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="registration")
    private MarriageRegistration registration;
    @ManyToOne
    @JoinColumn(name="feecriteria", nullable=false)
    private MarriageFee feeCriteria;
    @NotNull
    private Double feePaid;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="demand")
    private EgDemand demand;
    @ManyToOne
    @JoinColumn(name="status", nullable=false)
    private EgwStatus status;
    private boolean isActive;
    @Length(max=256)
    private String rejectionReason;
    @Length(max=256)
    private String remarks;
    @Transient
    private Long approvalDepartment;
    @Transient
    private String approvalComent;
    @SafeHtml
    @Length(max=15)
    private String source;
    @OneToMany(mappedBy="reIssue", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<MarriageCertificate> marriageCertificate = new ArrayList<MarriageCertificate>();

    public String getStateDetails() {
        return "Marriage registration re-issue application no : " + this.applicationNo;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public MrApplicant getApplicant() {
        return this.applicant;
    }

    public void setApplicant(MrApplicant applicant) {
        this.applicant = applicant;
    }

    public MarriageRegistration getRegistration() {
        return this.registration;
    }

    public void setRegistration(MarriageRegistration registration) {
        this.registration = registration;
    }

    public String getApplicationNo() {
        return this.applicationNo;
    }

    public void setApplicationNo(String applicationNo) {
        this.applicationNo = applicationNo;
    }

    public Date getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    public Date getReIssueDate() {
        return this.reIssueDate;
    }

    public void setReIssueDate(Date reIssueDate) {
        this.reIssueDate = reIssueDate;
    }

    public MarriageFee getFeeCriteria() {
        return this.feeCriteria;
    }

    public void setFeeCriteria(MarriageFee feeCriteria) {
        this.feeCriteria = feeCriteria;
    }

    public Double getFeePaid() {
        return this.feePaid;
    }

    public void setFeePaid(Double feePaid) {
        this.feePaid = feePaid;
    }

    public EgDemand getDemand() {
        return this.demand;
    }

    public void setDemand(EgDemand demand) {
        this.demand = demand;
    }

    public String getRejectionReason() {
        return this.rejectionReason;
    }

    public void setRejectionReason(String rejectionReason) {
        this.rejectionReason = rejectionReason;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Long getApprovalDepartment() {
        return this.approvalDepartment;
    }

    public void setApprovalDepartment(Long approvalDepartment) {
        this.approvalDepartment = approvalDepartment;
    }

    public String getApprovalComent() {
        return this.approvalComent;
    }

    public void setApprovalComent(String approvalComent) {
        this.approvalComent = approvalComent;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public List<MarriageCertificate> getMarriageCertificate() {
        return this.marriageCertificate;
    }

    public void setMarriageCertificate(List<MarriageCertificate> marriageCertificate) {
        this.marriageCertificate = marriageCertificate;
    }

    public void addCertificate(MarriageCertificate certificate) {
        this.getMarriageCertificate().add(certificate);
    }

    public void removeCertificate(MarriageCertificate certificate) {
        this.getMarriageCertificate().remove((Object)certificate);
    }

    public boolean isFeeCollected() {
        return this.demand.getBaseDemand().compareTo(this.demand.getAmtCollected()) <= 0;
    }

    public Boundary getZone() {
        return this.zone;
    }

    public void setZone(Boundary zone) {
        this.zone = zone;
    }

    public MarriageRegistrationUnit getMarriageRegistrationUnit() {
        return this.marriageRegistrationUnit;
    }

    public void setMarriageRegistrationUnit(MarriageRegistrationUnit marriageRegistrationUnit) {
        this.marriageRegistrationUnit = marriageRegistrationUnit;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public static enum ReIssueStatus {
        CREATED,
        APPROVED,
        REJECTED,
        CANCELLED,
        CERTIFICATEREISSUED,
        DIGITALSIGNED;

    }
}

