/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.domain.entity;

import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.entity.EducationalQualification;
import org.egov.common.entity.Nationality;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.mrs.domain.entity.Contact;
import org.egov.mrs.domain.entity.IdentityProof;
import org.egov.mrs.domain.entity.MarriageDocument;
import org.egov.mrs.domain.entity.MrApplicantDocument;
import org.egov.mrs.domain.entity.Name;
import org.egov.mrs.domain.enums.MaritalStatus;
import org.egov.mrs.domain.enums.ReligionPractice;
import org.egov.mrs.masters.entity.MarriageReligion;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

@Entity
@Table(name="egmrs_applicant")
@SequenceGenerator(name="SEQ_EGMRS_APPLICANT", sequenceName="SEQ_EGMRS_APPLICANT", allocationSize=1)
public class MrApplicant
extends AbstractAuditable {
    private static final long serialVersionUID = -4678440835941976527L;
    public static final String SEQ_APPLICANT = "SEQ_EGMRS_APPLICANT";
    @Id
    @GeneratedValue(generator="SEQ_EGMRS_APPLICANT", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Embedded
    private Name name;
    @SafeHtml
    @Length(max=20)
    private String otherName;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="religion")
    private MarriageReligion religion;
    @Enumerated(value=EnumType.STRING)
    private ReligionPractice religionPractice;
    @NotNull
    @Column(name="ageinyears")
    private Integer ageInYearsAsOnMarriage;
    @NotNull
    @Length(min=1)
    @Column(name="ageinmonths")
    private Integer ageInMonthsAsOnMarriage;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="relationstatus")
    private MaritalStatus maritalStatus;
    @NotNull
    @SafeHtml
    @Length(max=60)
    private String occupation;
    @SafeHtml
    @Length(max=20)
    private String aadhaarNo;
    @Transient
    private byte[] photo;
    @Transient
    private byte[] signature;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="photoFileStore")
    private FileStoreMapper photoFileStore;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="signatureFileStore")
    private FileStoreMapper signatureFileStore;
    @NotNull
    @Valid
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="proofsattached")
    private IdentityProof proofsAttached;
    @Embedded
    private Contact contactInfo;
    @NotNull
    @Valid
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="applicant")
    private Set<MrApplicantDocument> applicantDocuments = new HashSet<MrApplicantDocument>();
    @NotNull
    @Length(max=70)
    private String parentsName;
    @NotNull
    @ManyToOne
    @JoinColumn(name="qualification")
    private EducationalQualification qualification;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nationality")
    private Nationality nationality;
    @NotNull
    @Length(max=100)
    private String street;
    @NotNull
    @Length(max=100)
    private String locality;
    @NotNull
    @Length(max=30)
    private String city;
    @Transient
    private List<MarriageDocument> documents;
    private transient MultipartFile photoFile;
    private transient MultipartFile signatureFile;
    private transient String encodedPhoto;
    private transient String encodedSignature;
    private boolean handicapped = false;

    public String getFullName() {
        String fullName = this.getName().getFirstName();
        fullName = fullName + (this.getName().getMiddleName() == null ? "" : " " + this.getName().getMiddleName());
        fullName = fullName + (this.getName().getLastName() == null ? "" : " " + this.getName().getLastName());
        return fullName;
    }

    public void copyPhotoAndSignatureToByteArray() throws IOException {
        this.setPhoto(FileCopyUtils.copyToByteArray((InputStream)this.getPhotoFile().getInputStream()));
        if (this.getSignatureFile() != null) {
            this.setSignature(FileCopyUtils.copyToByteArray((InputStream)this.getSignatureFile().getInputStream()));
        }
    }

    public boolean isCopyFilesToByteArray() {
        return this.photoFile != null && this.photoFile.getSize() > 0L || this.signatureFile != null && this.signatureFile.getSize() > 0L;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOtherName() {
        return this.otherName;
    }

    public void setOtherName(String otherName) {
        this.otherName = otherName;
    }

    public MarriageReligion getReligion() {
        return this.religion;
    }

    public void setReligion(MarriageReligion religion) {
        this.religion = religion;
    }

    public ReligionPractice getReligionPractice() {
        return this.religionPractice;
    }

    public void setReligionPractice(ReligionPractice religionPractice) {
        this.religionPractice = religionPractice;
    }

    public Integer getAgeInYearsAsOnMarriage() {
        return this.ageInYearsAsOnMarriage;
    }

    public void setAgeInYearsAsOnMarriage(Integer ageInYearsAsOnMarriage) {
        this.ageInYearsAsOnMarriage = ageInYearsAsOnMarriage;
    }

    public Integer getAgeInMonthsAsOnMarriage() {
        return this.ageInMonthsAsOnMarriage;
    }

    public void setAgeInMonthsAsOnMarriage(Integer ageInMonthsAsOnMarriage) {
        this.ageInMonthsAsOnMarriage = ageInMonthsAsOnMarriage;
    }

    public MaritalStatus getMaritalStatus() {
        return this.maritalStatus;
    }

    public void setMaritalStatus(MaritalStatus maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public String getOccupation() {
        return this.occupation;
    }

    public void setOccupation(String occupation) {
        this.occupation = occupation;
    }

    public String getAadhaarNo() {
        return this.aadhaarNo;
    }

    public void setAadhaarNo(String aadhaarNo) {
        this.aadhaarNo = aadhaarNo;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public byte[] getPhoto() {
        return this.photo;
    }

    public void setPhoto(byte[] photo) {
        this.photo = photo;
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public IdentityProof getProofsAttached() {
        return this.proofsAttached;
    }

    public void setProofsAttached(IdentityProof proofsAttached) {
        this.proofsAttached = proofsAttached;
    }

    public Contact getContactInfo() {
        return this.contactInfo;
    }

    public void setContactInfo(Contact contactInfo) {
        this.contactInfo = contactInfo;
    }

    public List<MarriageDocument> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<MarriageDocument> documents) {
        this.documents = documents;
    }

    public void addApplicantDocument(MrApplicantDocument applicantDocument) {
        applicantDocument.setApplicant(this);
        this.getApplicantDocuments().add(applicantDocument);
    }

    public MultipartFile getPhotoFile() {
        return this.photoFile;
    }

    public void setPhotoFile(MultipartFile photoFile) {
        this.photoFile = photoFile;
    }

    public MultipartFile getSignatureFile() {
        return this.signatureFile;
    }

    public void setSignatureFile(MultipartFile signatureFile) {
        this.signatureFile = signatureFile;
    }

    public String getEncodePhotoToString() {
        return Base64.getEncoder().encodeToString(this.getPhoto());
    }

    public String getEncodedPhoto() {
        return this.encodedPhoto;
    }

    public void setEncodedPhoto(String encodedPhoto) {
        this.encodedPhoto = encodedPhoto;
    }

    public String getEncodedSignature() {
        return this.encodedSignature;
    }

    public void setEncodedSignature(String encodedSignature) {
        this.encodedSignature = encodedSignature;
    }

    public FileStoreMapper getPhotoFileStore() {
        return this.photoFileStore;
    }

    public void setPhotoFileStore(FileStoreMapper photoFileStore) {
        this.photoFileStore = photoFileStore;
    }

    public FileStoreMapper getSignatureFileStore() {
        return this.signatureFileStore;
    }

    public void setSignatureFileStore(FileStoreMapper signatureFileStore) {
        this.signatureFileStore = signatureFileStore;
    }

    public boolean isHandicapped() {
        return this.handicapped;
    }

    public void setHandicapped(boolean handicapped) {
        this.handicapped = handicapped;
    }

    public String getParentsName() {
        return this.parentsName;
    }

    public void setParentsName(String parentsName) {
        this.parentsName = parentsName;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Nationality getNationality() {
        return this.nationality;
    }

    public void setNationality(Nationality nationality) {
        this.nationality = nationality;
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public EducationalQualification getQualification() {
        return this.qualification;
    }

    public void setQualification(EducationalQualification qualification) {
        this.qualification = qualification;
    }

    public Set<MrApplicantDocument> getApplicantDocuments() {
        return this.applicantDocuments;
    }

    public void setApplicantDocuments(Set<MrApplicantDocument> applicantDocuments) {
        this.applicantDocuments = applicantDocuments;
    }
}

