/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.domain.entity;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.mrs.domain.entity.DocumentProofType;
import org.egov.mrs.domain.enums.MarriageDocumentType;
import org.hibernate.validator.constraints.SafeHtml;
import org.springframework.web.multipart.MultipartFile;

@Entity
@Table(name="egmrs_document")
@Unique(id="id", tableName="egmrs_document", columnName={"name", "code"}, fields={"name", "code"}, enableDfltMsg=true, message="Already Exist.Name should be unique.")
@SequenceGenerator(name="SEQ_EGMRS_DOCUMENT", sequenceName="SEQ_EGMRS_DOCUMENT", allocationSize=1)
public class MarriageDocument
extends AbstractAuditable {
    private static final long serialVersionUID = 1L;
    public static final String SEQ_DOCUMENT = "SEQ_EGMRS_DOCUMENT";
    @Id
    @GeneratedValue(generator="SEQ_EGMRS_DOCUMENT", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @SafeHtml
    private String name;
    @NotNull
    @SafeHtml
    private String code;
    private boolean individual;
    private boolean active;
    private boolean mandatory;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private DocumentProofType documentProofType;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private MarriageDocumentType type;
    @Transient
    private MultipartFile file;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean isIndividual() {
        return this.individual;
    }

    public void setIndividual(boolean individual) {
        this.individual = individual;
    }

    public MarriageDocumentType getType() {
        return this.type;
    }

    public void setType(MarriageDocumentType type) {
        this.type = type;
    }

    public MultipartFile getFile() {
        return this.file;
    }

    public void setFile(MultipartFile file) {
        this.file = file;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public DocumentProofType getDocumentProofType() {
        return this.documentProofType;
    }

    public void setDocumentProofType(DocumentProofType documentProofType) {
        this.documentProofType = documentProofType;
    }
}

