/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.application.service.collection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.demand.dao.EgDemandDao;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.AbstractBillable;
import org.egov.demand.model.EgBillType;
import org.egov.demand.model.EgDemand;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
@Scope(value="prototype")
public class RegistrationBillable
extends AbstractBillable
implements Billable {
    private static final String STRING_SERVICE_CODE = "MR";
    public static final String DISPLAY_MESSAGE = "Marriage Registration Fee Collection";
    public static final String MARRIAGE_REGISTRATION = "Marriage_Registration";
    public static final String BILLTYPE_AUTO = "AUTO";
    private Long userId;
    private EgBillType billType;
    private boolean callbackForApportion = Boolean.FALSE;
    private String referenceNumber;
    private String transanctionReferenceNumber;
    private MarriageRegistration registration;
    @Autowired
    private EgDemandDao egDemandDAO;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private AppConfigValueService appConfigValuesService;

    public String getBillPayee() {
        return this.registration.getHusband().getName().getFirstName() + " and " + this.registration.getWife().getName().getFirstName();
    }

    public String getBillAddress() {
        return this.registration.getHusband().getContactInfo().getResidenceAddress();
    }

    public EgDemand getCurrentDemand() {
        return this.registration.getDemand();
    }

    public List<EgDemand> getAllDemands() {
        ArrayList<EgDemand> demands = null;
        Long demandIds = this.getCurrentDemand().getId();
        if (demandIds != null) {
            demands = new ArrayList<EgDemand>();
            demands.add(this.egDemandDAO.findById(Long.valueOf(demandIds.toString()), false));
        }
        return demands;
    }

    public EgBillType getBillType() {
        return this.billType;
    }

    public Date getBillLastDueDate() {
        return new DateTime().plusMonths(1).toDate();
    }

    public Long getBoundaryNum() {
        return this.registration.getZone().getBoundaryNum();
    }

    public String getBoundaryType() {
        AppConfigValues boundaryType = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Marriage Registration", "MARRIAGE_REGISTRATIONUNIT_BOUNDARYYTYPE").get(0);
        return boundaryType != null && !"".equals(boundaryType) ? boundaryType.getValue() : "City";
    }

    public String getDepartmentCode() {
        AppConfigValues marriageDeptCode = this.getAppConfigValue("MARRIAGE_DEPARTMENT_CODE");
        return marriageDeptCode != null ? marriageDeptCode.getValue() : null;
    }

    public BigDecimal getFunctionaryCode() {
        AppConfigValues marriageFunctionaryCode = this.getAppConfigValue("MARRIAGE_DEFAULT_FUNCTIONARY_CODE");
        return marriageFunctionaryCode != null ? new BigDecimal(marriageFunctionaryCode.getValue()) : null;
    }

    public String getFundCode() {
        AppConfigValues marriageFundCode = this.getAppConfigValue("MARRIAGE_DEFAULT_FUND_CODE");
        return marriageFundCode != null ? marriageFundCode.getValue() : null;
    }

    public String getFundSourceCode() {
        AppConfigValues marriageFundSrcCode = this.getAppConfigValue("MARRIAGE_DEFAULT_FUND_SRC_CODE");
        return marriageFundSrcCode != null ? marriageFundSrcCode.getValue() : null;
    }

    public AppConfigValues getAppConfigValue(String code) {
        List appConfigResult = this.appConfigValuesService.getConfigValuesByModuleAndKey("Marriage Registration", code);
        return !appConfigResult.isEmpty() ? (AppConfigValues)appConfigResult.get(0) : null;
    }

    public Date getIssueDate() {
        return new Date();
    }

    public Date getLastDate() {
        return this.getBillLastDueDate();
    }

    public Module getModule() {
        return this.moduleService.getModuleByName("Marriage Registration");
    }

    public Boolean getOverrideAccountHeadsAllowed() {
        return false;
    }

    public Boolean getPartPaymentAllowed() {
        return false;
    }

    public String getServiceCode() {
        return STRING_SERVICE_CODE;
    }

    public BigDecimal getTotalAmount() {
        return new BigDecimal(this.registration.getFeePaid());
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getDescription() {
        return this.registration.getRegistrationNo() != null ? "Marriage Registration with Registration No. : " + this.registration.getRegistrationNo() : "Marriage Registration with Application No. : " + this.registration.getApplicationNo();
    }

    public String getDisplayMessage() {
        return DISPLAY_MESSAGE;
    }

    public String getCollModesNotAllowed() {
        return "cheque" + "cheque/dd" + "dd" + "card" + "bankchallan" + "online";
    }

    public String getConsumerId() {
        return this.registration.getApplicationNo();
    }

    public Boolean isCallbackForApportion() {
        return this.callbackForApportion;
    }

    public void setCallbackForApportion(Boolean b) {
        this.callbackForApportion = b;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public String getTransanctionReferenceNumber() {
        return this.transanctionReferenceNumber;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setBillType(EgBillType billType) {
        this.billType = billType;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public void setTransanctionReferenceNumber(String transanctionReferenceNumber) {
        this.transanctionReferenceNumber = transanctionReferenceNumber;
    }

    public MarriageRegistration getRegistration() {
        return this.registration;
    }

    public void setRegistration(MarriageRegistration registration) {
        this.registration = registration;
    }

    public String getEmailId() {
        return null;
    }

    public String getConsumerType() {
        return null;
    }
}

