/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.application.service.collection;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.BillReceiptInfoImpl;
import org.egov.collection.integration.models.ReceiptAccountInfo;
import org.egov.collection.integration.models.ReceiptAmountInfo;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.integration.TaxCollection;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class MarriageFeeCollection
extends TaxCollection {
    private static final Logger LOGGER = Logger.getLogger(MarriageFeeCollection.class);
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private ModuleService moduleService;
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public void updateDemandDetails(BillReceiptInfo billRcptInfo) {
        BigDecimal totalAmount = billRcptInfo.getTotalAmount();
        EgDemand demand = this.getCurrentDemand(Long.valueOf(billRcptInfo.getBillReferenceNum()));
        String registrationNo = ((BillReceiptInfoImpl)billRcptInfo).getReceiptMisc().getReceiptHeader().getConsumerCode();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("updateDemandDetails : Demand before proceeding : " + demand));
            LOGGER.debug((Object)String.format(" updateDemandDetails : collection back update started for Marriage Registration No : %s, for %s, amounting to Rs. %s and with Receipt No %s", registrationNo, billRcptInfo.getEvent(), totalAmount, billRcptInfo.getReceiptNum()));
        }
        if (billRcptInfo.getEvent().equals("RECEIPT_CREATED")) {
            this.updateCollForRcptCreate(demand, billRcptInfo, totalAmount);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("updateDemandDetails : Demand after processed : " + demand));
        }
    }

    @Transactional
    public void updateCollForRcptCreate(EgDemand demand, BillReceiptInfo billRcptInfo, BigDecimal totalAmount) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format(" updateCollForRcptCreate : Updating Collection Started For Demand=%s with BillReceiptInfo=%s ", demand, billRcptInfo));
        }
        this.updateDemandDetailForReceiptCreate(billRcptInfo.getAccountDetails(), demand, billRcptInfo, totalAmount);
    }

    @Transactional
    public void updateDemandDetailForReceiptCreate(Set<ReceiptAccountInfo> accountDetails, EgDemand demand, BillReceiptInfo billRcptInfo, BigDecimal totalAmount) {
        StringBuilder query = new StringBuilder(500).append("select dmdet FROM EgDemandDetails dmdet  left join fetch dmdet.egDemandReason dmdRsn left join fetch dmdRsn.egDemandReasonMaster dmdRsnMstr left join fetch dmdRsn.egInstallmentMaster installment WHERE dmdet.egDemand.id = :demand");
        List demandDetails = this.getCurrentSession().createQuery(query.toString()).setLong("demand", demand.getId().longValue()).list();
        for (ReceiptAccountInfo receiptAccount : accountDetails) {
            if (!StringUtils.isNotBlank((String)receiptAccount.getDescription()) || receiptAccount.getCrAmount() == null || receiptAccount.getCrAmount().compareTo(BigDecimal.ZERO) != 1) continue;
            String[] desc = receiptAccount.getDescription().split("-", 2);
            String reason = desc[0].trim();
            String installment = desc[1].trim();
            for (EgDemandDetails demandDetail : demandDetails) {
                if (!reason.equalsIgnoreCase(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster()) || !installment.equalsIgnoreCase(demandDetail.getEgDemandReason().getEgInstallmentMaster().getDescription())) continue;
                demandDetail.addCollectedWithOnePaisaTolerance(receiptAccount.getCrAmount());
                if (demandDetail.getEgDemandReason().getEgDemandReasonMaster().getIsDemand().booleanValue()) {
                    demand.addCollected(receiptAccount.getCrAmount());
                }
                this.persistCollectedReceipts(demandDetail, billRcptInfo.getReceiptNum(), totalAmount, billRcptInfo.getReceiptDate(), demandDetail.getAmtCollected());
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)String.format("Persisted demand and receipt details for tax=%s, installment=%s, receipt no=%s, for Rs. %s ", reason, installment, billRcptInfo.getReceiptNum(), receiptAccount.getCrAmount()));
        }
    }

    protected Module module() {
        return this.moduleService.getModuleByName("Marriage Registration");
    }

    public EgDemand getCurrentDemand(Long billId) {
        EgBill egBill = this.egBillDAO.findById(billId, false);
        return egBill.getEgDemand();
    }

    @Transactional
    public void updateCollectionForRcptCancel(EgDemand demand, BillReceiptInfo billRcptInfo) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("reconcileCollForRcptCancel : Updating Collection Started For Demand : " + demand + " with BillReceiptInfo - " + billRcptInfo));
        }
        this.cancelBill(Long.valueOf(billRcptInfo.getBillReferenceNum()));
        this.updateDmdDetForRcptCancel(demand, billRcptInfo);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("reconcileCollForRcptCancel : Updating Collection finished For Demand : " + demand));
        }
    }

    @Transactional
    public void cancelBill(Long billId) {
        if (billId != null) {
            EgBill egBill = this.egBillDAO.findById(billId, false);
            egBill.setIs_Cancelled("Y");
        }
    }

    @Transactional
    public void updateDmdDetForRcptCancel(EgDemand demand, BillReceiptInfo billRcptInfo) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entering method updateDmdDetForRcptCancel");
        }
        for (ReceiptAccountInfo rcptAccInfo : billRcptInfo.getAccountDetails()) {
            if (rcptAccInfo.getCrAmount() == null || rcptAccInfo.getCrAmount().compareTo(BigDecimal.ZERO) != 1 || rcptAccInfo.getIsRevenueAccount()) continue;
            String[] desc = rcptAccInfo.getDescription().split("-", 2);
            String reason = desc[0].trim();
            String installment = desc[1].trim();
            for (EgDemandDetails demandDetail : demand.getEgDemandDetails()) {
                if (!reason.equalsIgnoreCase(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster()) || !installment.equalsIgnoreCase(demandDetail.getEgDemandReason().getEgInstallmentMaster().getDescription())) continue;
                if (demandDetail.getAmtCollected().compareTo(rcptAccInfo.getCrAmount()) < 0) {
                    throw new ApplicationRuntimeException("updateDmdDetForRcptCancel : Exception while updating cancel receipt, to be deducted amount " + rcptAccInfo.getCrAmount() + " is greater than the collected amount " + demandDetail.getAmtCollected() + " for demandDetail " + demandDetail);
                }
                demandDetail.setAmtCollected(demandDetail.getAmtCollected().subtract(rcptAccInfo.getCrAmount()));
                if (demand.getAmtCollected() != null && demand.getAmtCollected().compareTo(BigDecimal.ZERO) > 0 && demandDetail.getEgDemandReason().getEgDemandReasonMaster().getIsDemand().booleanValue()) {
                    demand.setAmtCollected(demand.getAmtCollected().subtract(rcptAccInfo.getCrAmount()));
                }
                LOGGER.info((Object)("Deducted Collected amount Rs." + rcptAccInfo.getCrAmount() + " for tax : " + reason + " and installment : " + installment));
            }
        }
        this.updateReceiptStatusWhenCancelled(billRcptInfo.getReceiptNum());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exiting method updateDmdDetForRcptCancel");
        }
    }

    public List<ReceiptDetail> reconstructReceiptDetail(String billReferenceNumber, BigDecimal actualAmountPaid, List<ReceiptDetail> receiptDetailList) {
        return receiptDetailList;
    }

    public String constructAdditionalInfoForReceipt(BillReceiptInfo billReceiptInfo) {
        return null;
    }

    public ReceiptAmountInfo receiptAmountBifurcation(BillReceiptInfo billReceiptInfo) {
        ReceiptAmountInfo receiptAmountInfo = new ReceiptAmountInfo();
        BigDecimal currentInstallmentAmount = BigDecimal.ZERO;
        if (billReceiptInfo != null && billReceiptInfo.getBillReferenceNum() != null) {
            for (ReceiptAccountInfo rcptAccInfo : billReceiptInfo.getAccountDetails()) {
                if (rcptAccInfo.getCrAmount() == null || rcptAccInfo.getCrAmount().compareTo(BigDecimal.ZERO) != 1) continue;
                currentInstallmentAmount = currentInstallmentAmount.add(rcptAccInfo.getCrAmount());
            }
        }
        receiptAmountInfo.setCurrentInstallmentAmount(currentInstallmentAmount);
        return receiptAmountInfo;
    }
}

