/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.application.service.collection;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.commons.Installment;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.interfaces.BillServiceInterface;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.EgBillDetails;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.demand.model.EgDemandReasonMaster;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.mrs.application.service.collection.ReIssueBillable;
import org.egov.mrs.application.service.collection.RegistrationBillable;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.ReIssue;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class MarriageBillService
extends BillServiceInterface {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private RegistrationBillable billableRegistration;
    @Autowired
    private ReIssueBillable billableReIssue;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private AppConfigValueService appConfigValuesService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public String generateBill(MarriageRegistration registration) {
        String billXml;
        this.billableRegistration.setRegistration(registration);
        this.billableRegistration.setUserId(this.securityUtils.getCurrentUser().getId());
        this.billableRegistration.setBillType(this.egBillDAO.getBillTypeByCode("AUTO"));
        this.billableRegistration.setReferenceNumber(registration.getApplicationNo());
        try {
            billXml = URLEncoder.encode(this.getBillXML(this.billableRegistration), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ApplicationRuntimeException("", (Throwable)e);
        }
        return billXml;
    }

    @Transactional
    public String generateBill(ReIssue reIssue) {
        String billXml;
        this.billableReIssue.setReIssue(reIssue);
        this.billableReIssue.setUserId(this.securityUtils.getCurrentUser().getId());
        this.billableReIssue.setBillType(this.egBillDAO.getBillTypeByCode("AUTO"));
        this.billableReIssue.setReferenceNumber(reIssue.getApplicationNo());
        try {
            billXml = URLEncoder.encode(this.getBillXML(this.billableReIssue), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ApplicationRuntimeException("", (Throwable)e);
        }
        return billXml;
    }

    public List<EgBillDetails> getBilldetails(Billable billObj) {
        ArrayList<EgBillDetails> billDetails = new ArrayList<EgBillDetails>();
        EgDemand demand = billObj.getCurrentDemand();
        Date currentDate = new Date();
        StringBuilder descriptionBuilder = new StringBuilder();
        AppConfigValues marriageFunctionCode = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Marriage Registration", "MARRIAGE_FUNCTION_CODE").get(0);
        int orderNo = 1;
        for (EgDemandDetails demandDetail : demand.getEgDemandDetails()) {
            boolean thereIsBalanceFee;
            EgDemandReason reason = demandDetail.getEgDemandReason();
            Installment installment = reason.getEgInstallmentMaster();
            boolean bl = thereIsBalanceFee = demandDetail.getAmount() != null && demandDetail.getAmount().compareTo(demandDetail.getAmtCollected()) > 0;
            EgDemandReasonMaster demandReasonMaster = reason.getEgDemandReasonMaster();
            if (!"N".equalsIgnoreCase(demandReasonMaster.getIsDebit()) || !thereIsBalanceFee) continue;
            EgBillDetails billdetail = new EgBillDetails();
            billdetail.setDrAmount(BigDecimal.ZERO);
            billdetail.setCrAmount(demandDetail.getAmount().subtract(demandDetail.getAmtCollected()));
            if (reason.getGlcodeId() == null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("MarriageBillService.getBilldetails - GLCODE does not exists for reason=" + demandReasonMaster.getReasonMaster()));
                }
            } else {
                billdetail.setGlcode(reason.getGlcodeId().getGlcode());
            }
            billdetail.setFunctionCode(marriageFunctionCode != null ? marriageFunctionCode.getValue() : "");
            billdetail.setEgDemandReason(reason);
            billdetail.setAdditionalFlag(Integer.valueOf(1));
            billdetail.setCreateDate(currentDate);
            billdetail.setModifiedDate(currentDate);
            billdetail.setOrderNo(Integer.valueOf(orderNo++));
            billdetail.setPurpose(BillAccountDetails.PURPOSE.OTHERS.toString());
            descriptionBuilder.append(demandReasonMaster.getReasonMaster()).append(" - ").append(installment.getDescription());
            billdetail.setDescription(descriptionBuilder.toString());
            billDetails.add(billdetail);
        }
        return billDetails;
    }

    public void cancelBill() {
    }

    public EgBillDetails createBillDet(Integer orderNo, BigDecimal billDetailAmount, String glCode, String description, Integer addlFlag) {
        AppConfigValues marriageFunctionCode = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Marriage Registration", "MARRIAGE_FUNCTION_CODE").get(0);
        if (orderNo == null || billDetailAmount == null || glCode == null) {
            throw new ApplicationRuntimeException("Exception in createBillDet....");
        }
        EgBillDetails billdetail = new EgBillDetails();
        billdetail.setFunctionCode(marriageFunctionCode != null ? marriageFunctionCode.getValue() : "");
        billdetail.setOrderNo(orderNo);
        billdetail.setCreateDate(new Date());
        billdetail.setModifiedDate(new Date());
        billdetail.setCrAmount(billDetailAmount);
        billdetail.setDrAmount(BigDecimal.ZERO);
        billdetail.setGlcode(glCode);
        billdetail.setDescription(description);
        billdetail.setAdditionalFlag(addlFlag);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Bill Detail object created with amount " + billDetailAmount));
        }
        return billdetail;
    }
}

