/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.domain.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.mrs.domain.entity.MarriageDocument;
import org.egov.mrs.domain.enums.MarriageDocumentType;
import org.egov.mrs.domain.repository.MarriageDocumentRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class MarriageDocumentService {
    @Autowired
    private MarriageDocumentRepository documentRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public void create(MarriageDocument document) {
        this.documentRepository.save((Object)document);
    }

    @Transactional
    public MarriageDocument updateDocument(MarriageDocument marriageDocument) {
        return (MarriageDocument)((Object)this.documentRepository.saveAndFlush((Object)marriageDocument));
    }

    public MarriageDocument get(Long id) {
        return this.documentRepository.findById(id);
    }

    public MarriageDocument get(String docuementName) {
        return this.documentRepository.findByName(docuementName);
    }

    public List<MarriageDocument> getAll() {
        return this.documentRepository.findAll();
    }

    public List<MarriageDocument> getIndividualDocuments() {
        return this.documentRepository.findByIndividualAndActive(true, true);
    }

    public List<MarriageDocument> getGeneralDocuments() {
        return this.documentRepository.findByIndividualAndActive(false, true);
    }

    public List<MarriageDocument> getReIssueApplicantDocs() {
        return this.documentRepository.findByType(MarriageDocumentType.CERTIFICATEREISSUE);
    }

    public List<MarriageDocument> searchMarriageDocument(MarriageDocument marriageDocument) {
        Criteria criteria = this.getCurrentSession().createCriteria(MarriageDocument.class);
        if (marriageDocument.getType() != null && "REGISTRATION".equalsIgnoreCase(marriageDocument.getType().name())) {
            criteria.add((Criterion)Restrictions.eq((String)"type", (Object)((Object)MarriageDocumentType.REGISTRATION)));
        } else if (marriageDocument.getType() != null && "CERTIFICATEREISSUE".equalsIgnoreCase(marriageDocument.getType().name())) {
            criteria.add((Criterion)Restrictions.eq((String)"type", (Object)((Object)MarriageDocumentType.CERTIFICATEREISSUE)));
        }
        if (marriageDocument.isActive()) {
            criteria.add((Criterion)Restrictions.eq((String)"active", (Object)marriageDocument.isActive()));
        }
        return criteria.list();
    }
}

