/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.domain.entity;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.mrs.domain.entity.Contact;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.Name;
import org.egov.mrs.domain.enums.MRApplicantType;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;
import org.springframework.web.multipart.MultipartFile;

@Entity
@Table(name="egmrs_witness")
@SequenceGenerator(name="SEQ_EGMRS_WITNESS", sequenceName="SEQ_EGMRS_WITNESS", allocationSize=1)
public class MarriageWitness
extends AbstractAuditable {
    private static final long serialVersionUID = 8963626310849299317L;
    public static final String SEQ_WITNESS = "SEQ_EGMRS_WITNESS";
    @Id
    @GeneratedValue(generator="SEQ_EGMRS_WITNESS", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Embedded
    private Name name;
    @NotNull
    @SafeHtml
    @Length(max=60)
    private String occupation;
    @NotNull
    @SafeHtml
    @Length(max=30)
    private String relationshipWithApplicant;
    @NotNull
    @Length(min=25)
    private Integer age;
    @NotNull
    @SafeHtml
    @Length(max=30)
    private String witnessRelation;
    @NotNull
    @SafeHtml
    @Length(max=70)
    private String relativeName;
    @SafeHtml
    @Length(max=20)
    private String aadhaarNo;
    @Transient
    private byte[] signature;
    @Transient
    private byte[] photo;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="photoFileStore")
    private FileStoreMapper photoFileStore;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="signatureFileStore")
    private FileStoreMapper signatureFileStore;
    private transient MultipartFile photoFile;
    private transient MultipartFile signatureFile;
    private transient String encodedPhoto;
    private transient String encodedSignature;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="registration")
    private MarriageRegistration registration;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="applicantType")
    private MRApplicantType applicantType;
    @Embedded
    private Contact contactInfo;

    public String getFullName() {
        String fullName = this.getName().getFirstName();
        fullName = fullName + (this.getName().getMiddleName() == null ? "" : " " + this.getName().getMiddleName());
        fullName = fullName + (this.getName().getLastName() == null ? "" : " " + this.getName().getLastName());
        return fullName;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public String getOccupation() {
        return this.occupation;
    }

    public void setOccupation(String occupation) {
        this.occupation = occupation;
    }

    public String getRelationshipWithApplicant() {
        return this.relationshipWithApplicant;
    }

    public void setRelationshipWithApplicant(String relationshipWithApplicant) {
        this.relationshipWithApplicant = relationshipWithApplicant;
    }

    public Integer getAge() {
        return this.age;
    }

    public void setAge(Integer age) {
        this.age = age;
    }

    public String getAadhaarNo() {
        return this.aadhaarNo;
    }

    public void setAadhaarNo(String aadhaarNo) {
        this.aadhaarNo = aadhaarNo;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public byte[] getPhoto() {
        return this.photo;
    }

    public void setPhoto(byte[] photo) {
        this.photo = photo;
    }

    public MarriageRegistration getRegistration() {
        return this.registration;
    }

    public void setRegistration(MarriageRegistration registration) {
        this.registration = registration;
    }

    public Contact getContactInfo() {
        return this.contactInfo;
    }

    public void setContactInfo(Contact contactInfo) {
        this.contactInfo = contactInfo;
    }

    public MultipartFile getPhotoFile() {
        return this.photoFile;
    }

    public void setPhotoFile(MultipartFile photoFile) {
        this.photoFile = photoFile;
    }

    public MultipartFile getSignatureFile() {
        return this.signatureFile;
    }

    public void setSignatureFile(MultipartFile signatureFile) {
        this.signatureFile = signatureFile;
    }

    public String getEncodedPhoto() {
        return this.encodedPhoto;
    }

    public void setEncodedPhoto(String encodedPhoto) {
        this.encodedPhoto = encodedPhoto;
    }

    public String getEncodedSignature() {
        return this.encodedSignature;
    }

    public void setEncodedSignature(String encodedSignature) {
        this.encodedSignature = encodedSignature;
    }

    public FileStoreMapper getPhotoFileStore() {
        return this.photoFileStore;
    }

    public void setPhotoFileStore(FileStoreMapper photoFileStore) {
        this.photoFileStore = photoFileStore;
    }

    public FileStoreMapper getSignatureFileStore() {
        return this.signatureFileStore;
    }

    public void setSignatureFileStore(FileStoreMapper signatureFileStore) {
        this.signatureFileStore = signatureFileStore;
    }

    public MRApplicantType getApplicantType() {
        return this.applicantType;
    }

    public void setApplicantType(MRApplicantType applicantType) {
        this.applicantType = applicantType;
    }

    public String getWitnessRelation() {
        return this.witnessRelation;
    }

    public void setWitnessRelation(String witnessRelation) {
        this.witnessRelation = witnessRelation;
    }

    public String getRelativeName() {
        return this.relativeName;
    }

    public void setRelativeName(String relativeName) {
        this.relativeName = relativeName;
    }
}

