/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.application.reports.repository;

import org.egov.mrs.domain.entity.MarriageRegistration;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface MarriageRegistrationReportsRepository
extends JpaRepository<MarriageRegistration, Long> {
    @Query(value="select ap.ageInYearsAsOnMarriage , count(*) from MarriageRegistration rg, MrApplicant ap where rg.husband=ap.id and rg.status.code='APPROVED' and YEAR(rg.applicationDate)=:year group by ap.ageInYearsAsOnMarriage order by ap.ageInYearsAsOnMarriage")
    public String[] getHusbandCountAgeWise(@Param(value="year") int var1);

    @Query(value="select ap.ageInYearsAsOnMarriage, count(*) from MarriageRegistration rg, MrApplicant ap where rg.wife=ap.id and rg.status.code='APPROVED' and YEAR(rg.applicationDate)=:year group by ap.ageInYearsAsOnMarriage order by ap.ageInYearsAsOnMarriage")
    public String[] getWifeCountAgeWise(@Param(value="year") int var1);

    @Query(value="select MONTH(marriageRegn.applicationDate), count(*) from MarriageRegistration as marriageRegn, MarriageAct as act, EgwStatus as status where act.id = marriageRegn.marriageAct and act.id=:act and YEAR(marriageRegn.applicationDate)=:year and marriageRegn.status = status.id and status.code in('APPROVED') group by MONTH(marriageRegn.applicationDate)")
    public String[] searchMarriageRegistrationsByYearAndAct(@Param(value="year") int var1, @Param(value="act") Long var2);

    @Query(value="select act.name, count(*) from MarriageRegistration as marriageRegn, MarriageAct as act, EgwStatus as status where act.id = marriageRegn.marriageAct and marriageRegn.status = status.id and status.code in('APPROVED') and YEAR(marriageRegn.applicationDate)=:year group by act.name")
    public String[] searchMarriageRegistrationsByYear(@Param(value="year") int var1);
}

