/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.application;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.ValidationException;
import org.apache.commons.io.FileUtils;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.repository.FileStoreMapperRepository;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.web.utils.WebUtils;
import org.egov.mrs.application.service.MarriageCertificateService;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.ReIssue;
import org.egov.mrs.domain.enums.MarriageCertificateType;
import org.egov.mrs.domain.service.MarriageRegistrationService;
import org.egov.mrs.domain.service.ReIssueService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;

@Service
public class MarriageUtils {
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private FileStoreMapperRepository fileStoreMapperRepository;
    @Autowired
    private MarriageCertificateService marriageCertificateService;
    @Autowired
    private MarriageRegistrationService marriageRegistrationService;
    @Autowired
    private ReIssueService reIssueService;

    public boolean isLoggedInUserApprover() {
        List approvers = this.securityUtils.getCurrentUser().getRoles().stream().filter(role -> role.getName().equalsIgnoreCase("ULB Operator")).collect(Collectors.toList());
        return !approvers.isEmpty();
    }

    public EgwStatus getStatusByCodeAndModuleType(String code, String moduleName) {
        return this.egwStatusHibernateDAO.getStatusByModuleAndCode(moduleName, code);
    }

    public String getApproverName(Long approvalPosition) {
        Assignment assignment = null;
        List<Object> asignList = null;
        if (approvalPosition != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(approvalPosition, new Date());
        }
        if (assignment != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignment);
        } else if (assignment == null) {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        return !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getEmployee().getName() : "";
    }

    public Boolean isDigitalSignEnabled() {
        AppConfigValues appConfigValue = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Marriage Registration", "DIGITALSIGN_IN_WORKFLOW").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    @ResponseBody
    public ResponseEntity<byte[]> viewReport(@PathVariable Long id, String objType, HttpSession session, HttpServletRequest request) throws IOException {
        ReportOutput reportOutput = null;
        HttpHeaders headers = new HttpHeaders();
        String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
        String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
        String cityLogo = url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo"));
        if (objType != null && objType.equalsIgnoreCase(MarriageCertificateType.REISSUE.toString())) {
            ReIssue reIssueObj = this.reIssueService.get(id);
            reportOutput = this.marriageCertificateService.generateCertificate(reIssueObj, objType, cityName, cityLogo, "");
        } else if (objType != null && objType.equalsIgnoreCase(MarriageCertificateType.REGISTRATION.toString())) {
            MarriageRegistration marriageRegistrationObj = this.marriageRegistrationService.get(id);
            reportOutput = this.marriageCertificateService.generate(marriageRegistrationObj, cityName, cityLogo, "");
        }
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            headers.add("content-disposition", "inline;filename=WorkOrderNotice.pdf");
            return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
        }
        return this.redirect();
    }

    public ResponseEntity<byte[]> redirect() {
        String errorMessage = "Error Generating Certificate Preview.";
        errorMessage = "<html><body><p style='color:red;border:1px solid gray;padding:15px;'>" + errorMessage + "</p></body></html>";
        byte[] byteData = errorMessage.getBytes();
        return new ResponseEntity((Object)byteData, HttpStatus.CREATED);
    }

    public void downloadSignedCertificate(String signedFileStoreId, HttpServletResponse response) {
        File file = this.fileStoreService.fetch(signedFileStoreId, "MRS");
        try {
            FileStoreMapper fileStoreMapper = this.fileStoreMapperRepository.findByFileStoreId(signedFileStoreId);
            ArrayList<InputStream> pdfs = new ArrayList<InputStream>();
            byte[] bFile = FileUtils.readFileToByteArray((File)file);
            pdfs.add(new ByteArrayInputStream(bFile));
            this.getServletResponse(response, pdfs, fileStoreMapper.getFileName());
        }
        catch (FileNotFoundException fileNotFoundExcep) {
            throw new ApplicationRuntimeException("Exception while loading file : " + fileNotFoundExcep);
        }
        catch (IOException ioExcep) {
            throw new ApplicationRuntimeException("Exception while generating work order : " + ioExcep);
        }
    }

    private HttpServletResponse getServletResponse(HttpServletResponse response, List<InputStream> pdfs, String filename) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] data = this.concatPDFs(pdfs, output);
            response.setHeader("Content-disposition", "attachment;filename=" + filename + ".pdf");
            response.setContentType("application/pdf");
            response.setContentLength(data.length);
            response.getOutputStream().write(data);
            return response;
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    private byte[] concatPDFs(List<InputStream> streamOfPDFFiles, ByteArrayOutputStream outputStream) {
        Document document = null;
        try {
            List<InputStream> pdfs = streamOfPDFFiles;
            ArrayList<PdfReader> readers = new ArrayList<PdfReader>();
            for (InputStream pdf : pdfs) {
                PdfReader pdfReader = new PdfReader(pdf);
                readers.add(pdfReader);
                if (null != document) continue;
                document = new Document(pdfReader.getPageSize(1));
            }
            PdfWriter writer = PdfWriter.getInstance(document, (OutputStream)outputStream);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            int pageOfCurrentReaderPDF = 0;
            for (PdfReader pdfReader : readers) {
                while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
                    document.newPage();
                    PdfImportedPage page = writer.getImportedPage(pdfReader, ++pageOfCurrentReaderPDF);
                    cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                }
                pageOfCurrentReaderPDF = 0;
            }
            outputStream.flush();
            document.close();
            outputStream.close();
        }
        catch (Exception e) {
            throw new ValidationException(e.getMessage());
        }
        finally {
            if (document.isOpen()) {
                document.close();
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ioe) {
                throw new ValidationException(ioe.getMessage());
            }
        }
        return outputStream.toByteArray();
    }
}

