/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.masters.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.mrs.masters.entity.MarriageAct;
import org.egov.mrs.masters.repository.MarriageActRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class MarriageActService {
    @Autowired
    private MarriageActRepository marriageActRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public void create(MarriageAct act) {
        this.marriageActRepository.save((Object)act);
    }

    @Transactional
    public MarriageAct update(MarriageAct act) {
        return (MarriageAct)((Object)this.marriageActRepository.save((Object)act));
    }

    public MarriageAct getAct(Long id) {
        return this.marriageActRepository.findById(id);
    }

    public List<MarriageAct> getActs() {
        return this.marriageActRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public MarriageAct getProxy(Long id) {
        return (MarriageAct)((Object)this.marriageActRepository.getOne(id));
    }

    public List<MarriageAct> searchActs(MarriageAct act) {
        Criteria criteria = this.getCurrentSession().createCriteria(MarriageAct.class);
        if (null != act.getName()) {
            criteria.add(Restrictions.ilike((String)"name", (String)act.getName(), (MatchMode)MatchMode.ANYWHERE));
        }
        return criteria.list();
    }
}

