/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.domain.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import org.apache.commons.lang.WordUtils;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.mrs.domain.entity.MarriageRegistration;

public class RegistrationCertificate {
    private static Path tempFilePath = Paths.get(System.getProperty("user.home") + File.separator + "testtmpr", new String[0]);
    public static final String STYLE_TAG_BEGIN = "<style forecolor=\"#000000\" isBold=\"true\" pdfFontName=\"SansSerif\" pdfEncoding=\"Cp1252\">";
    public static final String STYLE_TAG_END = "</style>";
    private final DateFormat dateFormatter = new SimpleDateFormat("dd-MM-yyyy");
    private MarriageRegistration registration;
    private User user;
    private byte[] husbandPhoto;
    private byte[] wifePhoto;
    private byte[] marriagePhoto;

    public RegistrationCertificate(MarriageRegistration registration, User user, byte[] husbandPhoto, byte[] wifePhoto, byte[] marriagePhoto) {
        this.registration = registration;
        this.user = user;
        this.husbandPhoto = husbandPhoto;
        this.wifePhoto = wifePhoto;
        this.marriagePhoto = marriagePhoto;
    }

    public MarriageRegistration getRegistration() {
        return this.registration;
    }

    public void setRegistration(MarriageRegistration registration) {
        this.registration = registration;
    }

    public String getZoneName() {
        return this.registration.getZone().getName();
    }

    public String getHusbandName() {
        return this.registration.getHusband().getFullName();
    }

    public String getHusbandAddress() {
        return this.registration.getHusband().getContactInfo().getResidenceAddress();
    }

    public String getWifeName() {
        return this.registration.getWife().getFullName();
    }

    public String getWifeAddress() {
        return this.registration.getWife().getContactInfo().getResidenceAddress();
    }

    public String getDateOfMarriage() {
        return this.dateFormatter.format(this.registration.getDateOfMarriage());
    }

    public String getPlaceOfMarriage() {
        return this.registration.getPlaceOfMarriage();
    }

    public String getDateOfRegistration() {
        return this.dateFormatter.format(this.registration.getCreatedDate());
    }

    public InputStream getWifePhoto() {
        if (this.wifePhoto != null) {
            return new ByteArrayInputStream(this.wifePhoto);
        }
        return null;
    }

    public InputStream getHusbandPhoto() {
        if (this.husbandPhoto != null) {
            return new ByteArrayInputStream(this.husbandPhoto);
        }
        return null;
    }

    public InputStream getMarriagePhoto() {
        if (this.marriagePhoto != null) {
            return new ByteArrayInputStream(this.marriagePhoto);
        }
        return null;
    }

    public String getRoleName() {
        return ((Role)new ArrayList(this.user.getRoles()).get(0)).getName();
    }

    public static InputStream decodePhoto(String encodedString) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ((OutputStream)os).write(255);
        ((OutputStream)os).write(216);
        byte[] orginalFileData = Base64.getDecoder().decode(encodedString);
        byte[] fileData = new byte[orginalFileData.length + 2];
        fileData[0] = -1;
        fileData[1] = -40;
        int j = 2;
        for (int i = 0; i < orginalFileData.length - 1; ++i) {
            fileData[j++] = orginalFileData[i];
        }
        return new ByteArrayInputStream(fileData);
    }

    public String getUserName() {
        String salutation = this.user.getSalutation() == null ? "" : this.user.getSalutation().concat(" ");
        return salutation.concat(WordUtils.capitalizeFully((String)this.user.getName()));
    }

    public String getRejectionDate() {
        return this.dateFormatter.format(this.registration.getState().getCreatedDate());
    }

    public String getRejectionReason() {
        return this.registration.getRejectionReason();
    }

    public String getRegistrationNumber() {
        return this.registration.getRegistrationNo();
    }

    public String getApplicationNumber() {
        return this.registration.getApplicationNo();
    }
}

