/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.domain.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.commons.EgwStatus;
import org.egov.demand.model.EgDemand;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.mrs.domain.entity.MarriageCertificate;
import org.egov.mrs.domain.entity.MarriageDocument;
import org.egov.mrs.domain.entity.MarriagePriest;
import org.egov.mrs.domain.entity.MarriageWitness;
import org.egov.mrs.domain.entity.MrApplicant;
import org.egov.mrs.domain.entity.RegistrationDocument;
import org.egov.mrs.masters.entity.MarriageAct;
import org.egov.mrs.masters.entity.MarriageFee;
import org.egov.mrs.masters.entity.MarriageRegistrationUnit;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;
import org.springframework.web.multipart.MultipartFile;

@Entity
@Unique(id="id", tableName="egmrs_registration", columnName={"serialno"}, fields={"serialNo"}, enableDfltMsg=true, message="Serial No. already exist.")
@Table(name="egmrs_registration")
@SequenceGenerator(name="SEQ_EGMRS_REGISTRATION", sequenceName="SEQ_EGMRS_REGISTRATION", allocationSize=1)
public class MarriageRegistration
extends StateAware {
    private static final long serialVersionUID = 6743094118312883758L;
    public static final String SEQ_REGISTRATION = "SEQ_EGMRS_REGISTRATION";
    @Id
    @GeneratedValue(generator="SEQ_EGMRS_REGISTRATION", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    private String applicationNo;
    @NotNull
    private Date applicationDate;
    private String registrationNo;
    @NotNull
    private Date dateOfMarriage;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="marriageact")
    private MarriageAct marriageAct;
    @SafeHtml
    @Length(max=100)
    @NotNull
    private String placeOfMarriage;
    @SafeHtml
    @NotNull
    private String venue;
    @NotNull
    @Length(max=100)
    private String street;
    @NotNull
    @ManyToOne
    @JoinColumn(name="locality")
    private Boundary locality;
    @NotNull
    @Length(max=30)
    private String city;
    @NotNull
    @Valid
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="husband")
    private MrApplicant husband = new MrApplicant();
    @NotNull
    @Valid
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="wife")
    private MrApplicant wife = new MrApplicant();
    @NotNull
    @Valid
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="registration")
    @Size(max=4)
    @OrderBy(value="id")
    private List<MarriageWitness> witnesses = new LinkedList<MarriageWitness>();
    @Valid
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="priest")
    private MarriagePriest priest;
    private boolean coupleFromSamePlace;
    private boolean memorandumOfMarriage;
    private boolean courtFeeStamp;
    private boolean affidavit;
    private boolean marriageCard;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="feeCriteria")
    private MarriageFee feeCriteria;
    @NotNull
    private Double feePaid;
    @NotNull
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="zone")
    private Boundary zone;
    @NotNull
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="registrationUnit")
    private MarriageRegistrationUnit marriageRegistrationUnit;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="demand")
    private EgDemand demand;
    @ManyToOne
    @JoinColumn(name="status", nullable=false)
    private EgwStatus status;
    @Length(max=256)
    private String rejectionReason;
    @Length(max=256)
    private String remarks;
    @Transient
    private Long approvalDepartment;
    @Transient
    private String approvalComent;
    @Transient
    private Date fromDate;
    @Transient
    private Date toDate;
    @Transient
    private String monthYear;
    @Transient
    private int year;
    private boolean isLegacy;
    private boolean isActive;
    @NotNull
    @Valid
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="registration")
    private Set<RegistrationDocument> registrationDocuments = new HashSet<RegistrationDocument>();
    @OneToMany(mappedBy="registration", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<MarriageCertificate> marriageCertificate = new ArrayList<MarriageCertificate>();
    @Transient
    private List<MarriageDocument> documents;
    @Transient
    private byte[] marriagePhoto;
    private transient MultipartFile marriagePhotoFile;
    @Transient
    private String encodedMarriagePhoto;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="marriagePhotoFileStore")
    private FileStoreMapper marriagePhotoFileStore;
    @NotNull
    @Column(name="serialno", unique=true)
    private String serialNo;
    @NotNull
    private String pageNo;
    @SafeHtml
    @Length(max=100)
    private String registrarName;
    @SafeHtml
    @Length(max=15)
    private String source;

    public String getStateDetails() {
        return "Marriage registration application no : " + this.applicationNo;
    }

    public boolean isFeeCollected() {
        if (this.demand != null) {
            return this.demand.getBaseDemand().compareTo(this.demand.getAmtCollected()) <= 0;
        }
        return false;
    }

    public void addRegistrationDocument(RegistrationDocument registrationDocument) {
        registrationDocument.setRegistration(this);
        this.getRegistrationDocuments().add(registrationDocument);
    }

    public void addWitness(MarriageWitness witness) {
        witness.setRegistration(this);
        this.getWitnesses().add(witness);
    }

    public String getRegistrarName() {
        return this.registrarName;
    }

    public void setRegistrarName(String registrarName) {
        this.registrarName = registrarName;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getApplicationNo() {
        return this.applicationNo;
    }

    public void setApplicationNo(String applicationNo) {
        this.applicationNo = applicationNo;
    }

    public String getRegistrationNo() {
        return this.registrationNo;
    }

    public void setRegistrationNo(String registrationNo) {
        this.registrationNo = registrationNo;
    }

    public Date getDateOfMarriage() {
        return this.dateOfMarriage;
    }

    public void setDateOfMarriage(Date dateOfMarriage) {
        this.dateOfMarriage = dateOfMarriage;
    }

    public MarriageAct getMarriageAct() {
        return this.marriageAct;
    }

    public void setMarriageAct(MarriageAct marriageAct) {
        this.marriageAct = marriageAct;
    }

    public MrApplicant getHusband() {
        return this.husband;
    }

    public void setHusband(MrApplicant husband) {
        this.husband = husband;
    }

    public MrApplicant getWife() {
        return this.wife;
    }

    public void setWife(MrApplicant wife) {
        this.wife = wife;
    }

    public MarriagePriest getPriest() {
        return this.priest;
    }

    public void setPriest(MarriagePriest priest) {
        this.priest = priest;
    }

    public boolean hasMemorandumOfMarriage() {
        return this.memorandumOfMarriage;
    }

    public boolean getMemorandumOfMarriage() {
        return this.memorandumOfMarriage;
    }

    public void setMemorandumOfMarriage(boolean memorandumOfMarriage) {
        this.memorandumOfMarriage = memorandumOfMarriage;
    }

    public boolean getCourtFeeStamp() {
        return this.courtFeeStamp;
    }

    public void setCourtFeeStamp(boolean courtFeeStamp) {
        this.courtFeeStamp = courtFeeStamp;
    }

    public boolean hasAffidavit() {
        return this.affidavit;
    }

    public boolean getAffidavit() {
        return this.affidavit;
    }

    public void setAffidavit(boolean affidavit) {
        this.affidavit = affidavit;
    }

    public boolean hasMarriageCard() {
        return this.marriageCard;
    }

    public boolean getMarriageCard() {
        return this.marriageCard;
    }

    public void setMarriageCard(boolean marriageCard) {
        this.marriageCard = marriageCard;
    }

    public boolean isCoupleFromSamePlace() {
        return this.coupleFromSamePlace;
    }

    public void setCoupleFromSamePlace(boolean coupleFromSamePlace) {
        this.coupleFromSamePlace = coupleFromSamePlace;
    }

    public MarriageFee getFeeCriteria() {
        return this.feeCriteria;
    }

    public void setFeeCriteria(MarriageFee feeCriteria) {
        this.feeCriteria = feeCriteria;
    }

    public Double getFeePaid() {
        return this.feePaid;
    }

    public void setFeePaid(Double feePaid) {
        this.feePaid = feePaid;
    }

    public List<MarriageWitness> getWitnesses() {
        return this.witnesses;
    }

    public void setWitnesses(List<MarriageWitness> witnesses) {
        this.witnesses = witnesses;
    }

    public Boundary getZone() {
        return this.zone;
    }

    public void setZone(Boundary zone) {
        this.zone = zone;
    }

    public EgDemand getDemand() {
        return this.demand;
    }

    public void setDemand(EgDemand demand) {
        this.demand = demand;
    }

    public String getRejectionReason() {
        return this.rejectionReason;
    }

    public void setRejectionReason(String rejectionReason) {
        this.rejectionReason = rejectionReason;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Long getApprovalDepartment() {
        return this.approvalDepartment;
    }

    public void setApprovalDepartment(Long approvalDepartment) {
        this.approvalDepartment = approvalDepartment;
    }

    public String getApprovalComent() {
        return this.approvalComent;
    }

    public void setApprovalComent(String approvalComent) {
        this.approvalComent = approvalComent;
    }

    public Date getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    public List<MarriageDocument> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<MarriageDocument> documents) {
        this.documents = documents;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public List<MarriageCertificate> getMarriageCertificate() {
        return this.marriageCertificate;
    }

    public void setMarriageCertificate(List<MarriageCertificate> marriageCertificate) {
        this.marriageCertificate = marriageCertificate;
    }

    public void addCertificate(MarriageCertificate certificate) {
        this.getMarriageCertificate().add(certificate);
    }

    public void removeCertificate(MarriageCertificate certificate) {
        this.getMarriageCertificate().remove((Object)certificate);
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public MarriageRegistrationUnit getMarriageRegistrationUnit() {
        return this.marriageRegistrationUnit;
    }

    public void setMarriageRegistrationUnit(MarriageRegistrationUnit marriageRegistrationUnit) {
        this.marriageRegistrationUnit = marriageRegistrationUnit;
    }

    public boolean isLegacy() {
        return this.isLegacy;
    }

    public void setLegacy(boolean isLegacy) {
        this.isLegacy = isLegacy;
    }

    public String getMonthYear() {
        return this.monthYear;
    }

    public void setMonthYear(String monthYear) {
        this.monthYear = monthYear;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public String getPlaceOfMarriage() {
        return this.placeOfMarriage;
    }

    public void setPlaceOfMarriage(String placeOfMarriage) {
        this.placeOfMarriage = placeOfMarriage;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getVenue() {
        return this.venue;
    }

    public void setVenue(String venue) {
        this.venue = venue;
    }

    public Boundary getLocality() {
        return this.locality;
    }

    public void setLocality(Boundary locality) {
        this.locality = locality;
    }

    public byte[] getMarriagePhoto() {
        return this.marriagePhoto;
    }

    public void setMarriagePhoto(byte[] marriagePhoto) {
        this.marriagePhoto = marriagePhoto;
    }

    public MultipartFile getMarriagePhotoFile() {
        return this.marriagePhotoFile;
    }

    public void setMarriagePhotoFile(MultipartFile marriagePhotoFile) {
        this.marriagePhotoFile = marriagePhotoFile;
    }

    public String getEncodedMarriagePhoto() {
        return this.encodedMarriagePhoto;
    }

    public void setEncodedMarriagePhoto(String encodedMarriagePhoto) {
        this.encodedMarriagePhoto = encodedMarriagePhoto;
    }

    public FileStoreMapper getMarriagePhotoFileStore() {
        return this.marriagePhotoFileStore;
    }

    public void setMarriagePhotoFileStore(FileStoreMapper marriagePhotoFileStore) {
        this.marriagePhotoFileStore = marriagePhotoFileStore;
    }

    public String getSerialNo() {
        return this.serialNo;
    }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    public String getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(String pageNo) {
        this.pageNo = pageNo;
    }

    public Set<RegistrationDocument> getRegistrationDocuments() {
        return this.registrationDocuments;
    }

    public void setRegistrationDocuments(Set<RegistrationDocument> registrationDocuments) {
        this.registrationDocuments = registrationDocuments;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public static enum RegistrationStatus {
        CREATED,
        APPROVED,
        REJECTED,
        REGISTERED,
        CANCELLED,
        DIGITALSIGNED;

    }
}

