/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.application.service;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.web.utils.WebUtils;
import org.egov.mrs.application.reports.service.MarriageRegistrationReportsService;
import org.egov.mrs.autonumber.MarriageCertificateNumberGenerator;
import org.egov.mrs.domain.entity.MarriageCertificate;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.ReIssue;
import org.egov.mrs.domain.entity.RegistrationCertificate;
import org.egov.mrs.domain.enums.MarriageCertificateType;
import org.egov.mrs.domain.repository.MarriageCertificateRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class MarriageCertificateService {
    private static final String RE_ISSUE_DOT_REGISTRATION = "reIssue.registration";
    private static final String REGISTRATION = "registration";
    private static final String CERTIFICATE_DOT_REGISTRATION = "certificate.registration";
    private static final String REGISTRATION_DOT_REGISTRATION_NO = "registration.registrationNo";
    private static final String CERTIFICATE = "certificate";
    private static final String CITY_CODE = "cityCode";
    private static final String CERTIFICATE_DATE = "certificateDate";
    private static final String CERTIFICATE_TEMPLATE_REGISTRATION = "registrationcertificate";
    private static final String CERTIFICATE_TEMPLATE_REISSUE = "reissuecertificate";
    private static final String CERTIFICATE_TEMPLATE_REJECTION = "rejectioncertificate";
    private static final String[] MONTHNAME = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ReportService reportService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private MarriageCertificateNumberGenerator marriageCertificateNumberGenerator;
    @Autowired
    private MarriageCertificateRepository marriageCertificateRepository;
    @Autowired
    private MarriageRegistrationReportsService marriageRegistrationReportsService;
    private InputStream generateCertificatePDF;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public ReportOutput generate(MarriageRegistration registration, String cityName, String logopath, String certificateNo) throws IOException {
        Calendar calForApplnDate = Calendar.getInstance();
        Calendar calForMrgDate = Calendar.getInstance();
        calForApplnDate.setTime(registration.getApplicationDate());
        calForMrgDate.setTime(registration.getDateOfMarriage());
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        String template = CERTIFICATE_TEMPLATE_REGISTRATION;
        byte[] husbandPhoto = null;
        byte[] wifePhoto = null;
        byte[] marriagePhoto = null;
        reportParams.put("cityName", cityName);
        reportParams.put(CERTIFICATE_DATE, new Date());
        reportParams.put("logoPath", logopath);
        reportParams.put("registrationcenter", registration.getMarriageRegistrationUnit().getName());
        if (registration.getRegistrarName() != null && !"".equals(registration.getRegistrarName())) {
            reportParams.put("registrarName", registration.getRegistrarName());
        } else {
            reportParams.put("registrarName", registration.getState().getSenderName().split("::")[1]);
        }
        reportParams.put("husbandParentName", registration.getHusband().getParentsName());
        reportParams.put("wifeParentName", registration.getWife().getParentsName());
        reportParams.put("applicationdateday", calForApplnDate.get(5) + this.getDayNumberSuffix(calForApplnDate.get(5)));
        reportParams.put("applicationdatemonth", MONTHNAME[calForApplnDate.get(2)]);
        reportParams.put("applicationdateyear", calForApplnDate.get(1));
        reportParams.put("marriagedateday", calForMrgDate.get(5) + this.getDayNumberSuffix(calForMrgDate.get(5)));
        reportParams.put("marriagedatemonth", MONTHNAME[calForMrgDate.get(2)]);
        reportParams.put("marriagedateyear", calForMrgDate.get(1));
        reportParams.put("serialno", registration.getSerialNo());
        reportParams.put("pageno", registration.getPageNo());
        reportParams.put("certificateno", certificateNo);
        if (registration.getWife() != null && registration.getWife().getPhotoFileStore() != null) {
            wifePhoto = FileUtils.readFileToByteArray((File)this.fileStoreService.fetch(registration.getWife().getPhotoFileStore(), "MRS"));
        }
        if (registration.getHusband() != null && registration.getHusband().getPhotoFileStore() != null) {
            husbandPhoto = FileUtils.readFileToByteArray((File)this.fileStoreService.fetch(registration.getHusband().getPhotoFileStore(), "MRS"));
        }
        if (registration.getMarriagePhotoFileStore() != null) {
            marriagePhoto = FileUtils.readFileToByteArray((File)this.fileStoreService.fetch(registration.getMarriagePhotoFileStore(), "MRS"));
        }
        ReportRequest reportInput = new ReportRequest(CERTIFICATE_TEMPLATE_REGISTRATION, (Object)new RegistrationCertificate(registration, this.securityUtils.getCurrentUser(), husbandPhoto, wifePhoto, marriagePhoto), reportParams);
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        return reportOutput;
    }

    private String getDayNumberSuffix(int day) {
        if (day >= 11 && day <= 13) {
            return "th";
        }
        switch (day % 10) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    public MarriageCertificate generateMarriageCertificate(MarriageRegistration marriageRegistration, HttpServletRequest request) throws IOException {
        String certificateNo;
        String url;
        String cityLogo;
        MarriageCertificate marriageCertificate = null;
        String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
        ReportOutput reportOutput = this.generate(marriageRegistration, cityName, cityLogo = (url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false)).concat("/egi").concat((String)request.getSession().getAttribute("citylogo")), certificateNo = this.marriageCertificateNumberGenerator.generateCertificateNumber(marriageRegistration, request.getSession().getAttribute(CITY_CODE).toString()));
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.generateCertificatePDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
            marriageCertificate = this.saveRegisteredCertificate(marriageRegistration, this.generateCertificatePDF, certificateNo);
        }
        return marriageCertificate;
    }

    public MarriageCertificate saveRegisteredCertificate(MarriageRegistration marriageRegistration, InputStream fileStream, String certificateNo) {
        MarriageCertificate marriageCertificate = new MarriageCertificate();
        if (marriageRegistration != null) {
            String fileName = certificateNo + ".pdf";
            this.buildCertificate(marriageRegistration, null, marriageCertificate, certificateNo, MarriageCertificateType.REGISTRATION);
            FileStoreMapper fileStore = this.fileStoreService.store(fileStream, fileName, "application/pdf", "MRS");
            marriageCertificate.setFileStore(fileStore);
        }
        return marriageCertificate;
    }

    private void buildCertificate(MarriageRegistration marriageRegistration, ReIssue reIssue, MarriageCertificate marriageCertificate, String certificateNumber, MarriageCertificateType certificateType) {
        marriageCertificate.setCertificateDate(new Date());
        marriageCertificate.setCertificateIssued(true);
        marriageCertificate.setCertificateNo(certificateNumber);
        marriageCertificate.setCertificateType(certificateType);
        marriageCertificate.setRegistration(marriageRegistration);
        marriageCertificate.setReIssue(reIssue);
    }

    public MarriageCertificate reIssueCertificate(ReIssue reIssue, HttpServletRequest request, MarriageCertificateType certificateType) throws IOException {
        MarriageCertificate marriageCertificate = null;
        String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
        String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
        String cityLogo = url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo"));
        String certificateNo = this.marriageCertificateNumberGenerator.generateCertificateNumber(reIssue, request.getSession().getAttribute(CITY_CODE).toString());
        ReportOutput reportOutput = this.generateCertificate(reIssue, certificateType.name(), cityName, cityLogo, certificateNo);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.generateCertificatePDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
            marriageCertificate = this.saveReIssuedCertificate(reIssue, this.generateCertificatePDF, request.getSession().getAttribute(CITY_CODE).toString(), certificateType, certificateNo);
        }
        return marriageCertificate;
    }

    public ReportOutput generateCertificate(ReIssue reIssue, String certificateType, String cityName, String logopath, String certificateNo) throws IOException {
        ReportRequest reportInput;
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        String template = certificateType.equalsIgnoreCase(MarriageCertificateType.REISSUE.toString()) ? CERTIFICATE_TEMPLATE_REISSUE : CERTIFICATE_TEMPLATE_REJECTION;
        byte[] husbandPhoto = null;
        byte[] wifePhoto = null;
        byte[] marriagePhoto = null;
        Calendar calForApplnDate = Calendar.getInstance();
        Calendar calForMrgDate = Calendar.getInstance();
        calForApplnDate.setTime(reIssue.getRegistration().getApplicationDate());
        calForMrgDate.setTime(reIssue.getRegistration().getDateOfMarriage());
        reportParams.put("certificateno", certificateNo);
        reportParams.put("cityName", cityName);
        reportParams.put(CERTIFICATE_DATE, new Date());
        reportParams.put("logoPath", logopath);
        reportParams.put("registrationcenter", reIssue.getMarriageRegistrationUnit().getName());
        if (reIssue.getRegistration().getRegistrarName() != null && !"".equals(reIssue.getRegistration().getRegistrarName())) {
            reportParams.put("registrarName", reIssue.getRegistration().getRegistrarName());
        } else {
            reportParams.put("registrarName", reIssue.getState().getSenderName().split("::")[1]);
        }
        reportParams.put("husbandParentName", reIssue.getRegistration().getHusband().getParentsName());
        reportParams.put("wifeParentName", reIssue.getRegistration().getWife().getParentsName());
        reportParams.put("applicationdateday", calForApplnDate.get(5) + this.getDayNumberSuffix(calForApplnDate.get(5)));
        reportParams.put("applicationdatemonth", MONTHNAME[calForApplnDate.get(2)]);
        reportParams.put("applicationdateyear", calForApplnDate.get(1));
        reportParams.put("marriagedateday", calForMrgDate.get(5) + this.getDayNumberSuffix(calForMrgDate.get(5)));
        reportParams.put("marriagedatemonth", MONTHNAME[calForMrgDate.get(2)]);
        reportParams.put("marriagedateyear", calForMrgDate.get(1));
        reportParams.put("serialno", reIssue.getRegistration().getSerialNo());
        reportParams.put("pageno", reIssue.getRegistration().getPageNo());
        if (reIssue.getRegistration().getWife() != null && reIssue.getRegistration().getWife().getPhotoFileStore() != null) {
            wifePhoto = FileUtils.readFileToByteArray((File)this.fileStoreService.fetch(reIssue.getRegistration().getWife().getPhotoFileStore(), "MRS"));
        }
        if (reIssue.getRegistration().getHusband() != null && reIssue.getRegistration().getHusband().getPhotoFileStore() != null) {
            husbandPhoto = FileUtils.readFileToByteArray((File)this.fileStoreService.fetch(reIssue.getRegistration().getHusband().getPhotoFileStore(), "MRS"));
        }
        if (reIssue.getRegistration().getMarriagePhotoFileStore() != null) {
            marriagePhoto = FileUtils.readFileToByteArray((File)this.fileStoreService.fetch(reIssue.getRegistration().getMarriagePhotoFileStore(), "MRS"));
        }
        if (template.equalsIgnoreCase(CERTIFICATE_TEMPLATE_REISSUE)) {
            reportParams.put("applicationNumber", reIssue.getApplicationNo());
            reportParams.put("zoneName", reIssue.getZone().getName());
            reportInput = new ReportRequest(template, (Object)new RegistrationCertificate(reIssue.getRegistration(), this.securityUtils.getCurrentUser(), husbandPhoto, wifePhoto, marriagePhoto), reportParams);
        } else {
            reportParams.put("placeOfMarriage", reIssue.getRegistration().getPlaceOfMarriage());
            reportParams.put("zoneName", reIssue.getRegistration().getZone() != null ? reIssue.getRegistration().getZone().getName() : "");
            reportParams.put("userName", reIssue.getState().getSenderName().split("::")[1]);
            reportParams.put("applicationNumber", reIssue.getApplicationNo());
            reportParams.put("registrationNumber", reIssue.getRegistration().getRegistrationNo());
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            if (reIssue.getState().getCreatedDate() != null) {
                reportParams.put("rejectionDate", sdf.format(reIssue.getState().getCreatedDate()));
            }
            reportInput = new ReportRequest(template, (Object)reIssue, reportParams);
        }
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        return reportOutput;
    }

    public MarriageCertificate saveReIssuedCertificate(ReIssue reIssue, InputStream fileStream, String cityCode, MarriageCertificateType type, String certificateNo) {
        MarriageCertificate marriageCertificate = new MarriageCertificate();
        if (reIssue != null) {
            String fileName = certificateNo + ".pdf";
            this.buildCertificate(null, reIssue, marriageCertificate, certificateNo, type);
            FileStoreMapper fileStore = this.fileStoreService.store(fileStream, fileName, "application/pdf", "MRS");
            marriageCertificate.setFileStore(fileStore);
        }
        return marriageCertificate;
    }

    public List<MarriageCertificate> searchMarriageCertificates(MarriageCertificate certificate) {
        Criteria criteria = this.getCurrentSession().createCriteria(MarriageCertificate.class, CERTIFICATE);
        ArrayList<MarriageCertificate> certificateResultList = new ArrayList<MarriageCertificate>();
        if (certificate.getRegistration().getRegistrationNo() != null) {
            criteria.createAlias(CERTIFICATE_DOT_REGISTRATION, REGISTRATION);
            criteria.add((Criterion)Restrictions.eq((String)REGISTRATION_DOT_REGISTRATION_NO, (Object)certificate.getRegistration().getRegistrationNo().trim()));
        }
        this.buildSearchCriteriaForMrgCertificate(certificate, criteria);
        certificateResultList.addAll(criteria.list());
        if (certificate.getRegistration().getRegistrationNo() != null) {
            Criteria criteriaForReissue = this.getCurrentSession().createCriteria(MarriageCertificate.class, "cert");
            criteriaForReissue.createAlias("cert.reIssue", "reIssue").createAlias(RE_ISSUE_DOT_REGISTRATION, "reg");
            criteriaForReissue.add((Criterion)Restrictions.eq((String)"reg.registrationNo", (Object)certificate.getRegistration().getRegistrationNo().trim()));
            this.buildSearchCriteriaForMrgCertificate(certificate, criteriaForReissue);
            certificateResultList.addAll(criteriaForReissue.list());
        }
        return certificateResultList;
    }

    private void buildSearchCriteriaForMrgCertificate(MarriageCertificate certificate, Criteria criteria) {
        if (certificate.getCertificateNo() != null) {
            criteria.add(Restrictions.ilike((String)"certificateNo", (String)certificate.getCertificateNo().trim(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (certificate.getCertificateType() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"certificateType", (Object)((Object)certificate.getCertificateType())));
        }
        if (certificate.getFromDate() != null) {
            criteria.add((Criterion)Restrictions.ge((String)CERTIFICATE_DATE, (Object)this.marriageRegistrationReportsService.resetFromDateTimeStamp(certificate.getFromDate())));
        }
        if (certificate.getToDate() != null) {
            criteria.add((Criterion)Restrictions.le((String)CERTIFICATE_DATE, (Object)this.marriageRegistrationReportsService.resetToDateTimeStamp(certificate.getToDate())));
        }
        if (certificate.getFrequency() != null && "LATEST".equalsIgnoreCase(certificate.getFrequency())) {
            criteria.addOrder(Order.desc((String)"createdDate"));
        }
    }

    public MarriageCertificate findById(long id) {
        return (MarriageCertificate)((Object)this.marriageCertificateRepository.findOne(Long.valueOf(id)));
    }

    public List<MarriageCertificate> getGeneratedRegCertificate(MarriageRegistration registration) {
        Criteria criteriaReg = this.getCurrentSession().createCriteria(MarriageCertificate.class, CERTIFICATE);
        if (registration != null && registration.getRegistrationNo() != null) {
            criteriaReg.createAlias(CERTIFICATE_DOT_REGISTRATION, REGISTRATION);
            criteriaReg.add((Criterion)Restrictions.eq((String)REGISTRATION_DOT_REGISTRATION_NO, (Object)registration.getRegistrationNo().trim()));
        }
        return criteriaReg.list();
    }

    public List<MarriageCertificate> getGeneratedReIssueCertificate(ReIssue reIssue) {
        Criteria criteriaReissue = this.getCurrentSession().createCriteria(MarriageCertificate.class, CERTIFICATE);
        if (reIssue != null && reIssue.getRegistration() != null && reIssue.getRegistration().getRegistrationNo() != null) {
            criteriaReissue.createAlias("certificate.reIssue", "reIssue").createAlias(RE_ISSUE_DOT_REGISTRATION, "reg");
            criteriaReissue.add((Criterion)Restrictions.eq((String)"reg.registrationNo", (Object)reIssue.getRegistration().getRegistrationNo().trim()));
        }
        return criteriaReissue.list();
    }
}

