/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.service.es;

import org.apache.log4j.Logger;
import org.egov.commons.entity.Source;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.elasticsearch.entity.ApplicationIndex;
import org.egov.infra.elasticsearch.entity.enums.ApprovalStatus;
import org.egov.infra.elasticsearch.entity.enums.ClosureStatus;
import org.egov.infra.elasticsearch.service.ApplicationIndexService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.mrs.domain.entity.ReIssue;
import org.egov.mrs.domain.enums.MarriageFeeType;
import org.egov.mrs.domain.service.MarriageRegistrationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ReIssueCertificateUpdateIndexesService {
    private static final Logger LOG = Logger.getLogger(ReIssueCertificateUpdateIndexesService.class);
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private ApplicationIndexService applicationIndexService;
    @Autowired
    private MarriageRegistrationService marriageRegistrationService;

    public void createReIssueAppIndex(ReIssue reIssue) {
        User user = this.securityUtils.getCurrentUser();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Application Index creation Started... ");
        }
        AppConfigValues reissueSla = this.marriageRegistrationService.getSlaAppConfigValuesForMarriageReg("Marriage Registration", "SLAFORMARRIAGEREISSUE");
        ApplicationIndex applicationIndex = ApplicationIndex.builder().withModuleName("Marriage Registration").withApplicationNumber(reIssue.getApplicationNo()).withApplicationDate(reIssue.getApplicationDate()).withApplicationType(MarriageFeeType.CERTIFICATEISSUE.name()).withApplicantName(reIssue.getApplicant().getFullName()).withStatus(reIssue.getStatus().getDescription()).withUrl("/mrs/reissue/viewapplication/" + reIssue.getApplicationNo()).withApplicantAddress(reIssue.getApplicant().getContactInfo().getResidenceAddress()).withOwnername(user != null ? user.getUsername() + "::" + user.getName() : "").withChannel(reIssue.getSource() == null ? Source.SYSTEM.toString() : reIssue.getSource()).withMobileNumber(reIssue.getApplicant().getContactInfo().getMobileNo()).withClosed(ClosureStatus.NO).withSla(Integer.valueOf(reissueSla != null && reissueSla.getValue() != null ? Integer.valueOf(reissueSla.getValue()) : 0)).withApproved(ApprovalStatus.INPROGRESS).build();
        this.applicationIndexService.createApplicationIndex(applicationIndex);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Application Index creation completed...");
        }
    }

    public void updateReIssueAppIndex(ReIssue reissue) {
        ApplicationIndex applicationIndex = this.applicationIndexService.findByApplicationNumber(reissue.getApplicationNo());
        if (applicationIndex != null) {
            if (!ReIssue.ReIssueStatus.CREATED.toString().equalsIgnoreCase(reissue.getStatus().getDescription())) {
                applicationIndex.setStatus(reissue.getStatus().getDescription());
                applicationIndex.setApplicantAddress(reissue.getApplicant().getContactInfo().getResidenceAddress());
                applicationIndex.setApplicantName(reissue.getApplicant().getFullName());
                if (ReIssue.ReIssueStatus.APPROVED.toString().equalsIgnoreCase(reissue.getStatus().getCode())) {
                    applicationIndex.setApproved(ApprovalStatus.APPROVED);
                    applicationIndex.setClosed(ClosureStatus.YES);
                } else if (ReIssue.ReIssueStatus.REJECTED.toString().equalsIgnoreCase(reissue.getStatus().getCode()) || ReIssue.ReIssueStatus.CANCELLED.toString().equalsIgnoreCase(reissue.getStatus().getCode())) {
                    applicationIndex.setApproved(ApprovalStatus.REJECTED);
                    applicationIndex.setClosed(ClosureStatus.YES);
                }
            }
            this.applicationIndexService.updateApplicationIndex(applicationIndex);
        } else {
            this.createReIssueAppIndex(reissue);
        }
    }
}

