/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.domain.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;
import org.egov.commons.EgwStatus;
import org.egov.commons.entity.Source;
import org.egov.demand.model.EgDemandDetails;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.mrs.application.MarriageUtils;
import org.egov.mrs.application.reports.service.MarriageRegistrationReportsService;
import org.egov.mrs.application.service.MarriageCertificateService;
import org.egov.mrs.application.service.MarriageRegistrationDemandService;
import org.egov.mrs.application.service.workflow.RegistrationWorkflowService;
import org.egov.mrs.autonumber.MarriageRegistrationApplicationNumberGenerator;
import org.egov.mrs.autonumber.MarriageRegistrationNumberGenerator;
import org.egov.mrs.domain.entity.MarriageCertificate;
import org.egov.mrs.domain.entity.MarriageDocument;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.MarriageRegistrationSearchFilter;
import org.egov.mrs.domain.entity.ReIssue;
import org.egov.mrs.domain.entity.RegistrationDocument;
import org.egov.mrs.domain.entity.SearchModel;
import org.egov.mrs.domain.repository.MarriageRegistrationRepository;
import org.egov.mrs.domain.repository.WitnessRepository;
import org.egov.mrs.domain.service.MarriageApplicantService;
import org.egov.mrs.domain.service.MarriageDocumentService;
import org.egov.mrs.domain.service.MarriageSmsAndEmailService;
import org.egov.mrs.domain.service.RegistrationDocumentService;
import org.egov.mrs.service.es.MarriageRegistrationUpdateIndexesService;
import org.egov.pims.commons.Position;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class MarriageRegistrationService {
    private static final String MRG_REGISTRATION_UNIT = "registrationUnit";
    private static final String MARRIAGE_ACKNOWLEDGEMENT_REPORT_FILE = "mrs_acknowledgement";
    private static final String REISSUE_MARRIAGE_CERTIFICATE = "Reissue Marriage Certificate (Duplicate)";
    private static final String NEW_MARRIAGE_REGISTRATION = "New Marriage Registration";
    private static final String APP_TYPE = "appType";
    private static final String APPLICATION_CENTRE = "ApplicationCentre";
    private static final String DUE_DATE = "dueDate";
    private static final String ADDRESS = "address";
    private static final String CURRENT_DATE = "currentDate";
    private static final String ACKNOWLEDGEMENT_NO = "acknowledgementNo";
    private static final String APPLICANT_NAME = "applicantName";
    private static final String ZONE_NAME = "zoneName";
    private static final String CITYNAME = "cityname";
    private static final String MUNICIPALITY = "municipality";
    private static final String OFFICE_S_COPY = "Office's Copy";
    private static final String PARTY_S_COPY = "Party's Copy";
    private static final String USER = "user";
    private static final Logger LOG = Logger.getLogger(MarriageRegistrationService.class);
    private static final String STATUS_DOT_CODE = "status.code";
    private static final String MARRIAGE_REGISTRATION_DOT_APPLICATION_DATE = "marriageRegistration.applicationDate";
    private static final String MARRIAGE_REGISTRATION = "marriageRegistration";
    private static final String DEPARTMENT = "department";
    private static final String STATUS = "status";
    private static final String ERROR_WHILE_COPYING_MULTIPART_FILE_BYTES = "Error while copying Multipart file bytes";
    @Autowired
    private final MarriageRegistrationRepository registrationRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private MarriageSmsAndEmailService marriageSmsAndEmailService;
    @Autowired
    private MarriageRegistrationDemandService marriageRegistrationDemandService;
    @Autowired
    private MarriageRegistrationApplicationNumberGenerator marriageRegistrationApplicationNumberGenerator;
    @Autowired
    private RegistrationWorkflowService workflowService;
    @Autowired
    private MarriageRegistrationNumberGenerator marriageRegistrationNumberGenerator;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private MarriageDocumentService marriageDocumentService;
    @Autowired
    private MarriageApplicantService marriageApplicantService;
    @Autowired
    private RegistrationDocumentService registrationDocumentService;
    @Autowired
    protected WitnessRepository witnessRepository;
    @Autowired
    private MarriageUtils marriageUtils;
    @Autowired
    private MarriageCertificateService marriageCertificateService;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private MarriageRegistrationUpdateIndexesService marriageRegistrationUpdateIndexesService;
    @Autowired
    private MarriageRegistrationReportsService marriageRegistrationReportsService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource marriageMessageSource;
    @Autowired
    private ReportService reportService;

    @Autowired
    public MarriageRegistrationService(MarriageRegistrationRepository registrationRepository) {
        this.registrationRepository = registrationRepository;
    }

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public void create(MarriageRegistration registration) {
        this.registrationRepository.save((Object)registration);
    }

    @Transactional
    public MarriageRegistration update(MarriageRegistration registration) {
        return (MarriageRegistration)((Object)this.entityManager.merge((Object)registration));
    }

    public MarriageRegistration get(Long id) {
        return this.registrationRepository.findById(id);
    }

    public MarriageRegistration findByRegistrationNo(String registrationNo) {
        return this.registrationRepository.findByRegistrationNo(registrationNo);
    }

    public MarriageRegistration findByApplicationNo(String applicationNo) {
        return this.registrationRepository.findByApplicationNo(applicationNo);
    }

    public MarriageRegistration findById(Long id) {
        return this.registrationRepository.findById(id);
    }

    public void setMarriageRegData(MarriageRegistration registration) {
        registration.setApplicationDate(new Date());
        registration.getWitnesses().forEach(witness -> witness.setRegistration(registration));
        if (registration.getFeePaid() != null && registration.getDemand() == null) {
            registration.setDemand(this.marriageRegistrationDemandService.createDemand(new BigDecimal(registration.getFeePaid())));
        }
        try {
            registration.getHusband().copyPhotoAndSignatureToByteArray();
            registration.getWife().copyPhotoAndSignatureToByteArray();
        }
        catch (IOException e) {
            LOG.error((Object)ERROR_WHILE_COPYING_MULTIPART_FILE_BYTES, (Throwable)e);
        }
        registration.getWitnesses().forEach(witness -> {
            try {
                if (witness.getPhotoFile().getSize() != 0L) {
                    witness.setPhoto(FileCopyUtils.copyToByteArray((InputStream)witness.getPhotoFile().getInputStream()));
                    witness.setPhotoFileStore(this.addToFileStore(witness.getPhotoFile()));
                }
            }
            catch (IOException e) {
                LOG.error((Object)ERROR_WHILE_COPYING_MULTIPART_FILE_BYTES, (Throwable)e);
            }
        });
        registration.setMarriagePhotoFileStore(this.addToFileStore(registration.getMarriagePhotoFile()));
        if (registration.getWife().getPhotoFile().getSize() != 0L) {
            registration.getWife().setPhotoFileStore(this.addToFileStore(registration.getWife().getPhotoFile()));
        }
        if (registration.getHusband().getPhotoFile().getSize() != 0L) {
            registration.getHusband().setPhotoFileStore(this.addToFileStore(registration.getHusband().getPhotoFile()));
        }
        HashMap<Long, MarriageDocument> generalDocumentAndId = new HashMap<Long, MarriageDocument>();
        this.marriageDocumentService.getGeneralDocuments().forEach(document -> generalDocumentAndId.put(document.getId(), (MarriageDocument)((Object)document)));
        this.addDocumentsToFileStore(registration, generalDocumentAndId);
        this.addMarriageDocumentsToFileStore(registration);
    }

    @Transactional
    public String createRegistration(MarriageRegistration registration, WorkflowContainer workflowContainer) {
        if (StringUtils.isBlank((String)registration.getApplicationNo())) {
            registration.setApplicationNo(this.marriageRegistrationApplicationNumberGenerator.getNextApplicationNumberForMarriageRegistration(registration));
        }
        this.setMarriageRegData(registration);
        registration.setStatus(this.marriageUtils.getStatusByCodeAndModuleType(MarriageRegistration.RegistrationStatus.CREATED.toString(), "Marriage Registration"));
        registration.setSource(Source.SYSTEM.toString());
        this.create(registration);
        this.workflowService.transition(registration, workflowContainer, registration.getApprovalComent());
        this.marriageRegistrationUpdateIndexesService.updateIndexes(registration);
        this.marriageSmsAndEmailService.sendSMS(registration, MarriageRegistration.RegistrationStatus.CREATED.toString());
        this.marriageSmsAndEmailService.sendEmail(registration, MarriageRegistration.RegistrationStatus.CREATED.toString());
        return registration.getApplicationNo();
    }

    @Transactional
    public String createDataEntryMrgRegistration(MarriageRegistration registration) {
        this.setMarriageRegData(registration);
        if (registration.getDemand() != null) {
            registration.getDemand().setAmtCollected(registration.getDemand().getBaseDemand());
        }
        registration.setStatus(this.marriageUtils.getStatusByCodeAndModuleType(MarriageRegistration.RegistrationStatus.REGISTERED.toString(), "Marriage Registration"));
        if (registration.getDemand() != null && !registration.getDemand().getEgDemandDetails().isEmpty()) {
            for (EgDemandDetails dd : registration.getDemand().getEgDemandDetails()) {
                if (dd == null) continue;
                dd.setAmtCollected(dd.getAmount());
            }
        }
        registration.setActive(true);
        registration.setLegacy(true);
        registration.setSource(Source.SYSTEM.toString());
        this.create(registration);
        this.marriageRegistrationUpdateIndexesService.updateIndexes(registration);
        return registration.getApplicationNo();
    }

    @Transactional
    public MarriageRegistration forwardRegistration(MarriageRegistration marriageRegistration, WorkflowContainer workflowContainer) {
        this.updateRegistrationdata(marriageRegistration);
        this.updateDocuments(marriageRegistration);
        marriageRegistration.setStatus(this.marriageUtils.getStatusByCodeAndModuleType(MarriageRegistration.RegistrationStatus.CREATED.toString(), "Marriage Registration"));
        this.workflowService.transition(marriageRegistration, workflowContainer, marriageRegistration.getApprovalComent());
        this.marriageRegistrationUpdateIndexesService.updateIndexes(marriageRegistration);
        return this.update(marriageRegistration);
    }

    private void updateRegistrationdata(MarriageRegistration marriageRegistration) {
        if (marriageRegistration.getFeePaid() != null) {
            if (marriageRegistration.getDemand() == null) {
                marriageRegistration.setDemand(this.marriageRegistrationDemandService.createDemand(new BigDecimal(marriageRegistration.getFeePaid())));
            } else {
                this.marriageRegistrationDemandService.updateDemand(marriageRegistration.getDemand(), new BigDecimal(marriageRegistration.getFeePaid()));
            }
        }
        try {
            marriageRegistration.getHusband().isCopyFilesToByteArray();
            marriageRegistration.getWife().copyPhotoAndSignatureToByteArray();
        }
        catch (IOException e) {
            LOG.error((Object)ERROR_WHILE_COPYING_MULTIPART_FILE_BYTES, (Throwable)e);
        }
        marriageRegistration.getWitnesses().forEach(witness -> {
            try {
                witness.setPhoto(FileCopyUtils.copyToByteArray((InputStream)witness.getPhotoFile().getInputStream()));
            }
            catch (IOException e) {
                LOG.error((Object)ERROR_WHILE_COPYING_MULTIPART_FILE_BYTES, (Throwable)e);
            }
            witness.setPhotoFileStore(this.addToFileStore(witness.getPhotoFile()));
        });
        if (marriageRegistration.getMarriagePhotoFile().getSize() != 0L) {
            marriageRegistration.setMarriagePhotoFileStore(this.addToFileStore(marriageRegistration.getMarriagePhotoFile()));
        }
        if (marriageRegistration.getHusband().getPhotoFile().getSize() != 0L) {
            marriageRegistration.getHusband().setPhotoFileStore(this.addToFileStore(marriageRegistration.getHusband().getPhotoFile()));
        }
        if (marriageRegistration.getWife().getPhotoFile().getSize() != 0L) {
            marriageRegistration.getWife().setPhotoFileStore(this.addToFileStore(marriageRegistration.getWife().getPhotoFile()));
        }
    }

    @Transactional
    public MarriageRegistration updateRegistration(MarriageRegistration marriageRegistration) {
        this.updateRegistrationdata(marriageRegistration);
        this.updateDocuments(marriageRegistration);
        return this.update(marriageRegistration);
    }

    private void addDocumentsToFileStore(MarriageRegistration registration, Map<Long, MarriageDocument> documentAndId) {
        List<MarriageDocument> documents = registration.getDocuments();
        documents.stream().filter(document -> !document.getFile().isEmpty() && document.getFile().getSize() > 0L).map(document -> {
            RegistrationDocument registrationDocument = new RegistrationDocument();
            this.setCommonDocumentsFalg(registration, (MarriageDocument)((Object)document));
            registrationDocument.setRegistration(registration);
            registrationDocument.setDocument((MarriageDocument)((Object)((Object)documentAndId.get(document.getId()))));
            registrationDocument.setFileStoreMapper(this.addToFileStore(document.getFile()));
            return registrationDocument;
        }).collect(Collectors.toList()).forEach(doc -> registration.addRegistrationDocument((RegistrationDocument)((Object)doc)));
    }

    private void setCommonDocumentsFalg(MarriageRegistration registration, MarriageDocument document) {
        MarriageDocument marriageDocument = this.marriageDocumentService.get(document.getId());
        if (marriageDocument.getCode().equals("MoM")) {
            registration.setMemorandumOfMarriage(true);
        }
        if (marriageDocument.getCode().equals("CF_STAMP")) {
            registration.setCourtFeeStamp(true);
        }
        if (marriageDocument.getCode().equals("MIC")) {
            registration.setMarriageCard(true);
        }
        if (marriageDocument.getCode().equals("AFFIDAVIT")) {
            registration.setAffidavit(true);
        }
    }

    private void updateDocuments(MarriageRegistration registration) {
        MarriageRegistration marriageRegistration = this.get(registration.getId());
        this.marriageApplicantService.deleteDocuments(marriageRegistration.getHusband(), registration.getHusband());
        this.marriageApplicantService.deleteDocuments(marriageRegistration.getWife(), registration.getWife());
        this.deleteDocuments(marriageRegistration, registration);
        HashMap<Long, MarriageDocument> generalDocumentAndId = new HashMap<Long, MarriageDocument>();
        this.marriageDocumentService.getGeneralDocuments().forEach(document -> generalDocumentAndId.put(document.getId(), (MarriageDocument)((Object)document)));
        this.addDocumentsToFileStore(registration, generalDocumentAndId);
        this.addMarriageDocumentsToFileStore(registration);
    }

    private void addMarriageDocumentsToFileStore(MarriageRegistration registration) {
        HashMap<Long, MarriageDocument> individualDocumentAndId = new HashMap<Long, MarriageDocument>();
        this.marriageDocumentService.getIndividualDocuments().forEach(document -> individualDocumentAndId.put(document.getId(), (MarriageDocument)((Object)document)));
        this.marriageApplicantService.addDocumentsToFileStore(registration.getHusband(), individualDocumentAndId);
        this.marriageApplicantService.addDocumentsToFileStore(registration.getWife(), individualDocumentAndId);
    }

    @Transactional
    public MarriageRegistration approveRegistration(MarriageRegistration marriageRegistration, WorkflowContainer workflowContainer) {
        marriageRegistration.setStatus(this.marriageUtils.getStatusByCodeAndModuleType(MarriageRegistration.RegistrationStatus.APPROVED.toString(), "Marriage Registration"));
        marriageRegistration.setRegistrationNo(this.marriageRegistrationNumberGenerator.generateMarriageRegistrationNumber(marriageRegistration));
        User user = this.securityUtils.getCurrentUser();
        if (user != null) {
            marriageRegistration.setRegistrarName(user.getName());
        }
        this.updateRegistrationdata(marriageRegistration);
        this.updateDocuments(marriageRegistration);
        this.update(marriageRegistration);
        this.workflowService.transition(marriageRegistration, workflowContainer, workflowContainer.getApproverComments());
        this.marriageRegistrationUpdateIndexesService.updateIndexes(marriageRegistration);
        this.marriageSmsAndEmailService.sendSMS(marriageRegistration, MarriageRegistration.RegistrationStatus.APPROVED.toString());
        this.marriageSmsAndEmailService.sendEmail(marriageRegistration, MarriageRegistration.RegistrationStatus.APPROVED.toString());
        return marriageRegistration;
    }

    @Transactional
    public MarriageCertificate generateMarriageCertificate(MarriageRegistration marriageRegistration, WorkflowContainer workflowContainer, HttpServletRequest request) throws IOException {
        MarriageCertificate marriageCertificate = this.marriageCertificateService.generateMarriageCertificate(marriageRegistration, request);
        marriageRegistration.addCertificate(marriageCertificate);
        return marriageCertificate;
    }

    @Transactional
    public MarriageRegistration digiSignCertificate(MarriageRegistration marriageRegistration, WorkflowContainer workflowContainer, HttpServletRequest request) throws IOException {
        marriageRegistration.setStatus(this.marriageUtils.getStatusByCodeAndModuleType(MarriageRegistration.RegistrationStatus.DIGITALSIGNED.toString(), "Marriage Registration"));
        this.workflowService.transition(marriageRegistration, workflowContainer, workflowContainer.getApproverComments());
        this.marriageRegistrationUpdateIndexesService.updateIndexes(marriageRegistration);
        return marriageRegistration;
    }

    @Transactional
    public MarriageRegistration printCertificate(MarriageRegistration marriageRegistration, WorkflowContainer workflowContainer, HttpServletRequest request) throws IOException {
        if (marriageRegistration.getMarriageCertificate().isEmpty()) {
            MarriageCertificate marriageCertificate = this.marriageCertificateService.generateMarriageCertificate(marriageRegistration, request);
            marriageRegistration.addCertificate(marriageCertificate);
        }
        marriageRegistration.setStatus(this.marriageUtils.getStatusByCodeAndModuleType(MarriageRegistration.RegistrationStatus.REGISTERED.toString(), "Marriage Registration"));
        marriageRegistration.setActive(true);
        this.workflowService.transition(marriageRegistration, workflowContainer, workflowContainer.getApproverComments());
        this.marriageRegistrationUpdateIndexesService.updateIndexes(marriageRegistration);
        return marriageRegistration;
    }

    @Transactional
    public MarriageRegistration rejectRegistration(MarriageRegistration marriageRegistration, WorkflowContainer workflowContainer) {
        marriageRegistration.setStatus(workflowContainer.getWorkFlowAction().equalsIgnoreCase("Reject") ? this.marriageUtils.getStatusByCodeAndModuleType(MarriageRegistration.RegistrationStatus.REJECTED.toString(), "Marriage Registration") : this.marriageUtils.getStatusByCodeAndModuleType(MarriageRegistration.RegistrationStatus.CANCELLED.toString(), "Marriage Registration"));
        marriageRegistration.setRejectionReason(workflowContainer.getApproverComments());
        this.workflowService.transition(marriageRegistration, workflowContainer, workflowContainer.getApproverComments());
        this.marriageRegistrationUpdateIndexesService.updateIndexes(marriageRegistration);
        this.marriageSmsAndEmailService.sendSMS(marriageRegistration, MarriageRegistration.RegistrationStatus.REJECTED.toString());
        this.marriageSmsAndEmailService.sendEmail(marriageRegistration, MarriageRegistration.RegistrationStatus.REJECTED.toString());
        return marriageRegistration;
    }

    public List<MarriageRegistration> getRegistrations() {
        return this.registrationRepository.findAll();
    }

    private FileStoreMapper addToFileStore(MultipartFile file) {
        FileStoreMapper fileStoreMapper = null;
        try {
            fileStoreMapper = this.fileStoreService.store(file.getInputStream(), file.getOriginalFilename(), file.getContentType(), "MRS");
        }
        catch (IOException e) {
            throw new ApplicationRuntimeException("Error occurred while getting inputstream", (Throwable)e);
        }
        return fileStoreMapper;
    }

    public void deleteDocuments(MarriageRegistration regModel, MarriageRegistration registration) {
        ArrayList<RegistrationDocument> toDelete = new ArrayList<RegistrationDocument>();
        HashMap documentIdAndRegistrationDoc = new HashMap();
        registration.getRegistrationDocuments().forEach(regDoc -> documentIdAndRegistrationDoc.put(regDoc.getDocument().getId(), regDoc));
        regModel.getDocuments().stream().filter(doc -> doc.getFile().getSize() > 0L).map(doc -> {
            RegistrationDocument regDoc = (RegistrationDocument)((Object)((Object)documentIdAndRegistrationDoc.get(doc.getId())));
            if (null != regDoc) {
                this.fileStoreService.delete(regDoc.getFileStoreMapper().getFileStoreId(), "MRS");
            }
            return regDoc;
        }).collect(Collectors.toList()).forEach(regDoc -> toDelete.add((RegistrationDocument)((Object)regDoc)));
        this.registrationDocumentService.delete(toDelete);
    }

    public List<MarriageRegistration> searchRegistrationBetweenDateAndStatus(SearchModel searchModel) {
        EgwStatus status = searchModel.isRegistrationApproved() ? this.marriageUtils.getStatusByCodeAndModuleType(MarriageRegistration.RegistrationStatus.APPROVED.toString(), "Marriage Registration") : this.marriageUtils.getStatusByCodeAndModuleType(MarriageRegistration.RegistrationStatus.REJECTED.toString(), "Marriage Registration");
        return this.registrationRepository.findByCreatedDateAfterAndCreatedDateBeforeAndStatus(searchModel.getFromDate(), searchModel.getToDate(), status);
    }

    public void prepareDocumentsForView(MarriageRegistration registration) {
        if (registration.getRegistrationDocuments() != null) {
            registration.getRegistrationDocuments().forEach(appDoc -> {
                File file = this.fileStoreService.fetch(appDoc.getFileStoreMapper().getFileStoreId(), "MRS");
                try {
                    appDoc.setBase64EncodedFile(Base64.getEncoder().encodeToString(FileCopyUtils.copyToByteArray((File)file)));
                }
                catch (IOException e) {
                    LOG.error((Object)"Error while preparing the document for view", (Throwable)e);
                }
            });
        }
        if (registration.getMarriagePhotoFileStore() != null) {
            File file = this.fileStoreService.fetch(registration.getMarriagePhotoFileStore().getFileStoreId(), "MRS");
            try {
                registration.setEncodedMarriagePhoto(Base64.getEncoder().encodeToString(FileCopyUtils.copyToByteArray((File)file)));
            }
            catch (IOException e) {
                LOG.error((Object)"Error while preparing the document for view", (Throwable)e);
            }
        }
    }

    public List<MarriageRegistration> searchMarriageRegistrations(MarriageRegistration registration) throws ParseException {
        Criteria criteria = this.getCurrentSession().createCriteria(MarriageRegistration.class, MARRIAGE_REGISTRATION);
        this.buildMarriageRegistrationSearchCriteria(registration, criteria);
        return criteria.list();
    }

    public List<MarriageRegistration> searchMarriageRegistrationsForFeeCollection(MarriageRegistration registration) throws ParseException {
        Criteria criteria = this.getCurrentSession().createCriteria(MarriageRegistration.class, MARRIAGE_REGISTRATION).createAlias("marriageRegistration.status", STATUS);
        this.buildMarriageRegistrationSearchCriteria(registration, criteria);
        criteria.add(Restrictions.in((String)STATUS_DOT_CODE, (Object[])new String[]{MarriageRegistration.RegistrationStatus.CREATED.toString(), MarriageRegistration.RegistrationStatus.APPROVED.toString()}));
        return criteria.list();
    }

    public List<ReIssue> searchApprovedReIssueRecordsForFeeCollection(MarriageRegistrationSearchFilter mrSearchFilter) throws ParseException {
        Criteria criteria = this.getCurrentSession().createCriteria(ReIssue.class, "reIssue").createAlias("reIssue.status", STATUS);
        this.buildReIssueSearchCriteria(mrSearchFilter, criteria);
        criteria.add(Restrictions.in((String)STATUS_DOT_CODE, (Object[])new String[]{ReIssue.ReIssueStatus.CREATED.toString(), ReIssue.ReIssueStatus.APPROVED.toString()}));
        return criteria.list();
    }

    private void buildReIssueSearchCriteria(MarriageRegistrationSearchFilter mrSearchFilter, Criteria criteria) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        criteria.createAlias("reIssue.registration", "registration");
        if (mrSearchFilter.getRegistrationNo() != null) {
            criteria.add(Restrictions.ilike((String)"registration.registrationNo", (String)mrSearchFilter.getRegistrationNo(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (mrSearchFilter.getApplicationNo() != null) {
            criteria.add(Restrictions.ilike((String)"reIssue.applicationNo", (String)mrSearchFilter.getApplicationNo(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (mrSearchFilter.getHusbandName() != null) {
            criteria.createAlias("registration.husband", "husband").add(Restrictions.ilike((String)"husband.name.fullname", (String)mrSearchFilter.getHusbandName(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (mrSearchFilter.getWifeName() != null) {
            criteria.createAlias("registration.wife", "wife").add(Restrictions.ilike((String)"wife.name.fullname", (String)mrSearchFilter.getWifeName(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (mrSearchFilter.getApplicationDate() != null) {
            criteria.add(Restrictions.between((String)"reIssue.applicationDate", (Object)sdf.parse(mrSearchFilter.getApplicationDate()), (Object)DateUtils.addDays((Date)sdf.parse(mrSearchFilter.getApplicationDate()), (int)1)));
        }
        if (mrSearchFilter.getDateOfMarriage() != null) {
            criteria.add(Restrictions.between((String)"registration.dateOfMarriage", (Object)sdf.parse(mrSearchFilter.getDateOfMarriage()), (Object)DateUtils.addDays((Date)sdf.parse(mrSearchFilter.getDateOfMarriage()), (int)0)));
        }
        if (mrSearchFilter.getFromDate() != null) {
            criteria.add((Criterion)Restrictions.ge((String)"reIssue.applicationDate", (Object)this.marriageRegistrationReportsService.resetFromDateTimeStamp(mrSearchFilter.getFromDate())));
        }
        if (mrSearchFilter.getToDate() != null) {
            criteria.add((Criterion)Restrictions.le((String)"reIssue.applicationDate", (Object)this.marriageRegistrationReportsService.resetToDateTimeStamp(mrSearchFilter.getToDate())));
        }
        if (mrSearchFilter.getMarriageRegistrationUnit() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"marriageRegistrationUnit.id", (Object)mrSearchFilter.getMarriageRegistrationUnit()));
        }
    }

    private void buildMarriageRegistrationSearchCriteria(MarriageRegistration registration, Criteria criteria) throws ParseException {
        if (registration.getRegistrationNo() != null) {
            criteria.add(Restrictions.ilike((String)"marriageRegistration.registrationNo", (String)registration.getRegistrationNo(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (registration.getApplicationNo() != null) {
            criteria.add(Restrictions.ilike((String)"marriageRegistration.applicationNo", (String)registration.getApplicationNo(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (registration.getHusband() != null && registration.getHusband().getName() != null && !"null".equals(registration.getHusband().getFullName()) && registration.getHusband().getFullName() != null) {
            criteria.createAlias("marriageRegistration.husband", "husband").add(Restrictions.ilike((String)"husband.name.fullname", (String)registration.getHusband().getFullName(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (registration.getWife() != null && registration.getWife().getName() != null && !"null".equals(registration.getWife().getFullName()) && registration.getWife().getFullName() != null) {
            criteria.createAlias("marriageRegistration.wife", "wife").add(Restrictions.ilike((String)"wife.name.fullname", (String)registration.getWife().getFullName(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (registration.getApplicationDate() != null) {
            criteria.add(Restrictions.between((String)MARRIAGE_REGISTRATION_DOT_APPLICATION_DATE, (Object)registration.getApplicationDate(), (Object)DateUtils.addDays((Date)registration.getApplicationDate(), (int)1)));
        }
        if (registration.getDateOfMarriage() != null) {
            criteria.add(Restrictions.between((String)"marriageRegistration.dateOfMarriage", (Object)registration.getDateOfMarriage(), (Object)DateUtils.addDays((Date)registration.getDateOfMarriage(), (int)0)));
        }
        if (registration.getFromDate() != null) {
            criteria.add((Criterion)Restrictions.ge((String)MARRIAGE_REGISTRATION_DOT_APPLICATION_DATE, (Object)this.marriageRegistrationReportsService.resetFromDateTimeStamp(registration.getFromDate())));
        }
        if (registration.getToDate() != null) {
            criteria.add((Criterion)Restrictions.le((String)MARRIAGE_REGISTRATION_DOT_APPLICATION_DATE, (Object)this.marriageRegistrationReportsService.resetToDateTimeStamp(registration.getToDate())));
        }
        if (null != registration.getMarriageRegistrationUnit() && registration.getMarriageRegistrationUnit().getId() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"marriageRegistrationUnit.id", (Object)registration.getMarriageRegistrationUnit().getId()));
        }
    }

    public List<Map<String, Object>> getHistory(MarriageRegistration registration) {
        ArrayList<Map<String, Object>> historyTable = new ArrayList<Map<String, Object>>();
        State state = registration.getState();
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        if (null != state) {
            User user;
            if (!registration.getStateHistory().isEmpty() && registration.getStateHistory() != null) {
                Collections.reverse(registration.getStateHistory());
            }
            for (StateHistory stateHistory : registration.getStateHistory()) {
                HashMap<String, Object> historyMap = new HashMap<String, Object>(0);
                historyMap.put("date", stateHistory.getDateInfo());
                historyMap.put("comments", stateHistory.getComments() != null ? stateHistory.getComments() : "");
                historyMap.put("updatedBy", stateHistory.getLastModifiedBy().getUsername() + "::" + stateHistory.getLastModifiedBy().getName());
                historyMap.put(STATUS, stateHistory.getValue());
                Position owner = stateHistory.getOwnerPosition();
                user = stateHistory.getOwnerUser();
                if (null != user) {
                    historyMap.put(USER, user.getUsername() + "::" + user.getName());
                    historyMap.put(DEPARTMENT, null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
                } else if (null != owner && null != owner.getDeptDesig()) {
                    user = this.eisCommonService.getUserForPosition(owner.getId(), new Date());
                    historyMap.put(USER, null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                    historyMap.put(DEPARTMENT, null != owner.getDeptDesig().getDepartment() ? owner.getDeptDesig().getDepartment().getName() : "");
                }
                historyTable.add(historyMap);
            }
            map.put("date", state.getDateInfo());
            map.put("comments", state.getComments() != null ? state.getComments() : "");
            map.put("updatedBy", state.getLastModifiedBy().getUsername() + "::" + state.getLastModifiedBy().getName());
            map.put(STATUS, state.getValue());
            Position ownerPosition = state.getOwnerPosition();
            user = state.getOwnerUser();
            if (null != user) {
                map.put(USER, user.getUsername() + "::" + user.getName());
                map.put(DEPARTMENT, null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
            } else if (null != ownerPosition && null != ownerPosition.getDeptDesig()) {
                user = this.eisCommonService.getUserForPosition(ownerPosition.getId(), new Date());
                map.put(USER, null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                map.put(DEPARTMENT, null != ownerPosition.getDeptDesig().getDepartment() ? ownerPosition.getDeptDesig().getDepartment().getName() : "");
            }
            historyTable.add(map);
        }
        return historyTable;
    }

    public List<MarriageRegistration> searchRegistrationByStatus(MarriageRegistration registration, String status) throws ParseException {
        Criteria criteria = this.getCurrentSession().createCriteria(MarriageRegistration.class, MARRIAGE_REGISTRATION).createAlias("marriageRegistration.status", STATUS);
        this.buildMarriageRegistrationSearchCriteria(registration, criteria);
        if (status != null) {
            criteria.add(Restrictions.in((String)STATUS_DOT_CODE, (Object[])new String[]{status}));
        }
        return criteria.list();
    }

    public MarriageRegistration findBySerialNo(String serialNo) {
        return this.registrationRepository.findBySerialNo(serialNo);
    }

    public ReportOutput getReportParamsForAcknowdgementForMrgReg(MarriageRegistration registration, String municipalityName, String cityName) {
        String applicantName = null;
        HashMap<String, String> reportParams = new HashMap<String, String>();
        reportParams.put(MUNICIPALITY, municipalityName);
        reportParams.put(CITYNAME, cityName);
        reportParams.put(ZONE_NAME, registration.getZone().getName());
        reportParams.put(MRG_REGISTRATION_UNIT, registration.getMarriageRegistrationUnit().getName());
        if (registration.getHusband() != null && registration.getWife() != null) {
            applicantName = registration.getHusband().getFullName().concat(" / ").concat(registration.getWife().getFullName());
        }
        reportParams.put(APPLICANT_NAME, applicantName);
        reportParams.put(ACKNOWLEDGEMENT_NO, registration.getApplicationNo());
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        reportParams.put(CURRENT_DATE, formatter.format(new Date()));
        reportParams.put(ADDRESS, registration.getHusband().getContactInfo().getResidenceAddress());
        reportParams.put(DUE_DATE, formatter.format(this.calculateDueDateForMrgReg()));
        reportParams.put(PARTY_S_COPY, PARTY_S_COPY);
        reportParams.put(OFFICE_S_COPY, OFFICE_S_COPY);
        reportParams.put(APPLICATION_CENTRE, this.marriageMessageSource.getMessage("msg.application.centre", (Object[])new String[0], Locale.getDefault()));
        reportParams.put(APP_TYPE, NEW_MARRIAGE_REGISTRATION);
        ReportRequest reportInput = new ReportRequest(MARRIAGE_ACKNOWLEDGEMENT_REPORT_FILE, (Object)registration, reportParams);
        return this.reportService.createReport(reportInput);
    }

    public ReportOutput getReportParamsForAcknowdgementForMrgReissue(ReIssue reIssue, String municipalityName, String cityName) {
        String applicantName = null;
        HashMap<String, String> reportParams = new HashMap<String, String>();
        reportParams.put(MUNICIPALITY, municipalityName);
        reportParams.put(CITYNAME, cityName);
        reportParams.put(MRG_REGISTRATION_UNIT, reIssue.getRegistration().getMarriageRegistrationUnit().getName());
        reportParams.put(ZONE_NAME, reIssue.getZone().getName());
        if (reIssue.getRegistration().getHusband() != null && reIssue.getRegistration().getWife() != null) {
            applicantName = reIssue.getRegistration().getHusband().getFullName().concat(" / ").concat(reIssue.getRegistration().getWife().getFullName());
        }
        reportParams.put(APPLICANT_NAME, applicantName);
        reportParams.put(ACKNOWLEDGEMENT_NO, reIssue.getApplicationNo());
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        reportParams.put(CURRENT_DATE, formatter.format(new Date()));
        reportParams.put(ADDRESS, reIssue.getRegistration().getHusband().getContactInfo().getResidenceAddress());
        reportParams.put(DUE_DATE, formatter.format(this.calculateDueDateForMrgReIssue()));
        reportParams.put(PARTY_S_COPY, PARTY_S_COPY);
        reportParams.put(OFFICE_S_COPY, OFFICE_S_COPY);
        reportParams.put(APPLICATION_CENTRE, this.marriageMessageSource.getMessage("msg.application.centre", (Object[])new String[0], Locale.getDefault()));
        reportParams.put(APP_TYPE, REISSUE_MARRIAGE_CERTIFICATE);
        ReportRequest reportInput = new ReportRequest(MARRIAGE_ACKNOWLEDGEMENT_REPORT_FILE, (Object)reIssue, reportParams);
        return this.reportService.createReport(reportInput);
    }

    public Date calculateDueDateForMrgReg() {
        Date currentDate = new Date();
        AppConfigValues marriageSla = this.getSlaAppConfigValuesForMarriageReg("Marriage Registration", "SLAFORMARRIAGEREGISTRATION");
        Date dueDate = DateUtils.addDays((Date)currentDate, (int)(marriageSla != null && marriageSla.getValue() != null ? Integer.valueOf(marriageSla.getValue()) : 0));
        return dueDate;
    }

    public Date calculateDueDateForMrgReIssue() {
        Date currentDate = new Date();
        AppConfigValues reissuemarriageSla = this.getSlaAppConfigValuesForMarriageReg("Marriage Registration", "SLAFORMARRIAGEREISSUE");
        Date dueDate = DateUtils.addDays((Date)currentDate, (int)(reissuemarriageSla != null && reissuemarriageSla.getValue() != null ? Integer.valueOf(reissuemarriageSla.getValue()) : 0));
        return dueDate;
    }

    public AppConfigValues getSlaAppConfigValuesForMarriageReg(String moduleName, String keyName) {
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, keyName);
        return !appConfigValues.isEmpty() ? (AppConfigValues)appConfigValues.get(0) : null;
    }
}

