/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.autonumber.impl;

import java.io.Serializable;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.mrs.autonumber.MarriageCertificateNumberGenerator;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.ReIssue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MarriageCertificateNumberGeneratorImpl
implements MarriageCertificateNumberGenerator {
    private static final String CERTIFICATE_NUMBER_SEQ_PREFIX = "SEQ_EGMRS_CERTIFICATE_NUMBER";
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;

    @Override
    public String generateCertificateNumber(MarriageRegistration marriageRegistration, String cityCode) {
        String sequenceName = CERTIFICATE_NUMBER_SEQ_PREFIX;
        Serializable nextSequence = this.applicationSequenceNumberGenerator.getNextSequence(CERTIFICATE_NUMBER_SEQ_PREFIX);
        return String.format("%s%06d", cityCode, nextSequence);
    }

    @Override
    public String generateCertificateNumber(ReIssue reIssue, String cityCode) {
        String sequenceName = CERTIFICATE_NUMBER_SEQ_PREFIX;
        Serializable nextSequence = this.applicationSequenceNumberGenerator.getNextSequence(CERTIFICATE_NUMBER_SEQ_PREFIX);
        return String.format("%s%06d", cityCode, nextSequence);
    }
}

