/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.application.service.workflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.egov.commons.entity.Source;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.ReIssue;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.validation.BindingResult;

@Service
public class RegistrationWorkflowService {
    private static final String REGISTRATION_ADDNL_RULE = "MARRIAGE REGISTRATION";
    private static final String STATE_NEW = "NEW";
    private static final String STATE_END = "END";
    private static final String STEP_CANCEL = "Cancel Registration";
    private static final String STEP_CANCEL_REISSUE = "Cancel ReIssue";
    private static final String STEP_REJECT = "Reject";
    private static final String STEP_APPROVE = "Approve";
    private static final String STEP_FORWARD = "Forward";
    private static final String STEP_PRINT_CERTIFICATE = "Print Certificate";
    private static final String APPROVER_REJECTED = "Approver Rejected Application";
    private static final String INITIATOR_INITIAL_STATE = "Revenue Clerk Approval Pending";
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<MarriageRegistration> marriageRegistrationWorkflowService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<ReIssue> reIssueWorkflowService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private DepartmentService departmentService;

    public void transition(MarriageRegistration registration, WorkflowContainer workflowContainer, String approvalComent) {
        User user = this.securityUtils.getCurrentUser();
        String natureOfTask = "Marriage Registration :: New Registration";
        Position nextStateOwner = null;
        String nextState = null;
        String nextAction = null;
        Assignment assignment = this.getWorkFlowInitiator(registration);
        Boolean isCscOperator = this.isCscOperator(user);
        if (isCscOperator.booleanValue() || "Anonymous".equalsIgnoreCase(this.securityUtils.getCurrentUser().getName())) {
            String currentState = "CSC Operator created";
            nextStateOwner = this.positionMasterService.getPositionById(workflowContainer.getApproverPositionId());
            if (nextStateOwner != null) {
                List assignmentList = this.assignmentService.getAssignmentsForPosition(nextStateOwner.getId());
                assignment = !assignmentList.isEmpty() ? (Assignment)assignmentList.get(0) : null;
            }
            WorkFlowMatrix workflowMatrix = this.marriageRegistrationWorkflowService.getWfMatrix(WorkflowType.MarriageRegistration.name(), null, null, REGISTRATION_ADDNL_RULE, currentState, null);
            nextState = workflowMatrix.getNextState();
            nextAction = workflowMatrix.getNextAction();
            registration.setSource(isCscOperator != false ? Source.CSC.toString() : "ONLINE");
        } else if (workflowContainer == null) {
            nextStateOwner = this.assignmentService.getPrimaryAssignmentForUser(registration.getCreatedBy().getId()).getPosition();
            WorkFlowMatrix workflowMatrix = this.marriageRegistrationWorkflowService.getWfMatrix(WorkflowType.MarriageRegistration.name(), null, null, REGISTRATION_ADDNL_RULE, registration.getCurrentState().getValue(), null);
            nextState = workflowMatrix.getNextState();
            nextAction = workflowMatrix.getNextAction();
        } else if (workflowContainer.getWorkFlowAction().equalsIgnoreCase(STEP_FORWARD)) {
            nextStateOwner = this.positionMasterService.getPositionById(workflowContainer.getApproverPositionId());
            WorkFlowMatrix workflowMatrix = registration.getCurrentState() == null ? this.marriageRegistrationWorkflowService.getWfMatrix(WorkflowType.MarriageRegistration.name(), null, null, REGISTRATION_ADDNL_RULE, STATE_NEW, workflowContainer.getPendingActions()) : this.marriageRegistrationWorkflowService.getWfMatrix(WorkflowType.MarriageRegistration.name(), null, null, REGISTRATION_ADDNL_RULE, registration.getCurrentState().getValue(), null);
            nextState = workflowMatrix.getNextState();
            nextAction = workflowMatrix.getNextAction();
        } else if (workflowContainer.getWorkFlowAction().equalsIgnoreCase(STEP_REJECT)) {
            nextStateOwner = assignment != null ? assignment.getPosition() : null;
            nextState = APPROVER_REJECTED;
            nextAction = INITIATOR_INITIAL_STATE;
        } else if (workflowContainer.getWorkFlowAction().equalsIgnoreCase(STEP_CANCEL) || workflowContainer.getWorkFlowAction().equalsIgnoreCase(STEP_PRINT_CERTIFICATE)) {
            nextAction = STATE_END;
        } else if (workflowContainer.getWorkFlowAction().equalsIgnoreCase(STEP_APPROVE)) {
            nextStateOwner = workflowContainer.getPendingActions().equalsIgnoreCase("Commisioner Approval Pending_DigiSign") ? this.assignmentService.getPrimaryAssignmentForUser(user.getId()).getPosition() : (assignment != null ? assignment.getPosition() : null);
            WorkFlowMatrix workflowMatrix = this.marriageRegistrationWorkflowService.getWfMatrix(WorkflowType.MarriageRegistration.name(), null, null, REGISTRATION_ADDNL_RULE, registration.getCurrentState().getValue(), workflowContainer.getPendingActions());
            nextState = workflowMatrix.getNextState();
            nextAction = workflowMatrix.getNextAction();
        } else if (workflowContainer.getWorkFlowAction().equalsIgnoreCase("Sign")) {
            nextStateOwner = assignment != null ? assignment.getPosition() : null;
            WorkFlowMatrix workflowMatrix = this.marriageRegistrationWorkflowService.getWfMatrix(WorkflowType.MarriageRegistration.name(), null, null, REGISTRATION_ADDNL_RULE, registration.getCurrentState().getValue(), null);
            nextState = workflowMatrix.getNextState();
            nextAction = workflowMatrix.getNextAction();
        }
        this.transition(registration, approvalComent, user, "Marriage Registration :: New Registration", nextStateOwner, nextState, nextAction, assignment);
    }

    public void transition(ReIssue reIssue, WorkflowContainer workflowContainer, String approvalComent) {
        User user = this.securityUtils.getCurrentUser();
        String natureOfTask = "Marriage Registration :: Re-Issue";
        Position nextStateOwner = null;
        String nextState = null;
        String nextAction = null;
        Assignment assignment = this.getWorkFlowInitiatorForReissue(reIssue);
        Boolean isCscOperator = this.isCscOperator(user);
        if (isCscOperator.booleanValue() || "Anonymous".equalsIgnoreCase(this.securityUtils.getCurrentUser().getName())) {
            String currentState = "CSC Operator created";
            nextStateOwner = this.positionMasterService.getPositionById(workflowContainer.getApproverPositionId());
            if (nextStateOwner != null) {
                List assignmentList = this.assignmentService.getAssignmentsForPosition(nextStateOwner.getId());
                assignment = !assignmentList.isEmpty() ? (Assignment)assignmentList.get(0) : null;
            }
            WorkFlowMatrix workflowMatrix = this.marriageRegistrationWorkflowService.getWfMatrix(WorkflowType.ReIssue.name(), null, null, REGISTRATION_ADDNL_RULE, currentState, null);
            nextState = workflowMatrix.getNextState();
            nextAction = workflowMatrix.getNextAction();
            reIssue.setSource(isCscOperator != false ? Source.CSC.toString() : "ONLINE");
        } else if (workflowContainer == null) {
            nextStateOwner = assignment != null ? assignment.getPosition() : null;
            WorkFlowMatrix workflowMatrix = this.reIssueWorkflowService.getWfMatrix(WorkflowType.ReIssue.name(), null, null, REGISTRATION_ADDNL_RULE, reIssue.getCurrentState().getValue(), null);
            nextState = workflowMatrix.getNextState();
            nextAction = workflowMatrix.getNextAction();
        } else if (workflowContainer.getWorkFlowAction().equalsIgnoreCase(STEP_FORWARD)) {
            nextStateOwner = this.positionMasterService.getPositionById(workflowContainer.getApproverPositionId());
            WorkFlowMatrix workflowMatrix = reIssue.getCurrentState() == null ? this.reIssueWorkflowService.getWfMatrix(WorkflowType.ReIssue.name(), null, null, REGISTRATION_ADDNL_RULE, STATE_NEW, workflowContainer.getPendingActions()) : this.reIssueWorkflowService.getWfMatrix(WorkflowType.ReIssue.name(), null, null, REGISTRATION_ADDNL_RULE, reIssue.getCurrentState().getValue(), workflowContainer.getPendingActions());
            nextState = workflowMatrix.getNextState();
            nextAction = workflowMatrix.getNextAction();
        } else if (workflowContainer.getWorkFlowAction().equalsIgnoreCase(STEP_REJECT)) {
            nextStateOwner = assignment != null ? assignment.getPosition() : null;
            nextState = APPROVER_REJECTED;
            nextAction = INITIATOR_INITIAL_STATE;
        } else if (workflowContainer.getWorkFlowAction().equalsIgnoreCase(STEP_CANCEL_REISSUE) || workflowContainer.getWorkFlowAction().equalsIgnoreCase(STEP_PRINT_CERTIFICATE)) {
            nextAction = STATE_END;
        } else if (workflowContainer.getWorkFlowAction().equalsIgnoreCase(STEP_APPROVE)) {
            nextStateOwner = workflowContainer.getPendingActions().equalsIgnoreCase("Commisioner Approval Pending_DigiSign") ? this.assignmentService.getPrimaryAssignmentForUser(user.getId()).getPosition() : (assignment != null ? assignment.getPosition() : null);
            WorkFlowMatrix workflowMatrix = this.reIssueWorkflowService.getWfMatrix(WorkflowType.ReIssue.name(), null, null, REGISTRATION_ADDNL_RULE, reIssue.getCurrentState().getValue(), workflowContainer.getPendingActions());
            nextState = workflowMatrix.getNextState();
            nextAction = workflowMatrix.getNextAction();
        } else if (workflowContainer.getWorkFlowAction().equalsIgnoreCase("Sign")) {
            nextStateOwner = assignment != null ? assignment.getPosition() : null;
            WorkFlowMatrix workflowMatrix = this.reIssueWorkflowService.getWfMatrix(WorkflowType.ReIssue.name(), null, null, REGISTRATION_ADDNL_RULE, reIssue.getCurrentState().getValue(), null);
            nextState = workflowMatrix.getNextState();
            nextAction = workflowMatrix.getNextAction();
        }
        this.transition(reIssue, approvalComent, user, "Marriage Registration :: Re-Issue", nextStateOwner, nextState, nextAction, assignment);
    }

    private void transition(StateAware itemInWorkflow, String approvalComent, User user, String natureOfTask, Position nextStateOwner, String nextState, String nextAction, Assignment assignment) {
        if (itemInWorkflow.getState() == null) {
            itemInWorkflow.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(nextState).withDateInfo(new Date()).withOwner(nextStateOwner).withInitiator(assignment != null ? assignment.getPosition() : null).withNextAction(nextAction).withNatureOfTask(natureOfTask);
        } else if (nextAction != null && nextAction.equalsIgnoreCase(STATE_END)) {
            itemInWorkflow.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(new Date());
        } else {
            itemInWorkflow.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(nextState).withDateInfo(new Date()).withOwner(nextStateOwner).withNextAction(nextAction).withNatureOfTask(natureOfTask);
        }
    }

    public String getDesignationForThirdPartyUser() {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Marriage Registration", "MRSROLEFORNONEMPLOYEE");
        return !appConfigValue.isEmpty() ? ((AppConfigValues)appConfigValue.get(0)).getValue() : "";
    }

    public Boolean isEmployee(User user) {
        for (Role role : user.getRoles()) {
            for (AppConfigValues appconfig : this.getThirdPartyUserRoles()) {
                if (role == null || appconfig == null || !role.getName().equals(appconfig.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public List<AppConfigValues> getThirdPartyUserRoles() {
        List<AppConfigValues> appConfigValueList = this.appConfigValuesService.getConfigValuesByModuleAndKey("Marriage Registration", "MRSROLEFORNONEMPLOYEE");
        return !appConfigValueList.isEmpty() ? appConfigValueList : Collections.emptyList();
    }

    public Boolean isCscOperator(User user) {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Marriage Registration", "MRSROLEFORNONEMPLOYEE");
        String rolesForNonEmployee = !appConfigValue.isEmpty() ? ((AppConfigValues)appConfigValue.get(0)).getValue() : null;
        for (Role role : user.getRoles()) {
            if (role == null || rolesForNonEmployee == null || !role.getName().equalsIgnoreCase(rolesForNonEmployee)) continue;
            return true;
        }
        return false;
    }

    public String getDesignationForCscOperatorWorkFlow() {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Marriage Registration", "MRSDESIGNATIONFORCSCOPERATORWORKFLOW");
        return !appConfigValue.isEmpty() ? ((AppConfigValues)appConfigValue.get(0)).getValue() : null;
    }

    public String getDepartmentForCscOperatorWorkFlow() {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Marriage Registration", "MRSDEPARTMENTFORCSCOPERATORWORKFLOW");
        return !appConfigValue.isEmpty() ? ((AppConfigValues)appConfigValue.get(0)).getValue() : null;
    }

    public Assignment getUserPositionByZone(MarriageRegistration marriageRegistration, ReIssue reIssue) {
        String designationStr = this.getDesignationForCscOperatorWorkFlow();
        String departmentStr = this.getDepartmentForCscOperatorWorkFlow();
        String[] department = departmentStr.split(",");
        String[] designation = designationStr.split(",");
        List assignment = new ArrayList();
        Long boundaryId = null;
        if (reIssue == null) {
            boundaryId = marriageRegistration != null && marriageRegistration.getZone() != null ? marriageRegistration.getZone().getId() : null;
        } else if (marriageRegistration == null) {
            boundaryId = reIssue != null && reIssue.getZone() != null ? reIssue.getZone().getId() : null;
        }
        for (String dept : department) {
            Long deptId = null;
            Department deptObject = this.departmentService.getDepartmentByName(dept);
            if (deptObject != null) {
                deptId = this.departmentService.getDepartmentByName(dept).getId();
            }
            if (deptId != null) {
                String desg;
                Designation desigObject;
                String[] stringArray = designation;
                int n = stringArray.length;
                for (int i = 0; i < n && ((desigObject = this.designationService.getDesignationByName(desg = stringArray[i])) == null || (assignment = boundaryId == null ? this.assignmentService.findByDepartmentAndDesignation(deptId, desigObject.getId()) : this.assignmentService.findAssignmentByDepartmentDesignationAndBoundary(deptId, desigObject.getId(), boundaryId)).isEmpty()); ++i) {
                }
            }
            if (!assignment.isEmpty()) break;
        }
        return !assignment.isEmpty() ? (Assignment)assignment.get(0) : null;
    }

    public Assignment getMappedAssignmentForCscOperator(MarriageRegistration marriageRegistration, ReIssue reIssue) {
        return this.getUserPositionByZone(marriageRegistration, reIssue);
    }

    public Assignment getWorkFlowInitiator(MarriageRegistration marriageRegistration) {
        if (marriageRegistration != null) {
            if (marriageRegistration.getState() != null && marriageRegistration.getState().getInitiatorPosition() != null) {
                List assignmentList = this.assignmentService.getAssignmentsForPosition(marriageRegistration.getState().getInitiatorPosition().getId());
                return !assignmentList.isEmpty() ? (Assignment)assignmentList.get(0) : null;
            }
            if (this.isEmployee(marriageRegistration.getCreatedBy()).booleanValue() && !"Anonymous".equalsIgnoreCase(this.securityUtils.getCurrentUser().getName())) {
                return this.assignmentService.getPrimaryAssignmentForUser(marriageRegistration.getCreatedBy().getId());
            }
        }
        return null;
    }

    public Assignment getWorkFlowInitiatorForReissue(ReIssue reIssue) {
        if (reIssue != null) {
            if (reIssue.getState() != null && reIssue.getState().getInitiatorPosition() != null) {
                List assignmentList = this.assignmentService.getAssignmentsForPosition(reIssue.getState().getInitiatorPosition().getId());
                return !assignmentList.isEmpty() ? (Assignment)assignmentList.get(0) : null;
            }
            if (reIssue.getCreatedBy() != null && this.isEmployee(reIssue.getCreatedBy()).booleanValue()) {
                return this.assignmentService.getPrimaryAssignmentForUser(reIssue.getCreatedBy().getId());
            }
        }
        return null;
    }

    public Assignment getUserAssignment(User user, MarriageRegistration marriageRegistration, ReIssue reIssue) {
        Assignment assignment = this.isCscOperator(user) != false ? this.getMappedAssignmentForCscOperator(marriageRegistration, reIssue) : this.getWorkFlowInitiator(marriageRegistration);
        return assignment;
    }

    public void validateAssignmentForCscUser(MarriageRegistration marriageRegistration, ReIssue reIssue, Boolean isEmployee, BindingResult errors) {
        if (!(isEmployee.booleanValue() || marriageRegistration == null && reIssue == null || this.getUserPositionByZone(marriageRegistration, reIssue) != null)) {
            errors.reject("notexists.position", "notexists.position");
        }
    }

    private static enum WorkflowType {
        MarriageRegistration,
        ReIssue;

    }
}

