/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.application.service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.demand.model.EgDemandReasonMaster;
import org.egov.infra.admin.master.entity.Module;
import org.egov.mrs.application.service.MarriageDemandService;
import org.egov.mrs.domain.entity.ReIssue;
import org.egov.mrs.domain.enums.MarriageFeeType;
import org.springframework.stereotype.Service;

@Service
public class ReIssueDemandService
extends MarriageDemandService {
    @Override
    public Set<EgDemandDetails> createDemandDetails(BigDecimal amount) {
        HashSet<EgDemandDetails> demandDetails = new HashSet<EgDemandDetails>();
        Module module = this.moduleService.getModuleByName("Marriage Registration");
        Installment installment = this.installmentDAO.getInsatllmentByModuleForGivenDate(module, new Date());
        EgDemandReasonMaster demandReasonMaster = this.demandGenericDAO.getDemandReasonMasterByCode(MarriageFeeType.CERTIFICATEISSUE.name(), module);
        EgDemandReason demandReason = this.demandGenericDAO.getDmdReasonByDmdReasonMsterInstallAndMod(demandReasonMaster, installment, module);
        demandDetails.add(EgDemandDetails.fromReasonAndAmounts((BigDecimal)amount, (EgDemandReason)demandReason, (BigDecimal)BigDecimal.ZERO));
        return demandDetails;
    }

    @Override
    public void updateDemand(EgDemand demand, BigDecimal amount) {
        if (demand != null) {
            for (EgDemandDetails dmdDtl : demand.getEgDemandDetails()) {
                if (!dmdDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase(MarriageFeeType.CERTIFICATEISSUE.name())) continue;
                dmdDtl.setAmount(amount);
            }
            demand.setBaseDemand(amount);
        }
    }

    public Boolean checkAnyTaxIsPendingToCollect(ReIssue reIssue) {
        Boolean pendingTaxCollection = false;
        if (reIssue != null && reIssue.getDemand() != null) {
            for (EgDemandDetails demandDtl : reIssue.getDemand().getEgDemandDetails()) {
                if (demandDtl.getAmount().subtract(demandDtl.getAmtCollected()).compareTo(BigDecimal.ZERO) <= 0) continue;
                pendingTaxCollection = true;
                break;
            }
        }
        return pendingTaxCollection;
    }
}

