/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.application.reports.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.time.DateUtils;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.web.utils.WebUtils;
import org.egov.mrs.domain.entity.MarriageCertificate;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.ReIssue;
import org.egov.mrs.domain.entity.SearchModel;
import org.egov.mrs.domain.entity.SearchResult;
import org.egov.mrs.domain.enums.MaritalStatus;
import org.egov.mrs.domain.enums.MarriageCertificateType;
import org.egov.mrs.entity.es.MarriageRegistrationIndex;
import org.egov.mrs.masters.entity.MarriageRegistrationUnit;
import org.egov.mrs.masters.entity.MarriageReligion;
import org.egov.mrs.masters.service.ReligionService;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;

@Service
@Transactional(readOnly=true)
public class MarriageRegistrationReportsService {
    private static final String WIFE = "wife";
    private static final String ALL = "ALL";
    private static final String APPLICATIONDATE_BETWEEN_CONDITION = " and applicationdate between to_timestamp(:fromdate,'yyyy-MM-dd HH24:mi:ss') and to_timestamp(:todate,'YYYY-MM-DD HH24:MI:SS') ";
    private static final String MARRIAGE_REGISTRATION_DOT_HUSBAND = "marriageRegistration.husband";
    private static final String DOT_MARRIAGE_REGISTRATION_UNIT = ".marriageRegistrationUnit";
    private static final String MARRIAGE_REGISTRATION_DOT_WIFE = "marriageRegistration.wife";
    private static final String REGISTRATIONUNIT_WHERE_QUERY = " and registrationunit=to_number(:regunit,'999999')";
    private static final String STATUS_DOT_CODE = "status.code";
    private static final String MARRIAGE_REGISTRATION_STATUS = "marriageRegistration.status";
    private static final String STATUS = "status";
    private static final String MARRIAGE_REGISTRATION_UNIT_DOT_ID = "marriageRegistrationUnit.id";
    private static final String YYYY_MM_DD = "yyyy/MM/dd";
    private static final String MARRIAGE_REGISTRATION_APPLICATION_DATE = "marriageRegistration.applicationDate";
    private static final String TODATE = "todate";
    private static final String FROMDATE = "fromdate";
    private static final String REG_ZONE_WHERE_CONDITION = " and reg.zone=to_number(:zone,'999999')";
    private static final String MARRIAGE_REGISTRATION_UNIT = "marriageRegistrationUnit";
    private static final String INPUTYEAR = "year";
    private static final String REGUNIT = "regunit";
    private static final String ZONE_ID = "zone.id";
    private static final String TO_DATE = "toDate";
    private static final String ZONE = "zone";
    private static final String FROM_DATE = "fromDate";
    private static final String HUSBAND = "husband";
    private static final String MARRIAGE_REGISTRATION = "marriageRegistration";
    private static final String UNION = " union ";
    private final SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ReportService reportService;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private ReligionService religionService;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public Date resetFromDateTimeStamp(Date date) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date);
        cal1.set(11, 0);
        cal1.set(12, 0);
        cal1.set(13, 0);
        cal1.set(14, 0);
        return cal1.getTime();
    }

    public Date resetToDateTimeStamp(Date date) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date);
        cal1.set(11, 23);
        cal1.set(12, 59);
        cal1.set(13, 59);
        cal1.set(14, 999);
        return cal1.getTime();
    }

    public Date getMonthStartday(String monthyear) {
        Date monthStartDate = new Date();
        if (monthyear != null) {
            String[] monthYear = monthyear.split("/");
            Calendar calnew = Calendar.getInstance();
            calnew.set(2, Integer.parseInt(monthYear[0]) - 1);
            calnew.set(1, Integer.parseInt(monthYear[1]));
            calnew.set(11, 0);
            calnew.set(12, 0);
            calnew.set(13, 0);
            calnew.set(5, calnew.getActualMinimum(5));
            monthStartDate = calnew.getTime();
        }
        return monthStartDate;
    }

    public Date getMonthEndday(String monthyear) {
        Date monthEndDate = new Date();
        if (monthyear != null) {
            String[] monthYear = monthyear.split("/");
            Calendar calnew = Calendar.getInstance();
            calnew.set(2, Integer.parseInt(monthYear[0]) - 1);
            calnew.set(1, Integer.parseInt(monthYear[1]));
            calnew.set(11, 23);
            calnew.set(12, 59);
            calnew.set(13, 59);
            calnew.set(14, 999);
            calnew.set(5, calnew.getActualMaximum(5));
            monthEndDate = calnew.getTime();
        }
        return monthEndDate;
    }

    @ReadOnly
    public List<Object[]> searchMarriageRegistrationsForCertificateReport(MarriageCertificate certificate) throws ParseException {
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuilder queryStrForRegistration = new StringBuilder(1000);
        queryStrForRegistration.append("Select reg.registrationno,reg.dateofmarriage,reg.applicationdate,reg.rejectionreason,cert.certificateno,cert.certificatetype,cert.certificatedate, brndy.name,(Select concat(concat(concat(app.firstname, ' '), app.middlename, ' '), app.lastname) as hus_name from egmrs_applicant app where app.id = reg.husband),(Select concat(concat(concat(app.firstname, ' '), app.middlename, ' '), app.lastname) as wife_name from egmrs_applicant app where app.id = reg.wife),reg.id  from egmrs_registration reg, egmrs_certificate cert, eg_boundary brndy,egw_status st where reg.zone = brndy.id and reg.status = st.id and st.code in('REGISTERED')  and reg.id = cert.registration and cert.reissue is null ");
        if (certificate.getRegistration().getZone() != null) {
            queryStrForRegistration.append(REG_ZONE_WHERE_CONDITION);
            params.put(ZONE, String.valueOf(certificate.getRegistration().getZone().getId()));
        }
        if (certificate.getCertificateType() != null && !ALL.equals(MarriageCertificateType.values())) {
            queryStrForRegistration.append(" and cert.certificatetype=:certificatetype");
            params.put("certificatetype", certificate.getCertificateType().name());
        } else if (certificate.getCertificateType() != null && ALL.equals(MarriageCertificateType.values())) {
            queryStrForRegistration.append(" and cert.certificatetype in('REGISTRATION','REISSUE','REJECTION')");
        }
        if (certificate.getFromDate() != null) {
            queryStrForRegistration.append(" and cert.certificatedate >= to_timestamp(:fromDate,'yyyy-MM-dd HH24:mi:ss')");
            params.put(FROM_DATE, this.sf.format(this.resetFromDateTimeStamp(certificate.getFromDate())));
        }
        if (certificate.getToDate() != null) {
            queryStrForRegistration.append(" and cert.certificatedate <= to_timestamp(:toDate,'YYYY-MM-DD HH24:MI:SS')");
            params.put(TO_DATE, this.sf.format(this.resetToDateTimeStamp(certificate.getToDate())));
        }
        if (certificate.getRegistration().getRegistrationNo() != null) {
            queryStrForRegistration.append(" and reg.registrationno=:registrationNo");
            params.put("registrationNo", certificate.getRegistration().getRegistrationNo());
        }
        StringBuilder queryStrForReissue = new StringBuilder(1100);
        queryStrForReissue.append("Select reg.registrationno,reg.dateofmarriage,reg.applicationdate,reg.rejectionreason,cert.certificateno,cert.certificatetype,cert.certificatedate, brndy.name,(Select concat(concat(concat(app.firstname, ' '), app.middlename, ' '), app.lastname) as hus_name from egmrs_applicant app where app.id = reg.husband),(Select concat(concat(concat(app.firstname, ' '), app.middlename, ' '), app.lastname) as wife_name from egmrs_applicant app where app.id = reg.wife),reg.id from egmrs_registration reg,egmrs_reissue reis, egmrs_certificate cert, eg_boundary brndy,egw_status st  where reg.zone = brndy.id and reg.id=reis.registration and reis.status = st.id and st.code in('CERTIFICATEREISSUED','REJECTION')  and reis.id = cert.reissue and cert.registration is null");
        if (certificate.getRegistration().getZone() != null) {
            queryStrForReissue.append(REG_ZONE_WHERE_CONDITION);
            params.put(ZONE, String.valueOf(certificate.getRegistration().getZone().getId()));
        }
        if (certificate.getCertificateType() != null && !ALL.equals(MarriageCertificateType.values())) {
            queryStrForReissue.append(" and cert.certificatetype=:certificatetype");
            params.put("certificatetype", certificate.getCertificateType().name());
        } else if (certificate.getCertificateType() != null && ALL.equals((Object)certificate.getCertificateType())) {
            queryStrForReissue.append(" and cert.certificatetype in('REGISTRATION','REISSUE','REJECTION')");
        }
        if (certificate.getFromDate() != null) {
            queryStrForReissue.append(" and cert.certificatedate >= to_timestamp(:fromDate,'yyyy-MM-dd HH24:mi:ss')");
            params.put(FROM_DATE, this.sf.format(this.resetFromDateTimeStamp(certificate.getFromDate())));
        }
        if (certificate.getToDate() != null) {
            queryStrForReissue.append(" and cert.certificatedate <= to_timestamp(:toDate,'YYYY-MM-DD HH24:MI:SS')");
            params.put(TO_DATE, this.sf.format(this.resetToDateTimeStamp(certificate.getToDate())));
        }
        if (certificate.getRegistration().getRegistrationNo() != null) {
            queryStrForReissue.append(" and reg.registrationno=:registrationNo");
            params.put("registrationNo", certificate.getRegistration().getRegistrationNo());
        }
        StringBuilder aggregateQueryStr = new StringBuilder();
        aggregateQueryStr.append(queryStrForRegistration.toString());
        aggregateQueryStr.append(UNION);
        aggregateQueryStr.append(queryStrForReissue.toString());
        SQLQuery query = this.getCurrentSession().createSQLQuery(aggregateQueryStr.toString());
        for (Map.Entry param : params.entrySet()) {
            query.setParameter((String)param.getKey(), param.getValue());
        }
        return query.list();
    }

    @ReadOnly
    public List<String[]> searchRegistrationOfHusbandAgeWise(int year, MarriageRegistration registration) throws ParseException {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        StringBuilder queryForHusband = new StringBuilder(1000);
        queryForHusband.append("(Select ap.ageinyears , count(*) from egmrs_registration rg,egmrs_applicant ap,egmrs_registrationunit  ru,egw_status st where rg.husband=ap.id and  rg.registrationunit=ru.id and rg.status = st.id and  st.code='REGISTERED' and extract( year from rg.applicationdate)=:year ");
        params.put(INPUTYEAR, year);
        if (registration.getMarriageRegistrationUnit().getId() != null) {
            queryForHusband.append(" and  rg.registrationunit=:regunit ");
            params.put(REGUNIT, registration.getMarriageRegistrationUnit().getId().intValue());
        }
        if (registration.getZone().getId() != null) {
            queryForHusband.append(" and  rg.zone=:zone ");
            params.put(ZONE, registration.getZone().getId().intValue());
        }
        queryForHusband.append("group by ap.ageinyears order by ap.ageinyears )");
        SQLQuery query = this.getCurrentSession().createSQLQuery(queryForHusband.toString());
        for (Map.Entry param : params.entrySet()) {
            query.setParameter((String)param.getKey(), param.getValue());
        }
        return query.list();
    }

    @ReadOnly
    public List<String[]> searchRegistrationOfWifeAgeWise(int year, MarriageRegistration registration) throws ParseException {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        StringBuilder queryForWife = new StringBuilder(1000);
        queryForWife.append("(Select ap.ageinyears , count(*) from egmrs_registration rg,egmrs_applicant ap,egmrs_registrationunit  ru,egw_status st where rg.wife=ap.id and  rg.registrationunit=ru.id and rg.status = st.id and  st.code='REGISTERED' and  extract( year from rg.applicationdate)=:year ");
        params.put(INPUTYEAR, year);
        if (registration.getMarriageRegistrationUnit().getId() != null) {
            queryForWife.append(" and  rg.registrationunit=:regunit ");
            params.put(REGUNIT, registration.getMarriageRegistrationUnit().getId().intValue());
        }
        if (registration.getZone().getId() != null) {
            queryForWife.append(" and  rg.zone=:zone ");
            params.put(ZONE, registration.getZone().getId().intValue());
        }
        queryForWife.append("group by ap.ageinyears order by ap.ageinyears )");
        SQLQuery query = this.getCurrentSession().createSQLQuery(queryForWife.toString());
        for (Map.Entry param : params.entrySet()) {
            query.setParameter((String)param.getKey(), param.getValue());
        }
        return query.list();
    }

    @ReadOnly
    public List<String[]> searchRegistrationActWise(MarriageRegistration registration, int year) throws ParseException {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        StringBuilder queryForAct = new StringBuilder(700);
        queryForAct.append("(select extract( month from reg.applicationdate) as Month,count(*)  from egmrs_registration  reg, egmrs_act  act, egw_status  status ,egmrs_registrationunit ru,eg_boundary b where reg.marriageact=act.id and  reg.registrationunit=ru.id and reg.status = status.id and status.code in('REGISTERED')  and reg.zone=b.id and reg.marriageact=:act and extract( year from reg.applicationdate)=:year ");
        params.put("act", registration.getMarriageAct().getId().intValue());
        params.put(INPUTYEAR, year);
        if (registration.getMarriageRegistrationUnit().getId() != null) {
            queryForAct.append(" and  reg.registrationunit=:regunit ");
            params.put(REGUNIT, registration.getMarriageRegistrationUnit().getId().intValue());
        }
        if (registration.getZone().getId() != null) {
            queryForAct.append(" and reg.zone=:zone ");
            params.put(ZONE, registration.getZone().getId().intValue());
        }
        queryForAct.append("group by Month)");
        SQLQuery query = this.getCurrentSession().createSQLQuery(queryForAct.toString());
        for (Map.Entry param : params.entrySet()) {
            query.setParameter((String)param.getKey(), param.getValue());
        }
        return query.list();
    }

    @ReadOnly
    public List<MarriageRegistration> getAgewiseDetails(MarriageRegistration registration, String regunit, String age, int year, String applicant) throws ParseException {
        Criteria criteria = this.getCurrentSession().createCriteria(MarriageRegistration.class, MARRIAGE_REGISTRATION);
        String[] values = age.split("-");
        SimpleDateFormat formatter = new SimpleDateFormat(YYYY_MM_DD);
        Date fromDate = formatter.parse(year + "/" + 1 + "/" + 1);
        Date toDate = formatter.parse(year + "/" + 12 + "/" + 31);
        if (HUSBAND.equals(applicant)) {
            criteria.createAlias(MARRIAGE_REGISTRATION_DOT_HUSBAND, HUSBAND).add(Restrictions.between((String)"husband.ageInYearsAsOnMarriage", (Object)Integer.valueOf(values[0]), (Object)Integer.valueOf(values[1])));
            this.buildAgeWiseSearchCriteria(registration, regunit, criteria, fromDate, toDate);
        } else {
            criteria.createAlias(MARRIAGE_REGISTRATION_DOT_WIFE, WIFE).add(Restrictions.between((String)"wife.ageInYearsAsOnMarriage", (Object)Integer.valueOf(values[0]), (Object)Integer.valueOf(values[1])));
            this.buildAgeWiseSearchCriteria(registration, regunit, criteria, fromDate, toDate);
        }
        criteria.createAlias(MARRIAGE_REGISTRATION_STATUS, STATUS).add(Restrictions.in((String)STATUS_DOT_CODE, (Object[])new String[]{MarriageRegistration.RegistrationStatus.REGISTERED.toString()}));
        return criteria.list();
    }

    private void buildAgeWiseSearchCriteria(MarriageRegistration registration, String regunit, Criteria criteria, Date fromDate, Date toDate) {
        if (fromDate != null) {
            criteria.add((Criterion)Restrictions.ge((String)MARRIAGE_REGISTRATION_APPLICATION_DATE, (Object)fromDate));
        }
        if (toDate != null) {
            criteria.add((Criterion)Restrictions.le((String)MARRIAGE_REGISTRATION_APPLICATION_DATE, (Object)toDate));
        }
        if (regunit != null) {
            criteria.createAlias("marriageRegistration.marriageRegistrationUnit", MARRIAGE_REGISTRATION_UNIT).add((Criterion)Restrictions.eq((String)MARRIAGE_REGISTRATION_UNIT_DOT_ID, (Object)Long.parseLong(regunit)));
        }
        if (null != registration.getZone() && registration.getZone().getId() != null) {
            criteria.add((Criterion)Restrictions.eq((String)ZONE_ID, (Object)registration.getZone().getId()));
        }
    }

    @ReadOnly
    public List<MarriageRegistration> searchStatusAtTimeOfMarriage(MarriageRegistration registration) throws ParseException {
        Criteria criteria = this.getCurrentSession().createCriteria(MarriageRegistration.class, MARRIAGE_REGISTRATION).createAlias(MARRIAGE_REGISTRATION_STATUS, STATUS);
        if (registration.getHusband().getMaritalStatus() != null) {
            criteria.createAlias(MARRIAGE_REGISTRATION_DOT_HUSBAND, HUSBAND).add((Criterion)Restrictions.eq((String)"husband.maritalStatus", (Object)((Object)registration.getHusband().getMaritalStatus())));
        }
        criteria.createAlias(MARRIAGE_REGISTRATION_DOT_WIFE, WIFE).add((Criterion)Restrictions.eq((String)"wife.maritalStatus", (Object)((Object)registration.getHusband().getMaritalStatus())));
        criteria.add(Restrictions.in((String)STATUS_DOT_CODE, (Object[])new String[]{MarriageRegistration.RegistrationStatus.REGISTERED.toString()}));
        return criteria.list();
    }

    @ReadOnly
    public List<String[]> getHusbandCountByMaritalStatus(Date fromDate, Date toDate, String maritalStatus, MarriageRegistration registration) throws ParseException {
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuilder queryStrForHusbandCount = new StringBuilder(600);
        queryStrForHusbandCount.append("select app.relationstatus,to_char(app.createddate,'Mon'),count(*) from egmrs_applicant as app ,egmrs_registration as reg where reg.husband = app.id  ");
        if (maritalStatus != null) {
            queryStrForHusbandCount.append(" and app.relationstatus=:maritalStatus");
            params.put("maritalStatus", maritalStatus);
        }
        if (fromDate != null) {
            queryStrForHusbandCount.append(" and app.createddate >= to_timestamp(:fromDate,'yyyy-MM-dd HH24:mi:ss') ");
            params.put(FROM_DATE, this.sf.format(this.resetFromDateTimeStamp(fromDate)));
        }
        if (toDate != null) {
            queryStrForHusbandCount.append(" and app.createddate <= to_timestamp(:toDate,'YYYY-MM-DD HH24:MI:SS')");
            params.put(TO_DATE, this.sf.format(this.resetToDateTimeStamp(toDate)));
        }
        if (registration.getMarriageRegistrationUnit().getId() != null) {
            queryStrForHusbandCount.append(" and reg.registrationunit=to_number(:regunit,'999999')");
            params.put(REGUNIT, registration.getMarriageRegistrationUnit().getId().toString());
        }
        if (registration.getZone().getId() != null) {
            queryStrForHusbandCount.append(REG_ZONE_WHERE_CONDITION);
            params.put(ZONE, registration.getZone().getId().toString());
        }
        queryStrForHusbandCount.append(" group by app.relationstatus, to_char(app.createddate,'Mon') order by to_char(app.createddate,'Mon') desc");
        SQLQuery query = this.getCurrentSession().createSQLQuery(queryStrForHusbandCount.toString());
        for (Map.Entry param : params.entrySet()) {
            query.setParameter((String)param.getKey(), param.getValue());
        }
        return query.list();
    }

    public List<String[]> getWifeCountByMaritalStatus(Date fromDate, Date toDate, String maritalStatus, MarriageRegistration registration) throws ParseException {
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuilder queryStrForWifeCount = new StringBuilder(600);
        queryStrForWifeCount.append("select app.relationstatus,to_char(app.createddate,'Mon'),count(*) from egmrs_applicant as app ,egmrs_registration as reg where reg.wife = app.id  ");
        if (maritalStatus != null) {
            queryStrForWifeCount.append(" and app.relationstatus=:maritalStatus");
            params.put("maritalStatus", maritalStatus);
        }
        if (fromDate != null) {
            queryStrForWifeCount.append(" and app.createddate >= to_timestamp(:fromDate,'yyyy-MM-dd HH24:mi:ss')");
            params.put(FROM_DATE, this.sf.format(this.resetFromDateTimeStamp(fromDate)));
        }
        if (toDate != null) {
            queryStrForWifeCount.append(" and app.createddate <= to_timestamp(:toDate,'YYYY-MM-DD HH24:MI:SS')");
            params.put(TO_DATE, this.sf.format(this.resetToDateTimeStamp(toDate)));
        }
        if (registration.getMarriageRegistrationUnit().getId() != null) {
            queryStrForWifeCount.append(REGISTRATIONUNIT_WHERE_QUERY);
            params.put(REGUNIT, registration.getMarriageRegistrationUnit().getId().toString());
        }
        if (registration.getZone().getId() != null) {
            queryStrForWifeCount.append(" and zone=to_number(:zone,'999999')");
            params.put(ZONE, registration.getZone().getId().toString());
        }
        queryStrForWifeCount.append(" group by app.relationstatus, to_char(app.createddate,'Mon') order by to_char(app.createddate,'Mon') desc");
        SQLQuery query = this.getCurrentSession().createSQLQuery(queryStrForWifeCount.toString());
        for (Map.Entry param : params.entrySet()) {
            query.setParameter((String)param.getKey(), param.getValue());
        }
        return query.list();
    }

    @ReadOnly
    public List<MarriageRegistration> getByMaritalStatusDetails(MarriageRegistration registration, String regunit, String applicant, String maritalStatus, Date fromDate, Date toDate) throws ParseException {
        Criteria criteria = this.getCurrentSession().createCriteria(MarriageRegistration.class, MARRIAGE_REGISTRATION);
        if (maritalStatus != null && HUSBAND.equals(applicant)) {
            criteria = criteria.createAlias(MARRIAGE_REGISTRATION_DOT_HUSBAND, HUSBAND);
            if (fromDate != null) {
                criteria.add((Criterion)Restrictions.ge((String)"husband.createdDate", (Object)this.resetFromDateTimeStamp(fromDate)));
            }
            if (toDate != null) {
                criteria.add((Criterion)Restrictions.le((String)"husband.createdDate", (Object)this.resetToDateTimeStamp(toDate)));
            }
            if (regunit != null) {
                criteria.createAlias("marriageRegistration.marriageRegistrationUnit", MARRIAGE_REGISTRATION_UNIT).add((Criterion)Restrictions.eq((String)MARRIAGE_REGISTRATION_UNIT_DOT_ID, (Object)Long.parseLong(regunit)));
            }
            if (null != registration.getZone() && registration.getZone().getId() != null) {
                criteria.add((Criterion)Restrictions.eq((String)ZONE_ID, (Object)registration.getZone().getId()));
            }
            criteria.add((Criterion)Restrictions.eq((String)"husband.maritalStatus", (Object)((Object)MaritalStatus.valueOf(maritalStatus))));
        } else {
            criteria = criteria.createAlias(MARRIAGE_REGISTRATION_DOT_WIFE, WIFE);
            if (fromDate != null) {
                criteria.add((Criterion)Restrictions.ge((String)"wife.createdDate", (Object)this.resetFromDateTimeStamp(fromDate)));
            }
            if (toDate != null) {
                criteria.add((Criterion)Restrictions.le((String)"wife.createdDate", (Object)this.resetToDateTimeStamp(toDate)));
            }
            if (maritalStatus != null) {
                criteria.add((Criterion)Restrictions.eq((String)"wife.maritalStatus", (Object)((Object)MaritalStatus.valueOf(maritalStatus))));
            }
            if (regunit != null) {
                criteria.createAlias("marriageRegistration.marriageRegistrationUnit", MARRIAGE_REGISTRATION_UNIT).add((Criterion)Restrictions.eq((String)MARRIAGE_REGISTRATION_UNIT_DOT_ID, (Object)Long.parseLong(regunit)));
            }
            if (null != registration.getZone() && registration.getZone().getId() != null) {
                criteria.add((Criterion)Restrictions.eq((String)ZONE_ID, (Object)registration.getZone().getId()));
            }
        }
        return criteria.list();
    }

    @ReadOnly
    public List<MarriageRegistration> searchRegistrationBydate(MarriageRegistration registration) throws ParseException {
        Calendar cal;
        Criteria criteria = this.getCurrentSession().createCriteria(MarriageRegistration.class, MARRIAGE_REGISTRATION);
        if (null != registration.getMarriageRegistrationUnit() && registration.getMarriageRegistrationUnit().getId() != null) {
            criteria.add((Criterion)Restrictions.eq((String)MARRIAGE_REGISTRATION_UNIT_DOT_ID, (Object)registration.getMarriageRegistrationUnit().getId()));
        }
        if (null != registration.getZone() && registration.getZone().getId() != null) {
            criteria.add((Criterion)Restrictions.eq((String)ZONE_ID, (Object)registration.getZone().getId()));
        }
        if (null != registration.getStatus() && registration.getStatus().getCode() != null) {
            criteria.createAlias(MARRIAGE_REGISTRATION_STATUS, STATUS).add((Criterion)Restrictions.eq((String)STATUS_DOT_CODE, (Object)registration.getStatus().getCode()));
        }
        if (registration.getFromDate() != null) {
            criteria.add((Criterion)Restrictions.ge((String)MARRIAGE_REGISTRATION_APPLICATION_DATE, (Object)this.resetFromDateTimeStamp(registration.getFromDate())));
        }
        if (registration.getToDate() != null) {
            criteria.add((Criterion)Restrictions.le((String)MARRIAGE_REGISTRATION_APPLICATION_DATE, (Object)this.resetToDateTimeStamp(registration.getToDate())));
        }
        criteria.addOrder(Order.desc((String)MARRIAGE_REGISTRATION_APPLICATION_DATE));
        if (registration.getFromDate() != null) {
            cal = Calendar.getInstance();
            Date todate = cal.getTime();
            criteria.add(Restrictions.between((String)MARRIAGE_REGISTRATION_APPLICATION_DATE, (Object)registration.getFromDate(), (Object)(todate != null ? todate : new Date())));
        }
        if (registration.getToDate() == null) {
            cal = Calendar.getInstance();
            cal.set(1, 2009);
            Date fromdate = cal.getTime();
            criteria.add(Restrictions.between((String)MARRIAGE_REGISTRATION_APPLICATION_DATE, (Object)fromdate, (Object)(registration.getToDate() != null ? DateUtils.addDays((Date)registration.getToDate(), (int)1) : new Date())));
        }
        return criteria.list();
    }

    @ReadOnly
    public List<String[]> getMonthwiseFundCollected(MarriageRegistration registration, String year) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, Integer> intparams = new HashMap<String, Integer>();
        StringBuilder queryStrForRegFee = new StringBuilder(1000);
        StringBuilder queryStrForReissueFee = new StringBuilder(1000);
        StringBuilder queryStr = new StringBuilder(700);
        queryStr.append("select Month, SUM(Amount),Monthname from (");
        queryStrForRegFee.append("(select extract(month from applicationdate) as Month,SUM(reg.feepaid) as Amount,to_char(applicationdate,'Month') as Monthname from egmrs_registration reg,egmrs_registrationunit regunit,eg_demand demand where reg.registrationunit=regunit.id and reg.demand=demand.id and demand.amt_collected!=0 ");
        this.buildSearchCriteriaMonthWiseFundCollection(registration, year, params, intparams, queryStrForRegFee);
        queryStrForReissueFee.append("(select extract(month from applicationdate) as Month,SUM(reissue.feepaid) as Amount,to_char(applicationdate,'Month') as Monthname from egmrs_reissue reissue,egmrs_registrationunit regunit,eg_demand demand where reissue.registrationunit=regunit.id and reissue.demand=demand.id and demand.amt_collected!=0 ");
        this.buildSearchCriteriaMonthWiseFundCollection(registration, year, params, intparams, queryStrForReissueFee);
        StringBuilder aggregateQueryStr = new StringBuilder();
        aggregateQueryStr.append(queryStrForRegFee.toString());
        aggregateQueryStr.append(UNION);
        aggregateQueryStr.append(queryStrForReissueFee.toString());
        queryStr.append(aggregateQueryStr.toString());
        queryStr.append(") as x GROUP BY MONTH,Monthname");
        SQLQuery query = this.getCurrentSession().createSQLQuery(queryStr.toString());
        for (Map.Entry param : params.entrySet()) {
            query.setParameter((String)param.getKey(), param.getValue());
        }
        for (Map.Entry intparam : intparams.entrySet()) {
            query.setParameter((String)intparam.getKey(), intparam.getValue());
        }
        return query.list();
    }

    private void buildSearchCriteriaMonthWiseFundCollection(MarriageRegistration registration, String year, Map<String, String> params, Map<String, Integer> intparams, StringBuilder queryStrFOorApplns) {
        if (year != null) {
            queryStrFOorApplns.append(" and extract(year from applicationdate)=:years ");
            int years = Integer.parseInt(year);
            intparams.put("years", years);
        }
        if (registration.getMonthYear() != null) {
            queryStrFOorApplns.append(APPLICATIONDATE_BETWEEN_CONDITION);
            params.put(FROMDATE, this.sf.format(this.getMonthStartday(registration.getMonthYear())));
            params.put(TODATE, this.sf.format(this.getMonthEndday(registration.getMonthYear())));
        }
        if (registration.getMarriageRegistrationUnit().getId() != null) {
            queryStrFOorApplns.append(REGISTRATIONUNIT_WHERE_QUERY);
            params.put(REGUNIT, registration.getMarriageRegistrationUnit().getId().toString());
        }
        queryStrFOorApplns.append("group by regunit.name,extract(month from applicationdate),to_char(applicationdate,'Month') order by regunit.name)");
    }

    @ReadOnly
    public List<String[]> getCountOfApplications(MarriageRegistration registration) {
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuilder queryStrForRegCount = new StringBuilder(1000);
        queryStrForRegCount.append("(select regunit.name,count(*),to_char(applicationdate,'Mon'),'registration' from egmrs_registration reg,egmrs_registrationunit regunit,egw_status st where reg.registrationunit=regunit.id and reg.status = st.id and st.code='REGISTERED' ");
        if (registration.getZone().getId() != null) {
            queryStrForRegCount.append(REG_ZONE_WHERE_CONDITION);
            params.put(ZONE, registration.getZone().getId().toString());
        }
        this.buildCriteriaForMrgApplicationsCount(registration, params, queryStrForRegCount);
        StringBuilder queryStrForReissueCount = new StringBuilder(1000);
        queryStrForReissueCount.append("(select regunit.name,count(*),to_char(applicationdate,'Mon'),'reissue' from egmrs_reissue rei,egmrs_registrationunit regunit,egw_status st where rei.registrationunit=regunit.id and rei.status = st.id and st.code='CERTIFICATEREISSUED' ");
        if (registration.getZone().getId() != null) {
            queryStrForReissueCount.append(" and rei.zone=to_number(:zone,'999999')");
            params.put(ZONE, registration.getZone().getId().toString());
        }
        this.buildCriteriaForMrgApplicationsCount(registration, params, queryStrForReissueCount);
        StringBuilder aggregateQueryStr = new StringBuilder();
        aggregateQueryStr.append(queryStrForRegCount.toString());
        aggregateQueryStr.append(UNION);
        aggregateQueryStr.append(queryStrForReissueCount.toString());
        SQLQuery query = this.getCurrentSession().createSQLQuery(aggregateQueryStr.toString());
        for (Map.Entry param : params.entrySet()) {
            query.setParameter((String)param.getKey(), param.getValue());
        }
        return query.list();
    }

    private void buildCriteriaForMrgApplicationsCount(MarriageRegistration registration, Map<String, String> params, StringBuilder queryForApplns) {
        if (registration.getMonthYear() != null) {
            queryForApplns.append(APPLICATIONDATE_BETWEEN_CONDITION);
            params.put(FROMDATE, this.sf.format(this.getMonthStartday(registration.getMonthYear())));
            params.put(TODATE, this.sf.format(this.getMonthEndday(registration.getMonthYear())));
        }
        if (registration.getMarriageRegistrationUnit().getId() != null) {
            queryForApplns.append(REGISTRATIONUNIT_WHERE_QUERY);
            params.put(REGUNIT, registration.getMarriageRegistrationUnit().getId().toString());
        }
        queryForApplns.append("group by regunit.name,to_char(applicationdate,'Mon') order by regunit.name)");
    }

    @ReadOnly
    public List<MarriageRegistration> searchRegistrationBymonth(MarriageRegistration registration, String month, String registrationUnit) throws ParseException {
        Criteria criteria = this.getCurrentSession().createCriteria(MarriageRegistration.class, MARRIAGE_REGISTRATION).createAlias(MARRIAGE_REGISTRATION_STATUS, STATUS);
        if (month != null) {
            criteria.add(Restrictions.between((String)MARRIAGE_REGISTRATION_APPLICATION_DATE, (Object)this.getMonthStartday(month), (Object)this.getMonthEndday(month)));
        }
        if (registration.getZone() != null) {
            criteria.createAlias("marriageRegistration.zone", ZONE).add((Criterion)Restrictions.eq((String)ZONE_ID, (Object)registration.getZone().getId().toString()));
        }
        if (registrationUnit != null) {
            criteria.createAlias("marriageRegistration.marriageRegistrationUnit", REGUNIT).add((Criterion)Restrictions.eq((String)"regunit.name", (Object)registrationUnit));
        }
        criteria.add(Restrictions.in((String)STATUS_DOT_CODE, (Object[])new String[]{MarriageRegistration.RegistrationStatus.REGISTERED.toString()}));
        return criteria.list();
    }

    @ReadOnly
    public List<ReIssue> searchReissueBymonth(MarriageRegistration registration, String month, String registrationUnit) throws ParseException {
        Criteria criteria = this.getCurrentSession().createCriteria(ReIssue.class, "reissue").createAlias("reissue.status", STATUS);
        if (month != null) {
            criteria.add(Restrictions.between((String)"reissue.applicationDate", (Object)this.getMonthStartday(month), (Object)this.getMonthEndday(month)));
        }
        if (registration.getZone() != null) {
            criteria.createAlias("marriageRegistration.zone", ZONE).add((Criterion)Restrictions.eq((String)ZONE_ID, (Object)registration.getZone().getId().toString()));
        }
        if (registrationUnit != null) {
            criteria.createAlias("reissue.marriageRegistrationUnit", REGUNIT).add((Criterion)Restrictions.eq((String)"regunit.name", (Object)registrationUnit));
        }
        criteria.add(Restrictions.in((String)STATUS_DOT_CODE, (Object[])new String[]{"CERTIFICATEREISSUED"}));
        return criteria.list();
    }

    public List<MarriageRegistration> searchRegistrationByreligion(MarriageRegistration registration, int year) throws ParseException {
        List<String> mrgReligionNames;
        Criteria criteria = this.getCurrentSession().createCriteria(MarriageRegistration.class, MARRIAGE_REGISTRATION).createAlias(MARRIAGE_REGISTRATION_STATUS, STATUS);
        SimpleDateFormat formatter = new SimpleDateFormat(YYYY_MM_DD);
        Date fromDate = formatter.parse(year + "/" + 1 + "/" + 1);
        Date toDate = formatter.parse(year + "/" + 12 + "/" + 31);
        if (null != registration.getHusband().getReligion() && registration.getHusband().getReligion().getId() != null && registration.getHusband().getReligion().getId() != 0L) {
            criteria.createAlias(MARRIAGE_REGISTRATION_DOT_HUSBAND, HUSBAND).add((Criterion)Restrictions.eq((String)"husband.religion.id", (Object)registration.getHusband().getReligion().getId()));
        } else {
            mrgReligionNames = this.getReligionNames();
            criteria.createAlias(MARRIAGE_REGISTRATION_DOT_HUSBAND, HUSBAND).createAlias("husband.religion", "husreligion").add(Restrictions.in((String)"husreligion.name", (Object[])mrgReligionNames.toArray(new String[mrgReligionNames.size()])));
        }
        if (null != registration.getWife().getReligion() && registration.getWife().getReligion().getId() != null && registration.getWife().getReligion().getId() != 0L) {
            criteria.createAlias(MARRIAGE_REGISTRATION_DOT_WIFE, WIFE).add((Criterion)Restrictions.eq((String)"wife.religion.id", (Object)registration.getWife().getReligion().getId()));
        } else {
            mrgReligionNames = this.getReligionNames();
            criteria.createAlias(MARRIAGE_REGISTRATION_DOT_WIFE, WIFE).createAlias("wife.religion", "wifereligion").add(Restrictions.in((String)"wifereligion.name", (Object[])mrgReligionNames.toArray(new String[mrgReligionNames.size()])));
        }
        if (null != fromDate) {
            criteria.add((Criterion)Restrictions.ge((String)MARRIAGE_REGISTRATION_APPLICATION_DATE, (Object)this.resetFromDateTimeStamp(fromDate)));
        }
        if (null != toDate) {
            criteria.add((Criterion)Restrictions.le((String)MARRIAGE_REGISTRATION_APPLICATION_DATE, (Object)this.resetToDateTimeStamp(toDate)));
        }
        if (null != registration.getMarriageRegistrationUnit() && registration.getMarriageRegistrationUnit().getId() != null) {
            criteria.add((Criterion)Restrictions.eq((String)MARRIAGE_REGISTRATION_UNIT_DOT_ID, (Object)registration.getMarriageRegistrationUnit().getId()));
        }
        if (null != registration.getZone() && registration.getZone().getId() != null) {
            criteria.add((Criterion)Restrictions.eq((String)ZONE_ID, (Object)registration.getZone().getId()));
        }
        if (null != registration.getMarriageRegistrationUnit() && registration.getMarriageRegistrationUnit().getId() != null) {
            criteria.add((Criterion)Restrictions.eq((String)MARRIAGE_REGISTRATION_UNIT_DOT_ID, (Object)registration.getMarriageRegistrationUnit().getId()));
        }
        criteria.add(Restrictions.in((String)STATUS_DOT_CODE, (Object[])new String[]{MarriageRegistration.RegistrationStatus.APPROVED.toString(), MarriageRegistration.RegistrationStatus.REGISTERED.toString()}));
        return criteria.list();
    }

    private List<String> getReligionNames() {
        ArrayList<String> religionNameList = new ArrayList<String>();
        List<MarriageReligion> marriageReligions = this.religionService.findAll();
        for (MarriageReligion marriageReligion : marriageReligions) {
            religionNameList.add(marriageReligion.getName());
        }
        return religionNameList;
    }

    @ReadOnly
    public List<String[]> searchRegistrationMrActWise(int year, MarriageRegistration registration) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        StringBuilder queryForAct = new StringBuilder(1000);
        queryForAct.append("(select act.name,count(*) from egmrs_registration  reg, egmrs_act  act, egw_status  status ,egmrs_registrationunit ru,eg_boundary b where reg.marriageact=act.id and status.code in('APPROVED')  and reg.registrationunit=ru.id and reg.status = status.id and reg.zone=b.id  and extract( year from reg.applicationdate)=:year ");
        params.put(INPUTYEAR, year);
        if (registration.getMarriageRegistrationUnit().getId() != null) {
            queryForAct.append(" and  reg.registrationunit=:regunit ");
            params.put(REGUNIT, registration.getMarriageRegistrationUnit().getId().intValue());
        }
        if (registration.getZone().getId() != null) {
            queryForAct.append(" and  reg.zone=:zone ");
            params.put(ZONE, registration.getZone().getId().intValue());
        }
        queryForAct.append("group by act.name)");
        SQLQuery query = this.getCurrentSession().createSQLQuery(queryForAct.toString());
        for (Map.Entry param : params.entrySet()) {
            query.setParameter((String)param.getKey(), param.getValue());
        }
        return query.list();
    }

    @ReadOnly
    public List<MarriageRegistration> getActwiseDetails(int year, String act) throws ParseException {
        Criteria criteria = this.getCurrentSession().createCriteria(MarriageRegistration.class, MARRIAGE_REGISTRATION).createAlias(MARRIAGE_REGISTRATION_STATUS, STATUS);
        SimpleDateFormat formatter = new SimpleDateFormat(YYYY_MM_DD);
        Date fromDate = formatter.parse(year + "/" + 1 + "/" + 1);
        Date toDate = formatter.parse(year + "/" + 12 + "/" + 31);
        if (act != null) {
            criteria.createAlias("marriageRegistration.marriageAct", "marriageAct").add((Criterion)Restrictions.eq((String)"marriageAct.name", (Object)act));
        }
        if (fromDate != null) {
            criteria.add((Criterion)Restrictions.ge((String)MARRIAGE_REGISTRATION_APPLICATION_DATE, (Object)this.resetFromDateTimeStamp(fromDate)));
        }
        if (toDate != null) {
            criteria.add((Criterion)Restrictions.le((String)MARRIAGE_REGISTRATION_APPLICATION_DATE, (Object)this.resetToDateTimeStamp(toDate)));
        }
        criteria.add(Restrictions.in((String)STATUS_DOT_CODE, (Object[])new String[]{MarriageRegistration.RegistrationStatus.APPROVED.toString()}));
        return criteria.list();
    }

    @ReadOnly
    public List<MarriageRegistration> getmonthWiseActDetails(int year, int month, Long actid) throws ParseException {
        Criteria criteria = this.getCurrentSession().createCriteria(MarriageRegistration.class, MARRIAGE_REGISTRATION).createAlias(MARRIAGE_REGISTRATION_STATUS, STATUS);
        String monthYear = month + "/" + year;
        if (actid != null) {
            criteria.createAlias("marriageRegistration.marriageAct", "marriageAct").add((Criterion)Restrictions.eq((String)"marriageAct.id", (Object)actid));
        }
        if (monthYear != null) {
            criteria.add(Restrictions.between((String)MARRIAGE_REGISTRATION_APPLICATION_DATE, (Object)this.getMonthStartday(monthYear), (Object)this.getMonthEndday(monthYear)));
        }
        criteria.add(Restrictions.in((String)STATUS_DOT_CODE, (Object[])new String[]{MarriageRegistration.RegistrationStatus.APPROVED.toString()}));
        return criteria.list();
    }

    @ReadOnly
    public List<Object[]> getAgeingRegDetails(String day, int year) throws ParseException {
        String[] values = day.split("-");
        StringBuilder queryStrForRegistration = new StringBuilder(1000);
        HashMap<String, Double> params = new HashMap<String, Double>();
        queryStrForRegistration.append("Select reg.applicationno,reg.registrationno,(Select concat(concat(concat(app.firstname, ' '), app.middlename, ' '), app.lastname) as hus_name from egmrs_applicant app where app.id = reg.husband),(Select concat(concat(concat(app.firstname, ' '), app.middlename, ' '), app.lastname) as wife_name from egmrs_applicant app where app.id = reg.wife),reg.dateofmarriage,reg.applicationdate,reg.placeofmarriage, brndy.name,st.code,'Marriage Registration',state.owner_pos,state.nextaction from egmrs_registration reg,egmrs_applicant app, eg_boundary brndy,egw_status st,eg_wf_states state where reg.state_id = state.id and reg.zone = brndy.id and reg.status = st.id and st.code not in ('REGISTERED','CANCELLED') and EXTRACT(EPOCH FROM date_trunc('day',(now()-reg.applicationdate)))/60/60/24 between :fromdays and :todays ");
        params.put("fromdays", Double.valueOf(values[0]));
        params.put("todays", Double.valueOf(values[1]));
        StringBuilder queryStrForReissue = new StringBuilder(1000);
        queryStrForReissue.append("Select rei.applicationno,reg.registrationno,(Select concat(concat(concat(app.firstname, ' '), app.middlename, ' '), app.lastname) as hus_name from egmrs_applicant app where app.id = reg.husband),(Select concat(concat(concat(app.firstname, ' '), app.middlename, ' '), app.lastname) as wife_name from egmrs_applicant app where app.id = reg.wife),reg.dateofmarriage,rei.applicationdate,reg.placeofmarriage,brndy.name,st.code,'Reissue',state1.owner_pos,state1.nextaction as action1 from egmrs_reissue rei,egmrs_registration reg, egmrs_applicant app, eg_boundary brndy,egw_status st,eg_wf_states state1 where rei.state_id = state1.id and rei.registration=reg.id and rei.zone = brndy.id and rei.status = st.id and st.code not in ('CERTIFICATEREISSUED','CANCELLED') and EXTRACT(EPOCH FROM date_trunc('day',(now()-rei.applicationdate)))/60/60/24 between :fromdays and :todays ");
        params.put("fromdays", Double.valueOf(values[0]));
        params.put("todays", Double.valueOf(values[1]));
        StringBuilder aggregateQueryStr = new StringBuilder();
        aggregateQueryStr.append(queryStrForRegistration.toString());
        aggregateQueryStr.append(UNION);
        aggregateQueryStr.append(queryStrForReissue.toString());
        SQLQuery query = this.getCurrentSession().createSQLQuery(aggregateQueryStr.toString());
        for (Map.Entry param : params.entrySet()) {
            query.setParameter((String)param.getKey(), param.getValue());
        }
        return query.list();
    }

    @ReadOnly
    public List<String[]> searchRegistrationbyDays(int year, MarriageRegistration registration) throws ParseException {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        StringBuilder queryStrForRegAgeingDetails = new StringBuilder(1000);
        queryStrForRegAgeingDetails.append("(Select EXTRACT(EPOCH FROM date_trunc('day',(now()-applicationdate)))/60/60/24, count(*),st.code from egmrs_registration reg,egw_status st,egmrs_registrationunit ru,eg_boundary brndy where reg.zone=brndy.id and reg.registrationunit=ru.id and status = st.id and st.code not in ('REGISTERED','CANCELLED') and extract(year from applicationdate)=:year ");
        params.put(INPUTYEAR, year);
        if (registration.getMarriageRegistrationUnit().getId() != null) {
            queryStrForRegAgeingDetails.append("  and reg.registrationunit=:regunit ");
            params.put(REGUNIT, registration.getMarriageRegistrationUnit().getId().intValue());
        }
        if (registration.getZone() != null && registration.getZone().getId() != null) {
            queryStrForRegAgeingDetails.append(" and  reg.zone=:zone ");
            params.put(ZONE, registration.getZone().getId().intValue());
        }
        queryStrForRegAgeingDetails.append(" group by st.code,EXTRACT(EPOCH FROM date_trunc('day',(now()-applicationdate)))/60/60/24 order by EXTRACT(EPOCH FROM date_trunc('day',(now()-applicationdate)))/60/60/24 ) ");
        StringBuilder queryStrForReIssueAgeingDetails = new StringBuilder(1000);
        queryStrForReIssueAgeingDetails.append("(Select EXTRACT(EPOCH FROM date_trunc('day',(now()-applicationdate)))/60/60/24, count(*),st.code from egmrs_reissue rei,egw_status st,egmrs_registrationunit ru,eg_boundary brndy where  rei.registrationunit=ru.id and  rei.zone=brndy.id and status = st.id and st.code not in ('CERTIFICATEREISSUED','CANCELLED') and extract(year from applicationdate)=:year  ");
        params.put(INPUTYEAR, year);
        if (registration.getMarriageRegistrationUnit().getId() != null) {
            queryStrForReIssueAgeingDetails.append("  and rei.registrationunit=:regunit ");
            params.put(REGUNIT, registration.getMarriageRegistrationUnit().getId().intValue());
        }
        if (registration.getZone() != null && registration.getZone().getId() != null) {
            queryStrForReIssueAgeingDetails.append(" and  rei.zone=:zone ");
            params.put(ZONE, registration.getZone().getId().intValue());
        }
        queryStrForReIssueAgeingDetails.append(" group by st.code,EXTRACT(EPOCH FROM date_trunc('day',(now()-applicationdate)))/60/60/24 order by EXTRACT(EPOCH FROM date_trunc('day',(now()-applicationdate)))/60/60/24) ");
        StringBuilder aggregateQueryStr = new StringBuilder();
        aggregateQueryStr.append(queryStrForRegAgeingDetails.toString());
        aggregateQueryStr.append(UNION);
        aggregateQueryStr.append(queryStrForReIssueAgeingDetails.toString());
        SQLQuery query = this.getCurrentSession().createSQLQuery(aggregateQueryStr.toString());
        for (Map.Entry param : params.entrySet()) {
            query.setParameter((String)param.getKey(), param.getValue());
        }
        return query.list();
    }

    @ReadOnly
    public List<String[]> getCountOfApplnsStatusWise(String status, Date fromDate, Date toDate, MarriageRegistrationUnit registrationUnit, MarriageRegistration registration) {
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuilder queryStrForRegCount = new StringBuilder(1000);
        queryStrForRegCount.append("select regunit.name,st.code,count(*) from egmrs_registration reg,egmrs_registrationunit regunit,egw_status st where reg.registrationunit=regunit.id and reg.status = st.id  ");
        if (fromDate != null) {
            queryStrForRegCount.append(" and applicationdate >= to_timestamp(:fromdate,'yyyy-MM-dd HH24:mi:ss')");
            params.put(FROMDATE, this.sf.format(this.resetFromDateTimeStamp(fromDate)));
        }
        if (toDate != null) {
            queryStrForRegCount.append(" and applicationdate <=to_timestamp(:todate,'YYYY-MM-DD HH24:MI:SS') ");
            params.put(TODATE, this.sf.format(this.resetToDateTimeStamp(toDate)));
        }
        if (status != null && ALL.equalsIgnoreCase(status)) {
            queryStrForRegCount.append(" and st.code in ('CREATED','APPROVED','REGISTERED','REJECTED','CANCELLED')");
        } else if (status != null) {
            queryStrForRegCount.append(" and st.code=:status ");
            params.put(STATUS, status);
        }
        if (registrationUnit.getId() != null) {
            queryStrForRegCount.append(" and  reg.registrationunit=to_number(:regunitid,'999999') ");
            params.put("regunitid", registrationUnit.getId().toString());
        }
        if (registration.getZone().getId() != null) {
            queryStrForRegCount.append(REG_ZONE_WHERE_CONDITION);
            params.put(ZONE, registration.getZone().getId().toString());
        }
        queryStrForRegCount.append(" group by regunit.name,st.code order by regunit.name desc");
        SQLQuery query = this.getCurrentSession().createSQLQuery(queryStrForRegCount.toString());
        for (Map.Entry param : params.entrySet()) {
            query.setParameter((String)param.getKey(), param.getValue());
        }
        return query.list();
    }

    @ReadOnly
    public List<MarriageRegistration> searchRegistrationByStatusForReport(String registrationUnit, String status, Date fromDate, Date toDate) throws ParseException {
        Criteria criteria = this.getCurrentSession().createCriteria(MarriageRegistration.class, MARRIAGE_REGISTRATION).createAlias(MARRIAGE_REGISTRATION_STATUS, STATUS);
        if (fromDate != null) {
            criteria.add((Criterion)Restrictions.ge((String)MARRIAGE_REGISTRATION_APPLICATION_DATE, (Object)this.resetFromDateTimeStamp(fromDate)));
        }
        if (fromDate != null) {
            criteria.add((Criterion)Restrictions.le((String)MARRIAGE_REGISTRATION_APPLICATION_DATE, (Object)this.resetToDateTimeStamp(toDate)));
        }
        if (registrationUnit != null) {
            criteria.createAlias("marriageRegistration.marriageRegistrationUnit", MARRIAGE_REGISTRATION_UNIT).add((Criterion)Restrictions.eq((String)"marriageRegistrationUnit.name", (Object)registrationUnit.replaceAll("[^a-zA-Z0-9]", " ")));
        }
        if (status != null && !ALL.equalsIgnoreCase(status)) {
            criteria.add(Restrictions.in((String)STATUS_DOT_CODE, (Object[])new String[]{status}));
        } else {
            criteria.add(Restrictions.in((String)STATUS_DOT_CODE, (Object[])new String[]{"CREATED", "APPROVED", "REGISTERED", "REJECTED", "CANCELLED"}));
        }
        return criteria.list();
    }

    public List<SearchResult> getUlbWiseReligionDetails(SearchModel searchRequest) {
        SearchResponse ulbWiseResponse;
        try {
            ulbWiseResponse = this.findAllReligionByUlbName(searchRequest, this.getQueryFilter(searchRequest));
        }
        catch (ParseException e) {
            throw new ApplicationRuntimeException("Error Occured while fetching records from elastic search", (Throwable)e);
        }
        ArrayList<SearchResult> responseDetailsList = new ArrayList<SearchResult>();
        Terms ulbs = (Terms)ulbWiseResponse.getAggregations().get("groupByUlbName");
        for (Terms.Bucket ulb : ulbs.getBuckets()) {
            long countOthers = 0L;
            long total = 0L;
            SearchResult searchResult = new SearchResult();
            searchResult.setUlbName(ulb.getKeyAsString());
            Terms religions = (Terms)ulb.getAggregations().get("groupByReligion");
            for (Terms.Bucket religion : religions.getBuckets()) {
                if ("Christianity".equals(religion.getKeyAsString())) {
                    total += religion.getDocCount();
                    searchResult.setChristian(religion.getDocCount());
                    continue;
                }
                if ("Hinduism".equals(religion.getKeyAsString())) {
                    total += religion.getDocCount();
                    searchResult.setHindu(religion.getDocCount());
                    continue;
                }
                if ("Islam".equals(religion.getKeyAsString())) {
                    total += religion.getDocCount();
                    searchResult.setMuslim(religion.getDocCount());
                    continue;
                }
                total += religion.getDocCount();
                countOthers += religion.getDocCount();
            }
            searchResult.setOthers(countOthers);
            searchResult.setTotal(total);
            responseDetailsList.add(searchResult);
        }
        return responseDetailsList;
    }

    public BoolQueryBuilder getQueryFilter(SearchModel searchRequest) throws ParseException {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"ulbName", (Object)searchRequest.getUlbName()));
        SimpleDateFormat formatter = new SimpleDateFormat(YYYY_MM_DD);
        Date fromDate = formatter.parse(searchRequest.getYear() + "/" + 1 + "/" + 1);
        Date toDate = formatter.parse(searchRequest.getYear() + "/" + 12 + "/" + 31);
        if (fromDate != null && toDate != null) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"registrationDate").from((Object)fromDate).to((Object)toDate));
        }
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"applicationStatus", (Object)"Registered"));
        return boolQuery;
    }

    public List<MarriageRegistrationIndex> getSearchResultByBoolQuery(BoolQueryBuilder boolQuery, FieldSortBuilder sort) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"marriageregistration"}).withQuery((QueryBuilder)boolQuery).withSort((SortBuilder)sort).build();
        return this.elasticsearchTemplate.queryForList((SearchQuery)searchQuery, MarriageRegistrationIndex.class);
    }

    public SearchResponse findAllReligionByUlbName(SearchModel searchRequest, BoolQueryBuilder query) {
        return (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"marriageregistration"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)MarriageRegistrationReportsService.getCountWithGrouping("groupByUlbName", "ulbName", 120).subAggregation(MarriageRegistrationReportsService.getCountWithGrouping("groupByReligion", "husbandReligion", 30))).execute().actionGet();
    }

    public static AggregationBuilder<?> getCountWithGrouping(String aggregationName, String fieldName, int size) {
        return ((TermsBuilder)AggregationBuilders.terms((String)aggregationName).field(fieldName)).size(size);
    }

    public ResponseEntity<byte[]> generateReligionWiseReport(int year, List<SearchResult> searchResponse, HttpSession session, HttpServletRequest request) {
        HttpHeaders headers = new HttpHeaders();
        ReportOutput reportOutput = new ReportOutput();
        String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
        String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
        String cityLogo = url.concat("/egi");
        reportOutput = this.generateReportOutputForReligionWiseReport(year, searchResponse, cityName, cityLogo);
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=WorkOrderNotice.pdf");
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    public ReportOutput generateReportOutputForReligionWiseReport(int year, List<SearchResult> searchResponse, String cityName, String logoPath) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        reportParams.put("cityName", cityName);
        reportParams.put("logoPath", logoPath);
        reportParams.put(INPUTYEAR, year);
        reportParams.put("remarks", "");
        reportParams.put("searchResponse", searchResponse);
        ReportRequest reportInput = new ReportRequest("printreligionwisereport", searchResponse, reportParams);
        return this.reportService.createReport(reportInput);
    }
}

